/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.popupnotifications;

import java.util.LinkedHashSet;
import java.util.Set;
import name.schedenig.eclipse.popupnotifications.IAnimationListener;
import org.eclipse.swt.widgets.Display;

public class Animation
implements Runnable {
    private Set<IAnimationListener> listeners = new LinkedHashSet<IAnimationListener>();
    private int duration;
    private int step;
    private long start;
    private Display display;
    private volatile boolean cancel;

    public Animation(Display display, int duration, int step) {
        this.display = display;
        this.duration = duration;
        this.step = step;
    }

    public void addListener(IAnimationListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IAnimationListener listener) {
        this.listeners.remove(listener);
    }

    public void start() {
        this.start = System.currentTimeMillis();
        this.display.timerExec(this.step, (Runnable)this);
    }

    @Override
    public void run() {
        boolean keepRunning;
        boolean bl = keepRunning = !this.cancel;
        if (keepRunning) {
            long time = System.currentTimeMillis() - this.start;
            keepRunning = this.update(time);
        }
        if (keepRunning) {
            this.display.timerExec(this.step, (Runnable)this);
        } else {
            for (IAnimationListener listener : this.listeners) {
                listener.animationDone(this);
            }
        }
    }

    protected boolean update(long time) {
        return time < (long)this.duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }
}

