/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.popupnotifications;

import name.schedenig.eclipse.popupnotifications.Animation;
import name.schedenig.eclipse.popupnotifications.FadeAnimation;
import name.schedenig.eclipse.popupnotifications.IAnimationListener;
import name.schedenig.eclipse.popupnotifications.INotificationStyle;
import name.schedenig.eclipse.popupnotifications.Notification;
import name.schedenig.eclipse.popupnotifications.PopupNotificationManager;
import name.schedenig.eclipse.popupnotifications.PopupNotificationState;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PopupNotification {
    private PopupNotificationManager manager;
    private Shell shell;
    private boolean disposed = false;
    private Notification notification;
    private PopupNotificationState state;
    private int duration;
    private boolean mouseInside;
    private Animation animation;

    public PopupNotification(PopupNotificationManager manager, Notification notification, int duration) {
        this.manager = manager;
        this.notification = notification;
        this.duration = duration;
        this.init();
    }

    public void init() {
        INotificationStyle style = this.notification.getStyle();
        if (style == null) {
            style = this.manager.getDefaultNotificationStyle();
        }
        Display display = this.manager.getDisplay();
        this.shell = new Shell(display, 540680);
        this.shell.setBackgroundMode(1);
        FillLayout shellLayout = new FillLayout();
        shellLayout.marginWidth = shellLayout.marginHeight = style.getBorderWidth();
        this.shell.setLayout((Layout)shellLayout);
        this.shell.setForeground(style.getForeground());
        this.shell.setBackground(style.getBorder());
        Composite content = new Composite((Composite)this.shell, 0);
        content.setEnabled(false);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = layout.marginHeight = style.getBorderOffset();
        content.setLayout((Layout)layout);
        content.setBackground(style.getBackground());
        Image image = style.getImage();
        Label labelImage = null;
        if (image != null) {
            labelImage = new Label(content, 0);
            labelImage.setImage(image);
            labelImage.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true, 1, 1));
        }
        String title = this.notification.getTitle();
        Label labelTitle = new Label(content, 0);
        labelTitle.setText(title == null ? "" : title);
        labelTitle.setFont(style.getTitleFont());
        labelTitle.setForeground(style.getForeground());
        labelTitle.setLayoutData((Object)new GridData(1, 0x1000000, true, true, image == null ? 2 : 1, 1));
        String msg = this.notification.getMessage();
        Label labelMessage = new Label(content, 0);
        labelMessage.setText(msg == null ? "" : msg);
        labelMessage.setFont(style.getMessageFont());
        labelMessage.setForeground(style.getForeground());
        labelMessage.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                PopupNotification.this.notification.fireNotificationClicked();
            }
        };
        this.shell.addMouseListener((MouseListener)mouseListener);
        content.addMouseListener((MouseListener)mouseListener);
        labelTitle.addMouseListener((MouseListener)mouseListener);
        labelMessage.addMouseListener((MouseListener)mouseListener);
        if (labelImage != null) {
            labelImage.addMouseListener((MouseListener)mouseListener);
        }
        this.shell.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                PopupNotification.this.shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PopupNotification.this.setMouseInside(false);
                    }
                });
            }

            public void mouseEnter(MouseEvent e) {
                PopupNotification.this.shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PopupNotification.this.setMouseInside(true);
                    }
                });
            }
        });
        this.shell.pack();
    }

    private void setMouseInside(boolean mouseInside) {
        if (mouseInside == this.mouseInside) {
            return;
        }
        this.mouseInside = mouseInside;
        if (mouseInside && this.state == PopupNotificationState.DISAPPEARING) {
            this.setState(PopupNotificationState.READY_TO_DISAPPEAR);
        } else if (!mouseInside && this.state == PopupNotificationState.READY_TO_DISAPPEAR) {
            this.setState(PopupNotificationState.DISAPPEARING);
        }
    }

    public PopupNotificationState getState() {
        return this.state;
    }

    public void setState(PopupNotificationState state) {
        this.state = state;
        if (this.shell.isDisposed()) {
            return;
        }
        if (this.animation != null) {
            this.animation.setCancel(true);
            this.animation = null;
        }
        if (state == PopupNotificationState.READY_TO_DISAPPEAR && !this.mouseInside) {
            state = PopupNotificationState.DISAPPEARING;
        }
        switch (state) {
            case APPEARING: {
                this.animation = new FadeAnimation(this.shell, this.manager.getAppearDuration(), this.manager.getTimerInterval(), 0, this.manager.getAlpha());
                this.animation.addListener(new IAnimationListener(){

                    @Override
                    public void animationDone(Animation animation) {
                        if (animation == PopupNotification.this.animation) {
                            PopupNotification.this.animation = null;
                            PopupNotification.this.setState(PopupNotificationState.WAITING);
                        }
                    }
                });
                this.animation.start();
                break;
            }
            case WAITING: {
                this.shell.setAlpha(this.manager.getAlpha());
                this.animation = new Animation(this.shell.getDisplay(), this.duration, this.manager.getTimerInterval());
                this.animation.addListener(new IAnimationListener(){

                    @Override
                    public void animationDone(Animation animation) {
                        if (animation == PopupNotification.this.animation) {
                            PopupNotification.this.animation = null;
                            PopupNotification.this.setState(PopupNotificationState.READY_TO_DISAPPEAR);
                        }
                    }
                });
                this.animation.start();
                break;
            }
            case READY_TO_DISAPPEAR: {
                this.shell.setAlpha(this.manager.getAlpha());
                break;
            }
            case DISAPPEARING: {
                this.animation = new FadeAnimation(this.shell, this.manager.getDisappearDuration(), this.manager.getTimerInterval(), this.shell.getAlpha(), 0);
                this.animation.addListener(new IAnimationListener(){

                    @Override
                    public void animationDone(Animation animation) {
                        if (animation == PopupNotification.this.animation) {
                            PopupNotification.this.animation = null;
                            if (PopupNotification.this.shell.isDisposed()) {
                                return;
                            }
                            PopupNotification.this.shell.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (PopupNotification.this.shell.isDisposed()) {
                                        return;
                                    }
                                    PopupNotification.this.shell.setVisible(false);
                                    PopupNotification.this.manager.removeNotification(PopupNotification.this);
                                }
                            });
                        }
                    }
                });
                this.animation.start();
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            boolean appear = this.manager.getAppearDuration() > 0;
            this.shell.setAlpha(appear ? 0 : this.manager.getAlpha());
            this.shell.setVisible(true);
            this.setState(appear ? PopupNotificationState.APPEARING : PopupNotificationState.WAITING);
        } else {
            this.shell.setVisible(false);
        }
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.setVisible(false);
            this.shell.dispose();
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public Rectangle getBounds() {
        return this.shell.isDisposed() ? null : this.shell.getBounds();
    }

    public void setBounds(Rectangle bounds) {
        this.shell.setBounds(bounds);
    }

    public Notification getNotification() {
        return this.notification;
    }
}

