/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.popupnotifications.preferences;

import name.schedenig.eclipse.popupnotifications.gui.ColorPickerLine;
import name.schedenig.eclipse.popupnotifications.utils.PopupNotificationsUtil;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class ColorPickerFieldEditor
extends FieldEditor {
    private ColorPickerLine colorPickerLine;
    private String labelText;
    private String dialogTitle;
    private RGB oldValue;

    public ColorPickerFieldEditor(String preferenceName, String labelText, String dialogTitle, Composite parent) {
        this.labelText = labelText;
        this.dialogTitle = dialogTitle;
        this.setPreferenceName(preferenceName);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.colorPickerLine.getTextControl().getLayoutData()).horizontalSpan = Math.max(1, numColumns - 2);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.colorPickerLine = new ColorPickerLine(parent);
        this.colorPickerLine.setText(this.labelText);
        this.colorPickerLine.setDialogTitle(this.dialogTitle);
        ((GridData)this.colorPickerLine.getTextControl().getLayoutData()).horizontalSpan = Math.max(1, numColumns - 2);
        this.colorPickerLine.addListener(new ColorPickerLine.IColorChangeListener(){

            @Override
            public void colorChanged(ColorPickerLine source, RGB color) {
                ColorPickerFieldEditor.this.valueChanged();
            }
        });
    }

    protected void doLoad() {
        if (this.colorPickerLine != null) {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            RGB rgb = PopupNotificationsUtil.stringToRgb(value);
            this.colorPickerLine.setColor(rgb);
            this.oldValue = rgb;
        }
    }

    protected void doLoadDefault() {
        if (this.colorPickerLine != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            RGB rgb = PopupNotificationsUtil.stringToRgb(value);
            this.colorPickerLine.setColor(rgb);
        }
        this.valueChanged();
    }

    private void valueChanged() {
        RGB newValue = this.colorPickerLine.getColor();
        if (newValue == this.oldValue) {
            return;
        }
        if (newValue == null && this.oldValue != null || newValue != null && this.oldValue == null || !newValue.equals((Object)this.oldValue)) {
            this.fireValueChanged("field_editor_value", this.oldValue, newValue);
            this.oldValue = newValue;
        }
    }

    protected void doStore() {
        String s = PopupNotificationsUtil.rgbToString(this.colorPickerLine.getEffectiveColor());
        this.getPreferenceStore().setValue(this.getPreferenceName(), s);
    }

    public int getNumberOfControls() {
        return 3;
    }
}

