/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.popupnotifications.preferences;

import java.text.MessageFormat;
import name.schedenig.eclipse.popupnotifications.i18n.Messages;
import name.schedenig.eclipse.popupnotifications.utils.PopupNotificationsUtil;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Text;

public class FontPickerFieldEditor
extends FieldEditor {
    private String labelText;
    private FontData oldFont;
    private FontData font;
    private String dialogTitle;
    private Button checkBox;
    private Text text;
    private Button button;

    public FontPickerFieldEditor(String preferenceName, String labelText, String dialogTitle, Composite parent) {
        this.labelText = labelText;
        this.dialogTitle = dialogTitle;
        this.setPreferenceName(preferenceName);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.text.getLayoutData()).horizontalSpan = Math.max(1, numColumns - 2);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.checkBox = new Button(parent, 32);
        this.checkBox.setText(this.labelText);
        this.checkBox.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FontPickerFieldEditor.this.checkBox.getSelection() && FontPickerFieldEditor.this.font == null) {
                    FontPickerFieldEditor.this.pickFont();
                    if (FontPickerFieldEditor.this.font == null) {
                        FontPickerFieldEditor.this.checkBox.setSelection(false);
                    }
                }
            }
        });
        this.text = new Text(parent, 2056);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.button = new Button(parent, 8);
        this.button.setText(Messages.FontPickerFieldEditor_label_edit);
        this.button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontPickerFieldEditor.this.pickFont();
            }
        });
    }

    protected void pickFont() {
        FontDialog fontDialog = new FontDialog(this.button.getShell());
        fontDialog.setText(this.dialogTitle);
        fontDialog.setFontList(new FontData[]{this.font});
        FontData newFont = fontDialog.open();
        if (newFont != null) {
            this.setFont(newFont);
        }
    }

    private void setFont(FontData font) {
        if (PopupNotificationsUtil.equals(font, this.font)) {
            return;
        }
        this.font = font;
        this.checkBox.setSelection(font != null);
        this.refresh(false);
        this.valueChanged();
    }

    private void refresh(boolean updateCheckbox) {
        if (this.font == null) {
            this.text.setText("");
        } else {
            String pattern = Messages.FontPickerFieldEditor_label_font_name;
            this.text.setText(MessageFormat.format(pattern, this.font.getName(), this.font.getHeight(), this.font.getStyle() & 1, this.font.getStyle() & 2));
        }
        if (updateCheckbox) {
            this.checkBox.setSelection(this.font != null);
        }
    }

    protected void doLoad() {
        this.font = this.getPreferenceStore().getString(this.getPreferenceName()).length() == 0 ? null : PreferenceConverter.getFontData((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName());
        this.refresh(true);
    }

    protected void doLoadDefault() {
        this.font = this.getPreferenceStore().getDefaultString(this.getPreferenceName()).length() == 0 ? null : PreferenceConverter.getDefaultFontData((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName());
        this.refresh(true);
        this.valueChanged();
    }

    private void valueChanged() {
        if (this.font == this.oldFont) {
            return;
        }
        if (this.font == null && this.oldFont != null || this.font != null && this.oldFont == null || !this.font.equals((Object)this.oldFont)) {
            this.fireValueChanged("field_editor_value", this.oldFont, this.font);
            this.oldFont = this.font;
        }
    }

    protected void doStore() {
        if (this.font == null || !this.checkBox.getSelection()) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
        } else {
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)this.getPreferenceName(), (FontData)this.font);
        }
    }

    public int getNumberOfControls() {
        return 3;
    }
}

