/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.model.antlr;

import java.util.LinkedList;
import org.antlr.runtime.CharStream;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.sweetlemonade.eclipse.json.model.antlr.IllegalParseStateException;

public class DocumentCharStream
implements CharStream {
    private final IDocument mDocument;
    private int mPos = 0;
    private final LinkedList<Integer> mMarks = new LinkedList();

    public DocumentCharStream(IDocument document) {
        this.mDocument = document;
    }

    public int LA(int i) {
        block6: {
            block5: {
                try {
                    if (i == 0) {
                        return this.mDocument.getChar(this.mPos);
                    }
                    if (i >= 0 || this.mPos + ++i - 1 >= 0) break block5;
                    return -1;
                }
                catch (BadLocationException badLocationException) {
                    return -1;
                }
            }
            if (this.mPos + i - 1 < this.mDocument.getLength()) break block6;
            return -1;
        }
        return this.mDocument.getChar(this.mPos + i - 1);
    }

    public void consume() {
        if (this.mPos < this.mDocument.getLength()) {
            ++this.mPos;
        }
    }

    public String getSourceName() {
        return null;
    }

    public int index() {
        return this.mPos;
    }

    public int mark() {
        int index = this.index();
        this.mMarks.addLast(index);
        return this.mMarks.size() - 1;
    }

    public void release(int i) {
        int size = this.mMarks.size();
        int j = size - 1;
        while (j > i) {
            this.mMarks.removeLast();
            ++j;
        }
    }

    public void rewind() {
        this.seek(this.mMarks.removeLast());
    }

    public void rewind(int i) {
        this.release(i);
        this.rewind();
    }

    public void seek(int i) {
        this.mPos = i;
        int length = this.mDocument.getLength();
        if (this.mPos >= length) {
            this.mPos = length - 1;
        }
    }

    public int size() {
        return this.mDocument.getLength();
    }

    public int LT(int i) {
        return this.LA(i);
    }

    public int getCharPositionInLine() {
        try {
            return this.mPos - this.mDocument.getLineInformationOfOffset(this.mPos).getOffset();
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalParseStateException();
        }
    }

    public int getLine() {
        try {
            return this.mDocument.getLineOfOffset(this.mPos);
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalParseStateException();
        }
    }

    public void setCharPositionInLine(int i) {
        throw new UnsupportedOperationException();
    }

    public void setLine(int i) {
        throw new UnsupportedOperationException();
    }

    public String substring(int start, int stop) {
        try {
            return this.mDocument.get(start, stop - start + 1);
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalParseStateException();
        }
    }
}

