/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.preference;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.sweetlemonade.eclipse.json.JsonPlugin;

public class JsonPreferencesInitializer
extends AbstractPreferenceInitializer {
    public static final String PREF_SAVE_AS_ON_SAVE = "saveAsOnSave";
    public static final String PREF_VALIDATE = "validate";
    public static final String PREF_MAX_ERROR = "maxError";
    public static final String PREF_AUTO_FORMAT_ON_SAVE = "autoFormatOnSave";
    public static final String PREF_WRAP_ARRAY = "wrapArray";
    public static final String PREF_WRAP_OBJECT = "wrapObject";
    public static final String PREF_ARRAY_BRACKETS_NEW_LINE = "arrayBrackets";
    public static final String PREF_OBJECT_BRACKETS_NEW_LINE = "objectBrackets";
    public static final String PREF_SPACE_AFTER_COMMA = "spaceAfterComma";
    public static final String PREF_SPACE_AFTER_COLON = "spaceAfterColon";
    public static final String PREF_SPACE_BEFORE_COLON = "spaceBeforeColon";
    public static final String PREF_BLANK_LINE_AFTER_COMPLEX = "newLineAfterComplex";
    public static final String PREF_SPACE_AFTER_OBJECT_OPEN = "spaceAfterObjectOpen";
    public static final String PREF_SPACE_BEFORE_OBJECT_CLOSE = "spaceAfterObjectClose";
    public static final String PREF_SPACE_AFTER_ARRAY_OPEN = "spaceAfterArrayOpen";
    public static final String PREF_SPACE_BEFORE_ARRAY_CLOSE = "spaceAfterArrayClose";
    public static final String[] FORMAT_KEYS = new String[]{"autoFormatOnSave", "wrapArray", "wrapObject", "arrayBrackets", "objectBrackets", "spaceAfterComma", "spaceAfterColon", "spaceBeforeColon", "newLineAfterComplex", "spaceAfterObjectOpen", "spaceAfterObjectClose", "spaceAfterArrayOpen", "spaceAfterArrayClose"};
    public static final String PREF_COLOR_MATCH_BRACKET = "colorMatchBracket";
    public static final String PREF_COLOR_BRACKET = "colorBracket";
    public static final String PREF_COLOR_OBJECT_BRACKET = "colorObjectBracket";
    public static final String PREF_COLOR_ARRAY_BRACKET = "colorArrayBracket";
    public static final String PREF_COLOR_KEY = "colorKey";
    public static final String PREF_COLOR_STRING = "colorString";
    public static final String PREF_COLOR_NUMBER = "colorNumber";
    public static final String PREF_COLOR_BOOLEAN = "colorBoolean";
    public static final String PREF_COLOR_NULL = "colorNull";
    public static final String PREF_COLOR_DEFAULT = "colorDefault";
    public static final String PREF_ENABLED_MATCH_BRACKET = "colorMatchBracketEnabled";
    public static final String PREF_ENABLED_BRACKET = "colorBracketEnabled";
    public static final String PREF_ENABLED_OBJECT_BRACKET = "colorObjectBracketEnabled";
    public static final String PREF_ENABLED_ARRAY_BRACKET = "colorArrayBracketEnabled";
    public static final String PREF_ENABLED_KEY = "colorKeyEnabled";
    public static final String PREF_ENABLED_STRING = "colorStringEnabled";
    public static final String PREF_ENABLED_NUMBER = "colorNumberEnabled";
    public static final String PREF_ENABLED_BOOLEAN = "colorBooleanEnabled";
    public static final String PREF_ENABLED_NULL = "colorNullEnabled";
    public static final String PREF_ENABLED_DEFAULT = "colorDefaultEnabled";
    public static final String PREF_MATCH_BRACKET_STYLE = "colorMatchBracketStyle";
    public static final String PREF_BRACKET_STYLE = "colorBracketStyle";
    public static final String PREF_OBJECT_BRACKET_STYLE = "colorObjectBracketStyle";
    public static final String PREF_ARRAY_BRACKET_STYLE = "colorArrayBracketStyle";
    public static final String PREF_KEY_STYLE = "colorKeyStyle";
    public static final String PREF_STRING_STYLE = "colorStringStyle";
    public static final String PREF_NUMBER_STYLE = "colorNumberStyle";
    public static final String PREF_BOOLEAN_STYLE = "colorBooleanStyle";
    public static final String PREF_NULL_STYLE = "colorNullStyle";
    public static final String PREF_DEFAULT_STYLE = "colorDefaultStyle";

    public void initializeDefaultPreferences() {
        TokenType[] values;
        IPreferenceStore store = JsonPlugin.getDefault().getPreferenceStore();
        store.setDefault(PREF_SAVE_AS_ON_SAVE, false);
        store.setDefault(PREF_VALIDATE, true);
        store.setDefault(PREF_MAX_ERROR, 0);
        store.setDefault(PREF_AUTO_FORMAT_ON_SAVE, false);
        store.setDefault(PREF_WRAP_ARRAY, true);
        store.setDefault(PREF_WRAP_OBJECT, true);
        store.setDefault(PREF_ARRAY_BRACKETS_NEW_LINE, true);
        store.setDefault(PREF_OBJECT_BRACKETS_NEW_LINE, true);
        store.setDefault(PREF_SPACE_AFTER_COMMA, false);
        store.setDefault(PREF_SPACE_AFTER_COLON, true);
        store.setDefault(PREF_SPACE_BEFORE_COLON, false);
        store.setDefault(PREF_BLANK_LINE_AFTER_COMPLEX, true);
        store.setDefault(PREF_SPACE_AFTER_ARRAY_OPEN, false);
        store.setDefault(PREF_SPACE_BEFORE_ARRAY_CLOSE, false);
        store.setDefault(PREF_SPACE_AFTER_OBJECT_OPEN, false);
        store.setDefault(PREF_SPACE_BEFORE_OBJECT_CLOSE, false);
        TokenType[] tokenTypeArray = values = TokenType.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            TokenType colorType = tokenTypeArray[n2];
            store.setDefault(colorType.mKey, StringConverter.asString((RGB)colorType.mDef));
            store.setDefault(colorType.mEnabledKey, colorType.mEnabledDef);
            store.setDefault(colorType.mStyleKey, colorType.mStyleDef);
            ++n2;
        }
    }

    public static enum TokenType {
        MATCHED_BRACKET("colorMatchBracket", "colorMatchBracketEnabled", "colorMatchBracketStyle", new RGB(0, 0, 0), true, 0),
        BRACKETS("colorBracket", "colorBracketEnabled", "colorBracketStyle", new RGB(0, 0, 0), false, 0),
        OBJECT_BRACKETS("colorObjectBracket", "colorObjectBracketEnabled", "colorObjectBracketStyle", new RGB(0, 0, 0), false, 0){

            @Override
            public RGB getColor(IPreferenceStore store) {
                if (!this.isEnabled(store)) {
                    return BRACKETS.getColor(store);
                }
                return super.getColor(store);
            }
        }
        ,
        ARRAY_BRACKETS("colorArrayBracket", "colorArrayBracketEnabled", "colorArrayBracketStyle", new RGB(0, 0, 0), false, 0){

            @Override
            public RGB getColor(IPreferenceStore store) {
                if (!this.isEnabled(store)) {
                    return BRACKETS.getColor(store);
                }
                return super.getColor(store);
            }
        }
        ,
        KEYS("colorKey", "colorKeyEnabled", "colorKeyStyle", new RGB(0, 128, 0), true, 0){

            @Override
            public RGB getColor(IPreferenceStore store) {
                if (!this.isEnabled(store)) {
                    return STRINGS.getColor(store);
                }
                return super.getColor(store);
            }
        }
        ,
        STRINGS("colorString", "colorStringEnabled", "colorStringStyle", new RGB(0, 0, 255), true, 0),
        NUMBERS("colorNumber", "colorNumberEnabled", "colorNumberStyle", new RGB(128, 64, 64), true, 0),
        BOOLEANS("colorBoolean", "colorBooleanEnabled", "colorBooleanStyle", new RGB(0, 0, 0), false, 0),
        NULL("colorNull", "colorNullEnabled", "colorNullStyle", new RGB(0, 0, 0), false, 0),
        DEFAULT("colorDefault", "colorDefaultEnabled", "colorDefaultStyle", new RGB(0, 0, 0), true, 0);

        private final String mKey;
        private final RGB mDef;
        private final boolean mEnabledDef;
        private final String mEnabledKey;
        private final String mStyleKey;
        private final int mStyleDef;

        private TokenType(String key, String enabledKey, String styleKey, RGB def, boolean enabledDef, int styleDef) {
            this.mKey = key;
            this.mEnabledKey = enabledKey;
            this.mDef = def;
            this.mEnabledDef = enabledDef;
            this.mStyleDef = styleDef;
            this.mStyleKey = styleKey;
        }

        public int getStyle(IPreferenceStore store) {
            if (!this.isEnabled(store)) {
                return DEFAULT.getStyle(store);
            }
            return store.getInt(this.mStyleKey);
        }

        public int getOwnStyle(IPreferenceStore store) {
            return store.getInt(this.mStyleKey);
        }

        public RGB getColor(IPreferenceStore store) {
            if (!this.isEnabled(store)) {
                return DEFAULT.getColor(store);
            }
            return StringConverter.asRGB((String)store.getString(this.mKey));
        }

        public RGB getOwnColor(IPreferenceStore store) {
            return StringConverter.asRGB((String)store.getString(this.mKey));
        }

        public boolean isEnabled(IPreferenceStore store) {
            return store.getBoolean(this.mEnabledKey);
        }

        public String getKey() {
            return this.mKey;
        }

        public String getEnabledKey() {
            return this.mEnabledKey;
        }

        public String getStyleKey() {
            return this.mStyleKey;
        }
    }
}

