/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.preference.format;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.sweetlemonade.eclipse.json.JsonPlugin;
import org.sweetlemonade.eclipse.json.preference.JsonPreferencesInitializer;
import org.sweetlemonade.eclipse.json.preference.PseudoPreferenceStore;
import org.sweetlemonade.eclipse.json.preference.format.TextFormatter;

public class JsonFormatPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    private Button mWrapObject;
    private Button mWrapArray;
    private Button mNewLineObject;
    private Button mNewLineArray;
    private Button mAfterComma;
    private Button mAfterColon;
    private Button mBeforeColon;
    private Button mAfterObjectOpen;
    private Button mBeforeObjectClose;
    private Button mAfterArrayOpen;
    private Button mBeforeArrayClose;
    private Button mBlankLineAfterComplex;
    private Button mAutoFormat;
    private TextViewer mTextViewer;
    private TextFormatter mFormatter;
    private final IPreferenceStore mPreferenceStore = new PseudoPreferenceStore();

    public JsonFormatPreferencePage() {
        IPreferenceStore store = JsonPlugin.getDefault().getPreferenceStore();
        this.clonePref(store, this.mPreferenceStore);
    }

    private void clonePref(IPreferenceStore source, IPreferenceStore dest) {
        int i = 0;
        while (i < JsonPreferencesInitializer.FORMAT_KEYS.length) {
            String key = JsonPreferencesInitializer.FORMAT_KEYS[i];
            dest.setValue(key, source.getBoolean(key));
            ++i;
        }
    }

    protected Control createContents(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        appearanceComposite.setLayout((Layout)new FormLayout());
        this.mAutoFormat = new Button(appearanceComposite, 32);
        this.mAutoFormat.setData((Object)"autoFormatOnSave");
        FormData fd_btnAutoFormatOn = new FormData();
        fd_btnAutoFormatOn.top = new FormAttachment(0, 0);
        fd_btnAutoFormatOn.left = new FormAttachment(0, 0);
        this.mAutoFormat.setLayoutData((Object)fd_btnAutoFormatOn);
        this.mAutoFormat.setText("Auto format on save");
        this.mAutoFormat.addSelectionListener((SelectionListener)this);
        Group grpWrap = new Group(appearanceComposite, 0);
        grpWrap.setText("Wrap");
        grpWrap.setLayout((Layout)new FormLayout());
        FormData fd_grpWrap = new FormData();
        fd_grpWrap.top = new FormAttachment((Control)this.mAutoFormat, 10);
        fd_grpWrap.left = new FormAttachment(0, 0);
        grpWrap.setLayoutData((Object)fd_grpWrap);
        this.mWrapObject = new Button((Composite)grpWrap, 32);
        this.mWrapObject.setData((Object)"wrapObject");
        FormData fd_btnWrapObject = new FormData();
        fd_btnWrapObject.top = new FormAttachment(0, 5);
        fd_btnWrapObject.left = new FormAttachment(0, 5);
        fd_btnWrapObject.right = new FormAttachment(100, -5);
        this.mWrapObject.setLayoutData((Object)fd_btnWrapObject);
        this.mWrapObject.setText("Object");
        this.mWrapObject.addSelectionListener((SelectionListener)this);
        this.mWrapArray = new Button((Composite)grpWrap, 32);
        this.mWrapArray.setData((Object)"wrapArray");
        FormData fd_btnWrapArray = new FormData();
        fd_btnWrapArray.top = new FormAttachment((Control)this.mWrapObject, 5);
        fd_btnWrapArray.left = new FormAttachment(0, 5);
        fd_btnWrapArray.bottom = new FormAttachment(100, -5);
        this.mWrapArray.setLayoutData((Object)fd_btnWrapArray);
        this.mWrapArray.setText("Array");
        this.mWrapArray.addSelectionListener((SelectionListener)this);
        Group grpBracketOnNew = new Group(appearanceComposite, 0);
        grpBracketOnNew.setText("Bracket on new line");
        grpBracketOnNew.setLayout((Layout)new FormLayout());
        FormData fd_grpBracketOnNew = new FormData();
        fd_grpBracketOnNew.top = new FormAttachment((Control)grpWrap, 0, 128);
        fd_grpBracketOnNew.left = new FormAttachment((Control)grpWrap, 10);
        grpBracketOnNew.setLayoutData((Object)fd_grpBracketOnNew);
        this.mNewLineObject = new Button((Composite)grpBracketOnNew, 32);
        this.mNewLineObject.setData((Object)"objectBrackets");
        FormData fd_btnNewLineObjectData = new FormData();
        fd_btnNewLineObjectData.top = new FormAttachment(0, 5);
        fd_btnNewLineObjectData.left = new FormAttachment(0, 5);
        fd_btnNewLineObjectData.right = new FormAttachment(100, -5);
        this.mNewLineObject.setLayoutData((Object)fd_btnNewLineObjectData);
        this.mNewLineObject.setText("Object");
        this.mNewLineObject.addSelectionListener((SelectionListener)this);
        this.mNewLineArray = new Button((Composite)grpBracketOnNew, 32);
        this.mNewLineArray.setData((Object)"arrayBrackets");
        FormData fd_btnNewLineArray = new FormData();
        fd_btnNewLineArray.top = new FormAttachment((Control)this.mNewLineObject, 5);
        fd_btnNewLineArray.bottom = new FormAttachment(100, -5);
        fd_btnNewLineArray.left = new FormAttachment(0, 5);
        this.mNewLineArray.setLayoutData((Object)fd_btnNewLineArray);
        this.mNewLineArray.setText("Array");
        this.mNewLineArray.addSelectionListener((SelectionListener)this);
        Group grpSpaces = new Group(appearanceComposite, 0);
        grpSpaces.setText("Spaces");
        grpSpaces.setLayout((Layout)new FormLayout());
        FormData fd_grpSpaces = new FormData();
        fd_grpSpaces.top = new FormAttachment((Control)grpWrap, 10);
        fd_grpSpaces.left = new FormAttachment(0, 0);
        grpSpaces.setLayoutData((Object)fd_grpSpaces);
        this.mAfterComma = new Button((Composite)grpSpaces, 32);
        this.mAfterComma.setData((Object)"spaceAfterComma");
        FormData fd_afterComma = new FormData();
        fd_afterComma.left = new FormAttachment(0, 5);
        fd_afterComma.top = new FormAttachment(0, 5);
        this.mAfterComma.setLayoutData((Object)fd_afterComma);
        this.mAfterComma.setText("After comma");
        this.mAfterComma.addSelectionListener((SelectionListener)this);
        this.mAfterColon = new Button((Composite)grpSpaces, 32);
        this.mAfterColon.setData((Object)"spaceAfterColon");
        FormData fd_afterColon = new FormData();
        fd_afterColon.top = new FormAttachment((Control)this.mAfterComma, 5);
        fd_afterColon.left = new FormAttachment(0, 5);
        this.mAfterColon.setLayoutData((Object)fd_afterColon);
        this.mAfterColon.setText("After colon");
        this.mAfterColon.addSelectionListener((SelectionListener)this);
        this.mBeforeColon = new Button((Composite)grpSpaces, 32);
        this.mBeforeColon.setData((Object)"spaceBeforeColon");
        FormData fd_beforeColon = new FormData();
        fd_beforeColon.top = new FormAttachment((Control)this.mAfterColon, 5);
        fd_beforeColon.left = new FormAttachment(0, 5);
        this.mBeforeColon.setLayoutData((Object)fd_beforeColon);
        this.mBeforeColon.setText("Before colon");
        this.mBeforeColon.addSelectionListener((SelectionListener)this);
        this.mAfterObjectOpen = new Button((Composite)grpSpaces, 32);
        this.mAfterObjectOpen.setData((Object)"spaceAfterObjectOpen");
        FormData fd_btnObjectOpen = new FormData();
        fd_btnObjectOpen.left = new FormAttachment((Control)this.mAfterComma, 10);
        fd_btnObjectOpen.right = new FormAttachment(100, -5);
        fd_btnObjectOpen.top = new FormAttachment((Control)this.mAfterComma, 0, 128);
        this.mAfterObjectOpen.setLayoutData((Object)fd_btnObjectOpen);
        this.mAfterObjectOpen.setText("After object opening bracket");
        this.mAfterObjectOpen.addSelectionListener((SelectionListener)this);
        this.mBeforeObjectClose = new Button((Composite)grpSpaces, 32);
        this.mBeforeObjectClose.setData((Object)"spaceAfterObjectClose");
        FormData fd_btnObjectClose = new FormData();
        fd_btnObjectClose.left = new FormAttachment((Control)this.mAfterObjectOpen, 0, 16384);
        fd_btnObjectClose.right = new FormAttachment(100, -5);
        fd_btnObjectClose.top = new FormAttachment((Control)this.mAfterObjectOpen, 5);
        this.mBeforeObjectClose.setLayoutData((Object)fd_btnObjectClose);
        this.mBeforeObjectClose.setText("Before object closing bracket");
        this.mBeforeObjectClose.addSelectionListener((SelectionListener)this);
        this.mAfterArrayOpen = new Button((Composite)grpSpaces, 32);
        this.mAfterArrayOpen.setData((Object)"spaceAfterArrayOpen");
        FormData fd_btnArrayOpen = new FormData();
        fd_btnArrayOpen.left = new FormAttachment((Control)this.mAfterObjectOpen, 0, 16384);
        fd_btnArrayOpen.right = new FormAttachment(100, -5);
        fd_btnArrayOpen.top = new FormAttachment((Control)this.mBeforeObjectClose, 5);
        this.mAfterArrayOpen.setLayoutData((Object)fd_btnArrayOpen);
        this.mAfterArrayOpen.setText("After array opening bracket");
        this.mAfterArrayOpen.addSelectionListener((SelectionListener)this);
        this.mBeforeArrayClose = new Button((Composite)grpSpaces, 32);
        this.mBeforeArrayClose.setData((Object)"spaceAfterArrayClose");
        FormData fd_btnArrayClose = new FormData();
        fd_btnArrayClose.left = new FormAttachment((Control)this.mAfterObjectOpen, 0, 16384);
        fd_btnArrayClose.right = new FormAttachment(100, -5);
        fd_btnArrayClose.bottom = new FormAttachment(100, -5);
        fd_btnArrayClose.top = new FormAttachment((Control)this.mAfterArrayOpen, 5);
        this.mBeforeArrayClose.setLayoutData((Object)fd_btnArrayClose);
        this.mBeforeArrayClose.setText("Before array closing bracket");
        this.mBeforeArrayClose.addSelectionListener((SelectionListener)this);
        this.mBlankLineAfterComplex = new Button(appearanceComposite, 32);
        this.mBlankLineAfterComplex.setData((Object)"newLineAfterComplex");
        FormData fd_blankLineAfterComplex = new FormData();
        fd_blankLineAfterComplex.top = new FormAttachment((Control)grpSpaces, 10);
        fd_blankLineAfterComplex.left = new FormAttachment(0, 0);
        this.mBlankLineAfterComplex.setLayoutData((Object)fd_blankLineAfterComplex);
        this.mBlankLineAfterComplex.setText("Blank line after complex entities");
        this.mBlankLineAfterComplex.addSelectionListener((SelectionListener)this);
        this.mTextViewer = new TextViewer(appearanceComposite, 2048);
        this.mTextViewer.setEditable(false);
        StyledText styledText = this.mTextViewer.getTextWidget();
        FormData fd_styledText = new FormData();
        fd_styledText.top = new FormAttachment((Control)this.mBlankLineAfterComplex, 10);
        fd_styledText.left = new FormAttachment(0, 0);
        fd_styledText.right = new FormAttachment(100, 0);
        fd_styledText.bottom = new FormAttachment(100, 0);
        styledText.setLayoutData((Object)fd_styledText);
        this.update(this.mPreferenceStore);
        this.mFormatter = new TextFormatter(this.mTextViewer, this.mPreferenceStore);
        this.mFormatter.update();
        return appearanceComposite;
    }

    public void update(IPreferenceStore store) {
        this.mWrapObject.setSelection(store.getBoolean("wrapObject"));
        this.mWrapArray.setSelection(store.getBoolean("wrapArray"));
        this.mNewLineObject.setSelection(store.getBoolean("objectBrackets"));
        this.mNewLineArray.setSelection(store.getBoolean("arrayBrackets"));
        this.mAfterComma.setSelection(store.getBoolean("spaceAfterComma"));
        this.mAfterColon.setSelection(store.getBoolean("spaceAfterColon"));
        this.mBeforeColon.setSelection(store.getBoolean("spaceBeforeColon"));
        this.mAfterObjectOpen.setSelection(store.getBoolean("spaceAfterObjectOpen"));
        this.mBeforeObjectClose.setSelection(store.getBoolean("spaceAfterObjectClose"));
        this.mAfterArrayOpen.setSelection(store.getBoolean("spaceAfterArrayOpen"));
        this.mBeforeArrayClose.setSelection(store.getBoolean("spaceAfterArrayClose"));
        this.mBlankLineAfterComplex.setSelection(store.getBoolean("newLineAfterComplex"));
        this.mAutoFormat.setSelection(store.getBoolean("autoFormatOnSave"));
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(JsonPlugin.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.clonePref(this.mPreferenceStore, JsonPlugin.getDefault().getPreferenceStore());
        return true;
    }

    public void widgetSelected(SelectionEvent e) {
        String key = (String)e.widget.getData();
        this.mPreferenceStore.setValue(key, ((Button)e.widget).getSelection());
        this.mFormatter.update();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

