/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.preference.format;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.sweetlemonade.eclipse.json.editor.JsonFormatter;
import org.sweetlemonade.eclipse.json.model.JsonArray;
import org.sweetlemonade.eclipse.json.model.JsonElement;
import org.sweetlemonade.eclipse.json.model.JsonObject;
import org.sweetlemonade.eclipse.json.model.JsonPrimitive;

public class TextFormatter {
    private final TextViewer mViewer;
    private final JsonObject mElement;
    private final IPreferenceStore mStore;

    public TextFormatter(TextViewer viewer, IPreferenceStore store) {
        this.mViewer = viewer;
        this.mStore = store;
        this.mElement = new JsonObject(null);
        this.mElement.put("k1", (JsonElement)new JsonPrimitive(this.mElement, "val", JsonPrimitive.PrimitiveType.STRING));
        JsonObject childObject = new JsonObject(this.mElement);
        childObject.put("k", (JsonElement)new JsonPrimitive(childObject, "val", JsonPrimitive.PrimitiveType.STRING));
        this.mElement.put("k2", (JsonElement)childObject);
        JsonArray childArray = new JsonArray(this.mElement);
        childArray.add(new JsonPrimitive(childArray, "11", JsonPrimitive.PrimitiveType.NUMBER));
        childArray.add(new JsonPrimitive(childArray, "22", JsonPrimitive.PrimitiveType.NUMBER));
        childObject = new JsonObject(childArray);
        childObject.put("k", (JsonElement)new JsonPrimitive(childObject, "val", JsonPrimitive.PrimitiveType.STRING));
        childArray.add(childObject);
        childArray.add(new JsonPrimitive(childArray, "44", JsonPrimitive.PrimitiveType.NUMBER));
        this.mElement.put("k3", (JsonElement)childArray);
    }

    public void update() {
        IDocument document = this.mViewer.getDocument();
        int length = document == null ? 50 : document.getLength();
        String format = new JsonFormatter(this.mElement, this.mStore).format(length);
        if (document != null) {
            try {
                document.replace(0, length, format);
            }
            catch (BadLocationException badLocationException) {}
        } else {
            this.mViewer.setDocument((IDocument)new Document(format));
        }
    }
}

