/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public class GroupModel
implements IPersistable {
    private static final String PERSISTENCE_KEY_GROUP_MODEL = ".groupModel";
    protected IUniqueIndexLayer positionLayer;
    protected IndexPositionConverter indexPositionConverter;
    private boolean defaultCollapseable = true;
    private boolean defaultUnbreakable = false;
    private final List<Group> groups = new LinkedList<Group>();

    public GroupModel() {
        this(null);
    }

    public GroupModel(IUniqueIndexLayer positionLayer) {
        this.positionLayer = positionLayer;
    }

    List<Group> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    void setPositionLayer(IUniqueIndexLayer positionLayer, IndexPositionConverter converter) {
        this.positionLayer = positionLayer;
        this.indexPositionConverter = converter;
        this.updateVisibleStartPositions();
    }

    int getIndexByPosition(int position) {
        if (this.positionLayer != null && this.indexPositionConverter != null) {
            return this.indexPositionConverter.convertPositionToIndex(this.positionLayer, position);
        }
        return position;
    }

    int getPositionByIndex(int index) {
        if (this.positionLayer != null && this.indexPositionConverter != null) {
            return this.indexPositionConverter.convertIndexToPosition(this.positionLayer, index);
        }
        return index;
    }

    void updateVisibleStartPositions() {
        for (Group group : this.groups) {
            group.updateVisibleStartPosition();
        }
    }

    void performConsistencyCheck(boolean updateStartIndex) {
        for (Group group : this.groups) {
            group.consistencyCheck(updateStartIndex);
        }
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        StringBuilder strBuilder = new StringBuilder();
        for (Group group : this.groups) {
            String groupName = group.getName();
            if (group.getStartIndex() < 0) continue;
            strBuilder.append(groupName);
            strBuilder.append('=');
            strBuilder.append(group.startIndex).append(':');
            strBuilder.append(group.visibleStartIndex).append(':');
            strBuilder.append(group.visibleStartPosition).append(':');
            strBuilder.append(group.originalSpan).append(':');
            strBuilder.append(group.visibleSpan).append(':');
            strBuilder.append(group.collapsed ? "collapsed" : "expanded");
            strBuilder.append(':');
            strBuilder.append(group.collapseable ? "collapseable" : "uncollapseable");
            strBuilder.append(':');
            strBuilder.append(group.unbreakable ? "unbreakable" : "breakable");
            if (!group.staticIndexes.isEmpty()) {
                strBuilder.append(':');
                for (Integer member : group.staticIndexes) {
                    strBuilder.append(member);
                    strBuilder.append(',');
                }
            }
            strBuilder.append('|');
        }
        properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_GROUP_MODEL, strBuilder.toString());
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_GROUP_MODEL);
        if (property != null) {
            this.clear();
            StringTokenizer groupTokenizer = new StringTokenizer(property, "|");
            while (groupTokenizer.hasMoreTokens()) {
                String groupToken = groupTokenizer.nextToken();
                int separatorIndex = groupToken.indexOf(61);
                String groupName = groupToken.substring(0, separatorIndex);
                String[] groupProperties = groupToken.substring(separatorIndex + 1).split(":");
                String state = groupProperties[0];
                int startIndex = Integer.valueOf(state);
                state = groupProperties[1];
                int visibleStartIndex = Integer.valueOf(state);
                state = groupProperties[2];
                int visibleStartPosition = Integer.valueOf(state);
                state = groupProperties[3];
                int originalSpan = Integer.valueOf(state);
                state = groupProperties[4];
                int visibleSpan = Integer.valueOf(state);
                Group group = new Group(groupName, startIndex, originalSpan);
                this.groups.add(group);
                group.visibleStartIndex = visibleStartIndex;
                group.visibleStartPosition = visibleStartPosition;
                group.visibleSpan = visibleSpan;
                state = groupProperties[5];
                if ("collapsed".equals(state)) {
                    group.collapsed = true;
                } else if ("expanded".equals(state)) {
                    group.collapsed = false;
                } else {
                    throw new IllegalArgumentException(String.valueOf(state) + " not one of 'expanded' or 'collapsed'");
                }
                state = groupProperties[6];
                if ("collapseable".equals(state)) {
                    group.collapseable = true;
                } else if ("uncollapseable".equals(state)) {
                    group.collapseable = false;
                } else {
                    throw new IllegalArgumentException(String.valueOf(state) + " not one of 'uncollapseable' or 'collapseable'");
                }
                state = groupProperties[7];
                if ("breakable".equals(state)) {
                    group.unbreakable = false;
                } else if ("unbreakable".equals(state)) {
                    group.unbreakable = true;
                } else {
                    throw new IllegalArgumentException(String.valueOf(state) + " not one of 'breakable' or 'unbreakable'");
                }
                if (groupProperties.length != 9) continue;
                String statics = groupProperties[8];
                StringTokenizer staticTokenizer = new StringTokenizer(statics, ",");
                while (staticTokenizer.hasMoreTokens()) {
                    Integer index = Integer.valueOf(staticTokenizer.nextToken());
                    group.staticIndexes.add(index);
                }
            }
        }
    }

    public void addPositionsToGroup(Group group, int ... positions) {
        if (group != null && !group.isUnbreakable()) {
            int pos;
            Arrays.sort(positions);
            ArrayList<Integer> beforeStartPosition = new ArrayList<Integer>();
            ArrayList<Integer> afterStartPosition = new ArrayList<Integer>();
            int[] nArray = positions;
            int n = positions.length;
            int n2 = 0;
            while (n2 < n) {
                pos = nArray[n2];
                if (pos < group.getVisibleStartPosition()) {
                    beforeStartPosition.add(pos);
                } else {
                    afterStartPosition.add(pos);
                }
                ++n2;
            }
            int i = beforeStartPosition.size() - 1;
            while (i >= 0) {
                int pos2 = (Integer)beforeStartPosition.get(i);
                if (pos2 != group.getVisibleStartPosition() - 1) break;
                group.setOriginalSpan(group.getOriginalSpan() + 1);
                group.setVisibleSpan(group.getVisibleSpan() + 1);
                int index = this.getIndexByPosition(pos2);
                group.members.add(index);
                group.setStartIndex(index);
                group.setVisibleStartIndex(index);
                group.updateVisibleStartPosition();
                --i;
            }
            Iterator iterator = afterStartPosition.iterator();
            while (iterator.hasNext()) {
                int nextPos;
                pos = (Integer)iterator.next();
                if (pos != (nextPos = group.getVisibleStartPosition() + group.getVisibleSpan())) break;
                group.setOriginalSpan(group.getOriginalSpan() + 1);
                group.setVisibleSpan(group.getVisibleSpan() + 1);
                group.members.add(this.getIndexByPosition(nextPos));
            }
        }
    }

    public void removePositionsFromGroup(Group group, int ... positions) {
        if (group != null && !group.isUnbreakable()) {
            Arrays.sort(positions);
            int i = positions.length - 1;
            while (i >= 0) {
                int pos = positions[i];
                if (group.getVisiblePositions().contains(pos)) {
                    int index = this.getIndexByPosition(pos);
                    if (index == group.getStartIndex()) {
                        group.setStartIndex(this.getIndexByPosition(pos + 1));
                        group.members.remove(index);
                        group.staticIndexes.remove(index);
                    } else {
                        Integer memberIndex = this.getIndexByPosition(group.getVisibleStartPosition() + group.getVisibleSpan() - 1);
                        group.members.remove(memberIndex);
                        group.staticIndexes.remove(memberIndex);
                    }
                    group.setOriginalSpan(group.getOriginalSpan() - 1);
                    group.setVisibleSpan(group.getVisibleSpan() - 1);
                    if (index == group.getVisibleStartIndex()) {
                        if (group.getOriginalSpan() > 0) {
                            group.setVisibleStartIndex(this.getIndexByPosition(pos + 1));
                        } else {
                            group.setStartIndex(-1);
                            group.setVisibleStartIndex(-1);
                            this.removeGroup(group);
                        }
                    }
                    group.updateVisibleStartPosition();
                }
                --i;
            }
        }
    }

    public Collection<Group> removePositionsFromGroup(int ... positions) {
        HashSet<Group> changed = new HashSet<Group>();
        Group group = null;
        Arrays.sort(positions);
        int i = positions.length - 1;
        while (i >= 0) {
            int pos = positions[i];
            group = this.getGroupByPosition(pos);
            if (group != null && !group.isUnbreakable()) {
                int index = this.getIndexByPosition(pos);
                if (index == group.getStartIndex()) {
                    group.setStartIndex(this.getIndexByPosition(pos + 1));
                    group.members.remove(index);
                    group.staticIndexes.remove(index);
                } else {
                    Integer memberIndex = this.getIndexByPosition(group.getVisibleStartPosition() + group.getVisibleSpan() - 1);
                    group.members.remove(memberIndex);
                    group.staticIndexes.remove(memberIndex);
                }
                group.setOriginalSpan(group.getOriginalSpan() - 1);
                group.setVisibleSpan(group.getVisibleSpan() - 1);
                if (index == group.getVisibleStartIndex()) {
                    if (group.getOriginalSpan() > 0) {
                        group.setVisibleStartIndex(this.getIndexByPosition(pos + 1));
                    } else {
                        group.setStartIndex(-1);
                        group.setVisibleStartIndex(-1);
                        this.removeGroup(group);
                    }
                }
                group.updateVisibleStartPosition();
                changed.add(group);
            }
            --i;
        }
        return changed;
    }

    public void addStaticIndexesToGroup(String groupName, int ... indexes) {
        Group group = this.getGroupByName(groupName);
        if (group != null) {
            this.addStaticIndexesToGroup(group, indexes);
        }
    }

    public void addStaticIndexesToGroup(int position, int ... indexes) {
        Group group = this.getGroupByPosition(position);
        if (group != null) {
            this.addStaticIndexesToGroup(group, indexes);
        }
    }

    public void addStaticIndexesToGroup(Group group, int ... indexes) {
        LinkedList<Integer> staticIndexes = new LinkedList<Integer>();
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            int pos = this.getPositionByIndex(index);
            if (pos >= group.getVisibleStartPosition() && pos < group.getVisibleStartPosition() + group.getVisibleSpan()) {
                staticIndexes.add(index);
            }
            ++n2;
        }
        if (!staticIndexes.isEmpty()) {
            group.staticIndexes.addAll(staticIndexes);
        }
    }

    public Group getGroupByName(String groupName) {
        for (Group group : this.groups) {
            if (!group.getName().equals(groupName)) continue;
            return group;
        }
        return null;
    }

    public Group getGroupByPosition(int position) {
        for (Group group : this.groups) {
            if (position != group.getVisibleStartPosition() && (position < group.getVisibleStartPosition() || position >= group.getVisibleStartPosition() + group.getVisibleSpan())) continue;
            return group;
        }
        return null;
    }

    public Group getGroupByStaticIndex(int staticIndex) {
        for (Group group : this.groups) {
            if (!group.staticIndexes.contains(staticIndex)) continue;
            return group;
        }
        return null;
    }

    public Group findGroupByMemberIndex(int memberIndex) {
        for (Group group : this.groups) {
            if (!group.hasMember(memberIndex)) continue;
            return group;
        }
        return null;
    }

    public boolean isPartOfAGroup(int position) {
        Group group = this.getGroupByPosition(position);
        return group != null;
    }

    public void addGroup(String groupName, int startIndex, int span) {
        Group group = new Group(groupName, startIndex, span);
        group.collapseable = this.defaultCollapseable;
        group.unbreakable = this.defaultUnbreakable;
        this.addGroup(group);
    }

    public void addGroup(Group group) {
        this.groups.add(group);
    }

    public Group removeGroup(String groupName) {
        Group group = this.getGroupByName(groupName);
        if (group != null) {
            this.removeGroup(group);
        }
        return group;
    }

    public Group removeGroup(int position) {
        Group group = this.getGroupByPosition(position);
        if (group != null) {
            this.removeGroup(group);
        }
        return group;
    }

    public void removeGroup(Group group) {
        this.groups.remove(group);
    }

    public void clear() {
        this.groups.clear();
    }

    public int size() {
        return this.groups.size();
    }

    public boolean isEmpty() {
        return this.groups.size() == 0;
    }

    public boolean isStatic(int position) {
        Group group = this.getGroupByPosition(position);
        if (group != null) {
            return group.staticIndexes.contains(this.getIndexByPosition(position));
        }
        return false;
    }

    public boolean isPartOfACollapseableGroup(int position) {
        Group group = this.getGroupByPosition(position);
        if (group != null) {
            return group.isCollapseable();
        }
        return false;
    }

    public void setGroupCollapseable(String groupName, boolean collabseable) {
        Group group = this.getGroupByName(groupName);
        if (group != null) {
            group.setCollapseable(collabseable);
        }
    }

    public void setGroupCollapseable(int position, boolean collabseable) {
        Group group = this.getGroupByPosition(position);
        if (group != null) {
            group.setCollapseable(collabseable);
        }
    }

    public boolean isPartOfAnUnbreakableGroup(int position) {
        Group group = this.getGroupByPosition(position);
        if (group != null) {
            return group.isUnbreakable();
        }
        return false;
    }

    public void setGroupUnbreakable(String groupName, boolean unbreakable) {
        Group group = this.getGroupByName(groupName);
        if (group != null) {
            group.setUnbreakable(unbreakable);
        }
    }

    public void setGroupUnbreakable(int position, boolean unbreakable) {
        Group group = this.getGroupByPosition(position);
        if (group != null) {
            group.setUnbreakable(unbreakable);
        }
    }

    public boolean isDefaultCollapseable() {
        return this.defaultCollapseable;
    }

    public void setDefaultCollapseable(boolean defaultCollapseable) {
        this.defaultCollapseable = defaultCollapseable;
    }

    public boolean isDefaultUnbreakable() {
        return this.defaultUnbreakable;
    }

    public void setDefaultUnbreakable(boolean defaultUnbreakable) {
        this.defaultUnbreakable = defaultUnbreakable;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Group Model:\n");
        for (Group group : this.groups) {
            builder.append(group);
        }
        return builder.toString();
    }

    public class Group {
        private String name;
        private int startIndex;
        private int visibleStartIndex;
        private int visibleStartPosition;
        private int originalSpan;
        private int visibleSpan;
        private final Collection<Integer> staticIndexes = new HashSet<Integer>();
        private boolean collapseable = true;
        private boolean collapsed = false;
        private boolean unbreakable = false;
        private final Collection<Integer> members = new HashSet<Integer>();

        Group(String groupName, int startIndex, int span) {
            this.name = groupName;
            this.startIndex = startIndex;
            this.visibleStartIndex = startIndex;
            this.visibleStartPosition = GroupModel.this.getPositionByIndex(startIndex);
            this.originalSpan = span;
            this.visibleSpan = span;
            int pos = this.visibleStartPosition;
            while (pos < this.visibleStartPosition + this.visibleSpan) {
                this.members.add(GroupModel.this.getIndexByPosition(pos));
                ++pos;
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isCollapsed() {
            return this.collapsed;
        }

        public void setCollapsed(boolean collapsed) {
            if (this.collapseable) {
                this.collapsed = collapsed;
            }
        }

        public void toggleCollapsed() {
            this.setCollapsed(!this.collapsed);
        }

        public boolean isCollapseable() {
            return this.collapseable;
        }

        public void setCollapseable(boolean collapseable) {
            this.collapseable = collapseable;
            if (!this.collapseable && this.isCollapsed()) {
                this.collapsed = false;
            }
        }

        public boolean isUnbreakable() {
            return this.unbreakable;
        }

        public void setUnbreakable(boolean unbreakable) {
            this.unbreakable = unbreakable;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public void setStartIndex(int startIndex) {
            this.startIndex = startIndex;
        }

        public int getVisibleStartIndex() {
            return this.visibleStartIndex;
        }

        public void setVisibleStartIndex(int visibleStartIndex) {
            this.visibleStartIndex = visibleStartIndex;
        }

        public int getVisibleStartPosition() {
            return this.visibleStartPosition;
        }

        void updateVisibleStartPosition() {
            int startPosition = GroupModel.this.getPositionByIndex(this.startIndex);
            if (startPosition >= 0) {
                this.visibleStartIndex = this.startIndex;
            }
            this.visibleStartPosition = GroupModel.this.getPositionByIndex(this.visibleStartIndex);
            if (this.visibleStartPosition == -1) {
                this.consistencyCheck(false);
            }
        }

        void consistencyCheck(boolean updateStartIndex) {
            int hidden = 0;
            int smallestPosition = -1;
            for (int member : this.members) {
                int pos = GroupModel.this.getPositionByIndex(member);
                if (pos == -1) {
                    ++hidden;
                    continue;
                }
                smallestPosition = smallestPosition == -1 ? pos : Math.min(smallestPosition, pos);
            }
            this.setVisibleSpan(this.originalSpan - hidden);
            int smallestIndex = GroupModel.this.getIndexByPosition(smallestPosition);
            if (updateStartIndex || this.startIndex < 0 && smallestIndex >= 0) {
                this.setStartIndex(smallestIndex);
            }
            this.setVisibleStartIndex(smallestIndex);
            this.visibleStartPosition = smallestPosition;
        }

        Collection<Integer> getMembers() {
            return Collections.unmodifiableCollection(this.members);
        }

        void addMembers(Collection<Integer> memberIndexes) {
            this.members.addAll(memberIndexes);
        }

        void removeMembers(Collection<Integer> memberIndexes) {
            this.members.removeAll(memberIndexes);
        }

        public boolean hasMember(int memberIndex) {
            return this.members.contains(memberIndex);
        }

        public int getOriginalSpan() {
            return this.originalSpan;
        }

        public void setOriginalSpan(int originalSpan) {
            this.originalSpan = originalSpan;
        }

        public int getVisibleSpan() {
            return this.visibleSpan;
        }

        public void setVisibleSpan(int visibleSpan) {
            if (visibleSpan <= this.originalSpan) {
                this.visibleSpan = visibleSpan;
            }
        }

        public boolean isEmpty() {
            return this.originalSpan == 0;
        }

        public void addStaticIndexes(int ... indexes) {
            int[] nArray = indexes;
            int n = indexes.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                this.staticIndexes.add(index);
                ++n2;
            }
        }

        public void removeStaticIndexes(int ... indexes) {
            int[] nArray = indexes;
            int n = indexes.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                this.staticIndexes.remove(index);
                ++n2;
            }
        }

        public Collection<Integer> getStaticIndexes() {
            return Collections.unmodifiableCollection(this.staticIndexes);
        }

        public Collection<Integer> getVisiblePositions() {
            ArrayList<Integer> groupPositions = new ArrayList<Integer>();
            int i = this.visibleStartPosition;
            while (i < this.visibleStartPosition + this.visibleSpan) {
                groupPositions.add(i);
                ++i;
            }
            return groupPositions;
        }

        public Collection<Integer> getVisibleIndexes() {
            ArrayList<Integer> groupIndexes = new ArrayList<Integer>();
            int i = this.visibleStartPosition;
            while (i < this.visibleStartPosition + this.visibleSpan) {
                groupIndexes.add(GroupModel.this.getIndexByPosition(i));
                ++i;
            }
            return groupIndexes;
        }

        public boolean isGroupStart(int position) {
            return position == this.visibleStartPosition;
        }

        public boolean isGroupEnd(int position) {
            return this.visibleStartPosition + this.visibleSpan - 1 == position;
        }

        public String toString() {
            return "Group:\n\t name: " + this.name + "\n\t startIndex: " + this.startIndex + "\n\t visibleStartIndex: " + this.visibleStartIndex + "\n\t visibleStartPosition: " + this.visibleStartPosition + "\n\t originalSpan: " + this.originalSpan + "\n\t visibleSpan: " + this.visibleSpan + "\n\t collapseable: " + this.collapseable + "\n\t collapsed: " + this.collapsed + "\n\t unbreakable: " + this.unbreakable + "\n\t staticIndexes: " + ObjectUtils.toString(this.staticIndexes) + "\n";
        }
    }

    public static interface IndexPositionConverter {
        public int convertPositionToIndex(IUniqueIndexLayer var1, int var2);

        public int convertIndexToPosition(IUniqueIndexLayer var1, int var2);
    }
}

