/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public abstract class ControlLabelProvider
extends ColumnLabelProvider {
    private final Map<TableItem, Editor> editors = new HashMap<TableItem, Editor>();

    public void dispose() {
        this.editors.clear();
        super.dispose();
    }

    public String getText(Object element) {
        return null;
    }

    public void update(ViewerCell cell) {
        super.update(cell);
        Object obj = cell.getElement();
        Widget w = cell.getViewerRow().getItem();
        if (w instanceof TableItem) {
            TableItem item = (TableItem)w;
            Table table = item.getParent();
            Editor editor = this.editors.get(item);
            if (editor == null) {
                Control control = this.setEditor(cell, (Composite)table, null, obj);
                if (control == null) {
                    return;
                }
                control.pack();
                editor = new Editor(table);
                editor.horizontalAlignment = 0x1000000;
                editor.verticalAlignment = 0x1000000;
                Point size = control.getSize();
                editor.minimumWidth = size.x;
                editor.minimumHeight = size.y;
                this.editors.put(item, editor);
                editor.setEditor(control, item, cell.getColumnIndex());
                editor.connect();
            } else {
                Control existing = editor.getEditor();
                Control control = this.setEditor(cell, (Composite)table, existing, obj);
                if (control != existing) {
                    if (!existing.isDisposed()) {
                        existing.dispose();
                    }
                    if (control == null) {
                        editor.dispose();
                        return;
                    }
                    control.pack();
                    editor.setEditor(control);
                }
            }
        }
    }

    public abstract Control setEditor(ViewerCell var1, Composite var2, Control var3, Object var4);

    private class Editor
    extends TableEditor {
        private DisposeListener disposer;
        private final Table table;

        public Editor(Table table) {
            super(table);
            this.table = table;
        }

        public void layout() {
            TableItem item;
            if (Util.isGtk() && SWT.getVersion() <= 4924 && (item = this.getItem()) != null) {
                Control editor;
                Rectangle rect = item.getBounds();
                if (this.table.getHeaderVisible() && (editor = this.getEditor()) != null && !editor.isDisposed()) {
                    editor.setVisible(rect.y >= this.table.getHeaderHeight());
                }
            }
            super.layout();
        }

        public void connect() {
            TableItem item = this.getItem();
            if (item != null) {
                this.disposer = e -> {
                    Control editor = this.getEditor();
                    if (editor != null && !editor.isDisposed()) {
                        editor.dispose();
                    }
                    this.dispose();
                };
                item.addDisposeListener(this.disposer);
            }
        }

        private void disconnect() {
            if (this.disposer != null) {
                TableItem item = this.getItem();
                if (item != null) {
                    ControlLabelProvider.this.editors.remove(item);
                    item.removeDisposeListener(this.disposer);
                }
                this.disposer = null;
            }
        }

        public void dispose() {
            this.disconnect();
            super.dispose();
        }
    }
}

