/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.adapters;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.adapters.GrepLineStyleListener;
import name.schedenig.eclipse.grepconsole.adapters.TextFilter;
import name.schedenig.eclipse.grepconsole.adapters.links.LinkListener;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.AbstractGrepModelElement;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionFolder;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionItem;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionRootFolder;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import name.schedenig.eclipse.grepconsole.view.colors.ColorRegistry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.part.IPageBookViewPage;

public class GrepPageParticipant
implements IConsolePageParticipant,
Activator.IGrepConsoleListener {
    private org.eclipse.ui.console.IConsole console;
    private ILaunchConfiguration launchConfig;
    private StyledText styledText;
    private GrepLineStyleListener grepLineStyleListener;
    private ColorRegistry colorRegistry;
    private Map<String, Boolean> enablementMap;
    private Map<String, Boolean> filterMap;
    private Map<String, Boolean> statisticsMap;
    private Map<String, Boolean> notificationsMap;
    private Set<IGrepPageParticipantListener> listeners = new LinkedHashSet<IGrepPageParticipantListener>();
    private LinkListener linkAdapter;
    private TextFilter textFilter;
    private boolean used;

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void init(IPageBookViewPage page, org.eclipse.ui.console.IConsole console) {
        Object o;
        Activator activator = Activator.getDefault();
        GrepPageParticipant oldParticipant = activator.getParticipant(console);
        if (oldParticipant != null) {
            return;
        }
        this.used = true;
        page.getControl().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Activator activator = Activator.getDefault();
                if (activator.getActiveParticipant() != GrepPageParticipant.this) {
                    activator.setActiveParticipant(GrepPageParticipant.this);
                }
            }
        });
        this.console = console;
        this.colorRegistry = new ColorRegistry(Activator.getDefault().getColorRegistry());
        this.enablementMap = new HashMap<String, Boolean>();
        this.filterMap = new HashMap<String, Boolean>();
        this.statisticsMap = new HashMap<String, Boolean>();
        this.notificationsMap = new HashMap<String, Boolean>();
        if (console instanceof IAdaptable && (o = ((IAdaptable)console).getAdapter(ILaunchConfiguration.class)) instanceof ILaunchConfiguration) {
            this.launchConfig = (ILaunchConfiguration)o;
        }
        if (this.launchConfig == null && console instanceof IConsole) {
            ILaunch launch = ((IConsole)console).getProcess().getLaunch();
            this.launchConfig = launch.getLaunchConfiguration();
        }
        if (this.launchConfig != null) {
            try {
                this.enablementMap.putAll(GrepConsoleUtil.loadIdBooleanMap("name.schedenig.eclipse.grepconsole.EnabledIds", "name.schedenig.eclipse.grepconsole.DisabledIds", this.launchConfig));
                this.filterMap.putAll(GrepConsoleUtil.loadIdBooleanMap("name.schedenig.eclipse.grepconsole.FilterEnabledIds", "name.schedenig.eclipse.grepconsole.FilterDisabledIds", this.launchConfig));
                this.statisticsMap.putAll(GrepConsoleUtil.loadIdBooleanMap("name.schedenig.eclipse.grepconsole.StatisticsEnabledIds", "name.schedenig.eclipse.grepconsole.StatisticsDisabledIds", this.launchConfig));
                this.notificationsMap.putAll(GrepConsoleUtil.loadIdBooleanMap("name.schedenig.eclipse.grepconsole.NotificationsEnabledIds", "name.schedenig.eclipse.grepconsole.NotificationsDisabledIds", this.launchConfig));
            }
            catch (CoreException ex) {
                Activator.getDefault().log(4, Messages.Error_could_not_read_launch_configuration, ex);
            }
        }
        if (page.getControl() instanceof StyledText) {
            this.styledText = (StyledText)page.getControl();
            this.grepLineStyleListener = new GrepLineStyleListener(this.styledText.getShell(), this.getProject());
            this.grepLineStyleListener.setColorRegistry(this.colorRegistry);
            this.refreshLineStyleListener();
            this.styledText.addLineStyleListener((LineStyleListener)this.grepLineStyleListener);
            this.linkAdapter = new LinkListener(this.styledText, this.grepLineStyleListener);
            this.linkAdapter.attach();
        }
        this.textFilter = this.createTextFilter();
        activator.setParticipant(console, this);
        activator.addListener(this);
    }

    public Map<String, Boolean> getEnablementMap() {
        return this.enablementMap;
    }

    public void setEnablementMap(Map<String, Boolean> enablementMap) {
        this.enablementMap = enablementMap;
    }

    public Map<String, Boolean> getFilterMap() {
        return this.filterMap;
    }

    public void setFilterMap(Map<String, Boolean> filterMap) {
        this.filterMap = filterMap;
    }

    public Map<String, Boolean> getStatisticsMap() {
        return this.statisticsMap;
    }

    public void setStatisticsMap(Map<String, Boolean> statisticsMap) {
        this.statisticsMap = statisticsMap;
    }

    public Map<String, Boolean> getNotificationsMap() {
        return this.notificationsMap;
    }

    public void setNotificationsMap(Map<String, Boolean> notificationsMap) {
        this.notificationsMap = notificationsMap;
    }

    public void refreshLineStyleListener() {
        if (this.grepLineStyleListener == null) {
            return;
        }
        Activator activator = Activator.getDefault();
        LinkedList<GrepExpressionItem> items = new LinkedList<GrepExpressionItem>();
        this.addAllEnabledItems(items, activator.getExpressions(), this.enablementMap);
        this.grepLineStyleListener.setItems(items);
        if (!this.styledText.isDisposed()) {
            this.styledText.redraw();
        }
    }

    private void addAllEnabledItems(LinkedList<GrepExpressionItem> items, AbstractGrepModelElement element, Map<String, Boolean> enablementMap) {
        Boolean enablement = enablementMap.get(element.getId());
        if (enablement == null) {
            enablement = element.isDefaultEnabled();
        }
        if (!(element instanceof GrepExpressionRootFolder) && !enablement.booleanValue()) {
            return;
        }
        if (element instanceof GrepExpressionItem) {
            items.add((GrepExpressionItem)element);
        } else if (element instanceof GrepExpressionFolder) {
            for (AbstractGrepModelElement child : ((GrepExpressionFolder)element).getChildren()) {
                this.addAllEnabledItems(items, child, enablementMap);
            }
        }
    }

    public void addAllFilterItems(LinkedList<GrepExpressionItem> items, AbstractGrepModelElement element, Map<String, Boolean> filterMap) {
        Boolean filter = filterMap.get(element.getId());
        if (filter == null) {
            filter = element.isDefaultFilter();
        }
        if (!(element instanceof GrepExpressionRootFolder) && !filter.booleanValue()) {
            return;
        }
        if (element instanceof GrepExpressionItem) {
            items.add((GrepExpressionItem)element);
        } else if (element instanceof GrepExpressionFolder) {
            for (AbstractGrepModelElement child : ((GrepExpressionFolder)element).getChildren()) {
                this.addAllFilterItems(items, child, filterMap);
            }
        }
    }

    public void addAllStatisticsItems(LinkedHashSet<GrepExpressionItem> items, AbstractGrepModelElement element, Map<String, Boolean> statisticsMap) {
        Boolean statistics = statisticsMap.get(element.getId());
        if (statistics == null) {
            statistics = element.isDefaultStatistics();
        }
        if (!(element instanceof GrepExpressionRootFolder) && !statistics.booleanValue()) {
            return;
        }
        if (element instanceof GrepExpressionItem) {
            items.add((GrepExpressionItem)element);
        } else if (element instanceof GrepExpressionFolder) {
            for (AbstractGrepModelElement child : ((GrepExpressionFolder)element).getChildren()) {
                this.addAllStatisticsItems(items, child, statisticsMap);
            }
        }
    }

    public void addAllNotificationsItems(Collection<GrepExpressionItem> items, AbstractGrepModelElement element, Map<String, Boolean> notificationsMap) {
        Boolean notifications = notificationsMap.get(element.getId());
        if (notifications == null) {
            notifications = element.isDefaultNotifications();
        }
        if (!(element instanceof GrepExpressionRootFolder) && !notifications.booleanValue()) {
            return;
        }
        if (element instanceof GrepExpressionItem) {
            items.add((GrepExpressionItem)element);
        } else if (element instanceof GrepExpressionFolder) {
            for (AbstractGrepModelElement child : ((GrepExpressionFolder)element).getChildren()) {
                this.addAllNotificationsItems(items, child, notificationsMap);
            }
        }
    }

    public void addAllErrorLogItems(Collection<GrepExpressionItem> items, AbstractGrepModelElement element, Map<String, Boolean> errorLogMap) {
        Boolean enabled = errorLogMap.get(element.getId());
        if (enabled == null) {
            enabled = element.isDefaultNotifications();
        }
        if (!(element instanceof GrepExpressionRootFolder) && !enabled.booleanValue()) {
            return;
        }
        if (element instanceof GrepExpressionItem) {
            items.add((GrepExpressionItem)element);
        } else if (element instanceof GrepExpressionFolder) {
            for (AbstractGrepModelElement child : ((GrepExpressionFolder)element).getChildren()) {
                this.addAllErrorLogItems(items, child, errorLogMap);
            }
        }
    }

    public void dispose() {
        Activator activator = Activator.getDefault();
        activator.removeListener(this);
        if (this.textFilter != null) {
            this.textFilter.dispose();
        }
        if (this.linkAdapter != null) {
            this.linkAdapter.dispose();
            this.linkAdapter = null;
        }
        if (this.colorRegistry != null) {
            this.colorRegistry.disposeColors();
        }
        if (this.used) {
            activator.setParticipant(this.console, null);
        }
    }

    public void activated() {
        Activator.getDefault().setActiveParticipant(this);
    }

    public void deactivated() {
    }

    public void saveLaunchConfig() {
        if (this.launchConfig == null) {
            return;
        }
        try {
            ILaunchConfigurationWorkingCopy wc = this.launchConfig.getWorkingCopy();
            GrepConsoleUtil.storeIdBooleanMap("name.schedenig.eclipse.grepconsole.EnabledIds", "name.schedenig.eclipse.grepconsole.DisabledIds", this.enablementMap, wc);
            GrepConsoleUtil.storeIdBooleanMap("name.schedenig.eclipse.grepconsole.FilterEnabledIds", "name.schedenig.eclipse.grepconsole.FilterDisabledIds", this.filterMap, wc);
            GrepConsoleUtil.storeIdBooleanMap("name.schedenig.eclipse.grepconsole.StatisticsEnabledIds", "name.schedenig.eclipse.grepconsole.StatisticsDisabledIds", this.statisticsMap, wc);
            GrepConsoleUtil.storeIdBooleanMap("name.schedenig.eclipse.grepconsole.NotificationsEnabledIds", "name.schedenig.eclipse.grepconsole.NotificationsDisabledIds", this.notificationsMap, wc);
            wc.doSave();
        }
        catch (CoreException ex) {
            Activator.getDefault().log(4, Messages.Error_could_not_save_launch_configuration, ex);
            return;
        }
    }

    public StyledText getStyledText() {
        return this.styledText;
    }

    public ILaunchConfiguration getLaunchConfig() {
        return this.launchConfig;
    }

    public synchronized TextFilter getTextFilter() {
        return this.textFilter;
    }

    private TextFilter createTextFilter() {
        Activator activator = Activator.getDefault();
        LinkedList<GrepExpressionItem> filterExpressions = new LinkedList<GrepExpressionItem>();
        this.addAllFilterItems(filterExpressions, activator.getExpressions(), this.filterMap);
        LinkedHashSet<GrepExpressionItem> statisticsExpressions = new LinkedHashSet<GrepExpressionItem>();
        this.addAllStatisticsItems(statisticsExpressions, activator.getExpressions(), this.statisticsMap);
        LinkedHashSet<GrepExpressionItem> notificationExpressions = new LinkedHashSet<GrepExpressionItem>();
        this.addAllNotificationsItems(notificationExpressions, activator.getExpressions(), this.notificationsMap);
        LinkedHashSet<GrepExpressionItem> errorLogExpressions = new LinkedHashSet<GrepExpressionItem>();
        this.addAllErrorLogItems(errorLogExpressions, activator.getExpressions(), this.notificationsMap);
        TextFilter textFilter = new TextFilter(this.styledText.getContent(), filterExpressions, statisticsExpressions, notificationExpressions, errorLogExpressions, this.styledText.getShell(), this.getProject());
        textFilter.setLineDelimiter(this.styledText.getLineDelimiter());
        textFilter.refresh();
        return textFilter;
    }

    public GrepLineStyleListener getLineStyleListener() {
        return this.grepLineStyleListener;
    }

    public org.eclipse.ui.console.IConsole getConsole() {
        return this.console;
    }

    @Override
    public void participantAdded(GrepPageParticipant participant) {
    }

    @Override
    public void participantRemoved(GrepPageParticipant participant) {
    }

    @Override
    public void participantActivated(GrepPageParticipant participant) {
    }

    @Override
    public void settingsChanged() {
        this.refreshLineStyleListener();
        Activator activator = Activator.getDefault();
        LinkedList<GrepExpressionItem> filterExpressions = new LinkedList<GrepExpressionItem>();
        this.addAllFilterItems(filterExpressions, activator.getExpressions(), this.filterMap);
        this.textFilter.setFilterExpressions(filterExpressions);
        LinkedHashSet<GrepExpressionItem> statisticsExpressions = new LinkedHashSet<GrepExpressionItem>();
        this.addAllStatisticsItems(statisticsExpressions, activator.getExpressions(), this.statisticsMap);
        this.textFilter.setStatisticsExpressions(statisticsExpressions);
        LinkedHashSet<GrepExpressionItem> notificationExpressions = new LinkedHashSet<GrepExpressionItem>();
        this.addAllNotificationsItems(notificationExpressions, activator.getExpressions(), this.notificationsMap);
        this.textFilter.setNotificationExpressions(notificationExpressions);
        LinkedHashSet<GrepExpressionItem> errorLogExpressions = new LinkedHashSet<GrepExpressionItem>();
        this.addAllErrorLogItems(errorLogExpressions, activator.getExpressions(), this.notificationsMap);
        this.textFilter.setErrorLogExpressions(errorLogExpressions);
        this.textFilter.refresh();
        for (IGrepPageParticipantListener listener : this.listeners) {
            listener.participantChanged(this);
        }
    }

    public void setFocus() {
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView(this.console);
    }

    public void addListener(IGrepPageParticipantListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IGrepPageParticipantListener listener) {
        this.listeners.remove(listener);
    }

    public IProject getProject() {
        block6: {
            if (this.launchConfig != null && this.launchConfig.getMappedResources() != null) break block6;
            return null;
        }
        try {
            IResource[] iResourceArray = this.launchConfig.getMappedResources();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IProject) {
                    return (IProject)resource;
                }
                if (resource.getProject() != null) {
                    return resource.getProject();
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    public static interface IGrepPageParticipantListener {
        public void participantChanged(GrepPageParticipant var1);
    }
}

