/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.adapters;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.MatchResult;
import name.schedenig.eclipse.grepconsole.adapters.links.LinkMatch;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionItem;
import name.schedenig.eclipse.grepconsole.model.GrepGroup;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;

public class GroupParameterResolver
implements GrepConsoleUtil.IVariableResolver {
    private LinkMatch match;
    private Map<String, Integer> map;

    public GroupParameterResolver(LinkMatch match) {
        this.match = match;
    }

    @Override
    public String getValue(String name) {
        if (name == null) {
            return null;
        }
        if (this.map == null) {
            this.buildMap();
        }
        Integer index = this.map.get(name.toLowerCase());
        MatchResult matchResult = this.match.getMatchResult();
        if (index == null || index > matchResult.groupCount()) {
            return null;
        }
        return matchResult.group(index);
    }

    private void buildMap() {
        this.map = new HashMap<String, Integer>();
        GrepExpressionItem item = this.match.getItem();
        int i = 0;
        while (i < item.getGroups().length) {
            GrepGroup group = item.getGroups()[i];
            String name = group.getName();
            if (name != null) {
                this.map.put(name.toLowerCase(), i);
            }
            ++i;
        }
    }
}

