/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.adapters.links;

import java.text.MessageFormat;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.adapters.links.GrepLinkAdapter;
import name.schedenig.eclipse.grepconsole.adapters.links.LinkMatch;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.links.JavaLink;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaLinkAdapter
extends GrepLinkAdapter {
    private String typeName;
    private Integer lineNumber;
    private IProject project;
    private Integer offset;
    private String toolTipText;

    public JavaLinkAdapter(LinkMatch match, Shell shell, IProject project) {
        super(match, shell);
        this.project = project;
    }

    private void init() {
        if (this.typeName != null || this.toolTipText != null) {
            return;
        }
        JavaLink link = this.getLink();
        this.typeName = this.replaceParams(link.getTypePattern());
        this.lineNumber = this.readOptionalIntPattern(link.getLineNumberPattern());
        this.offset = this.readOptionalIntPattern(link.getOffsetPattern());
        this.toolTipText = String.valueOf(this.typeName) + (this.lineNumber == null ? "" : " (" + this.lineNumber + ")");
    }

    @Override
    public JavaLink getLink() {
        return (JavaLink)super.getLink();
    }

    @Override
    public void openLink() {
        IType type;
        IJavaProject javaProject;
        this.init();
        if (this.project == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.LinkAdapter_link_error, (String)Messages.JavaLinkAdapter_no_project_selected);
            return;
        }
        try {
            javaProject = (IJavaProject)this.project.getNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException ex) {
            Activator.getDefault().log(4, MessageFormat.format(Messages.JavaLinkAdapter_not_a_java_project_name, this.project.getName()), ex);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.LinkAdapter_link_error, (String)MessageFormat.format(Messages.JavaLinkAdapter_not_a_java_project_name_message, this.project.getName(), ex.getMessage()));
            return;
        }
        if (javaProject == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.LinkAdapter_link_error, (String)MessageFormat.format(Messages.JavaLinkAdapter_not_a_java_project_name, this.project.getName()));
            return;
        }
        try {
            type = javaProject.findType(this.typeName);
        }
        catch (JavaModelException ex) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.LinkAdapter_link_error, (String)MessageFormat.format(Messages.JavaLinkAdapter_could_not_find_type_in_project_name_message, this.typeName, ex.getLocalizedMessage()));
            return;
        }
        if (type == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.LinkAdapter_link_error, (String)MessageFormat.format(Messages.JavaLinkAdapter_could_not_find_type_in_project_name, this.typeName));
            return;
        }
        try {
            IEditorPart editor = JavaUI.openInEditor((IJavaElement)type);
            if (editor instanceof ITextEditor && this.lineNumber != null) {
                GrepConsoleUtil.jumpToEditorLine((ITextEditor)editor, this.lineNumber, this.offset);
            }
            this.getShell().forceActive();
        }
        catch (PartInitException ex) {
            Activator.getDefault().log(4, Messages.JavaLinkAdapter_could_not_open_editor, ex);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.LinkAdapter_link_error, (String)MessageFormat.format(Messages.JavaLinkAdapter_could_not_open_editor_message, ex.getLocalizedMessage()));
        }
        catch (JavaModelException ex) {
            Activator.getDefault().log(4, Messages.JavaLinkAdapter_could_not_open_editor, ex);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.LinkAdapter_link_error, (String)MessageFormat.format(Messages.JavaLinkAdapter_could_not_open_editor_message, ex.getLocalizedMessage()));
        }
    }

    @Override
    public String getToolTipText() {
        this.init();
        return this.toolTipText;
    }
}

