/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import name.schedenig.eclipse.grepconsole.model.AbstractGrepModelElement;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionFolder;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionItem;
import name.schedenig.eclipse.grepconsole.model.GrepGroup;
import name.schedenig.eclipse.grepconsole.model.GrepStyle;

public class GrepExpressionRootFolder
extends GrepExpressionFolder {
    private HashMap<String, GrepStyle> styles;

    public GrepExpressionRootFolder() {
        this.styles = new HashMap();
    }

    public GrepExpressionRootFolder(GrepExpressionFolder src, boolean identityCopy) {
        super(src, identityCopy);
    }

    @Override
    public GrepExpressionRootFolder copy(boolean identityCopy) {
        return new GrepExpressionRootFolder(this, identityCopy);
    }

    @Override
    public void copyFrom(AbstractGrepModelElement src, boolean identityCopy) {
        this.styles = new HashMap();
        for (GrepStyle style : ((GrepExpressionRootFolder)src).getStyles()) {
            GrepStyle newStyle = style.copy(true);
            this.styles.put(newStyle.getId(), newStyle);
        }
        super.copyFrom(src, identityCopy);
        LinkedList<AbstractGrepModelElement> queue = new LinkedList<AbstractGrepModelElement>();
        queue.add(this);
        while (!queue.isEmpty()) {
            AbstractGrepModelElement element = (AbstractGrepModelElement)queue.removeFirst();
            if (element instanceof GrepExpressionFolder) {
                queue.addAll(((GrepExpressionFolder)element).getChildren());
                continue;
            }
            if (!(element instanceof GrepExpressionItem)) continue;
            GrepExpressionItem item = (GrepExpressionItem)element;
            GrepGroup[] itemGroups = item.getGroups();
            int i = 0;
            while (i < itemGroups.length) {
                GrepStyle srcStyle = itemGroups[i].getStyle();
                itemGroups[i].setStyle(srcStyle == null ? null : this.getStyle(srcStyle.getId()));
                ++i;
            }
        }
        if (!identityCopy) {
            Collection<GrepStyle> newStyles = this.styles.values();
            for (GrepStyle style : newStyles) {
                style.regenerateId();
            }
            this.setStyles(newStyles);
        }
    }

    public Collection<GrepStyle> getStyles() {
        return this.styles.values();
    }

    public void setStyles(Collection<GrepStyle> styles) {
        this.styles.clear();
        for (GrepStyle style : styles) {
            if (style == null) continue;
            this.styles.put(style.getId(), style);
        }
        this.refreshStyles();
    }

    public GrepStyle getStyle(String id) {
        return this.styles.get(id);
    }

    @Override
    public boolean isDefaultEnabled() {
        return true;
    }

    @Override
    public boolean isDefaultFilter() {
        return true;
    }

    @Override
    public boolean isDefaultStatistics() {
        return true;
    }

    @Override
    public boolean isDefaultNotifications() {
        return true;
    }

    public void addStyle(GrepStyle style) {
        this.styles.put(style.getId(), style);
    }

    public void removeStyle(GrepStyle style) {
        this.styles.remove(style.getId());
    }

    public void addMissingStyles() {
        LinkedList<AbstractGrepModelElement> queue = new LinkedList<AbstractGrepModelElement>();
        queue.add(this);
        while (!queue.isEmpty()) {
            AbstractGrepModelElement element = (AbstractGrepModelElement)queue.removeFirst();
            if (element instanceof GrepExpressionFolder) {
                queue.addAll(((GrepExpressionFolder)element).getChildren());
                continue;
            }
            if (!(element instanceof GrepExpressionItem)) continue;
            GrepExpressionItem item = (GrepExpressionItem)element;
            GrepGroup[] itemGroups = item.getGroups();
            int i = 0;
            while (i < itemGroups.length) {
                GrepStyle style = itemGroups[i].getStyle();
                if (style != null && !this.styles.containsKey(style.getId())) {
                    this.styles.put(style.getId(), style);
                }
                ++i;
            }
        }
    }
}

