/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.model.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import name.schedenig.eclipse.grepconsole.model.AbstractGrepModelElement;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionFolder;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionItem;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionRootFolder;
import name.schedenig.eclipse.grepconsole.model.GrepGroup;
import name.schedenig.eclipse.grepconsole.model.GrepStyle;
import name.schedenig.eclipse.grepconsole.model.links.CommandLink;
import name.schedenig.eclipse.grepconsole.model.links.FileLink;
import name.schedenig.eclipse.grepconsole.model.links.IGrepLink;
import name.schedenig.eclipse.grepconsole.model.links.JavaLink;
import name.schedenig.eclipse.grepconsole.model.links.ScriptLink;
import name.schedenig.eclipse.grepconsole.model.links.UrlLink;
import name.schedenig.eclipse.grepconsole.model.xml.XmlHandlerException;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlHandler {
    private static final String NAMESPACE_URI = "http://eclipse.musgit.com/grepconsole";
    private static final String XML_FOLDERS = "folders";
    private static final String XML_STYLE = "style";
    private static final String XML_FOLDER = "folder";
    private static final String XML_ITEM = "item";
    private static final String XML_ID = "id";
    private static final String XML_NAME = "name";
    private static final String XML_FOREGROUND = "foreground";
    private static final String XML_BACKGROUND = "background";
    private static final String XML_BOLD = "bold";
    private static final String XML_ITALIC = "italic";
    private static final String XML_UNDERLINE = "underline";
    private static final String XML_UNDERLINE_COLOR = "underlineColor";
    private static final String XML_STRIKEOUT = "strikeout";
    private static final String XML_STRIKEOUT_COLOR = "strikeoutColor";
    private static final String XML_BORDER = "border";
    private static final String XML_BORDER_COLOR = "borderColor";
    private static final String XML_EXPRESSION = "expression";
    private static final String XML_QUICK_EXPRESSION = "quickExpression";
    private static final String XML_UNLESS_EXPRESSION = "unlessExpression";
    private static final String XML_REWRITE_EXPRESSION = "rewriteExpression";
    private static final String XML_REWRITE_GROUP = "rewriteGroup";
    private static final String XML_ENABLED = "enabled";
    private static final String XML_FILTER = "filter";
    private static final String XML_STATISTICS = "statistics";
    private static final String XML_NOTIFICATIONS = "notifications";
    private static final String XML_CASE_INSENSITIVE = "caseInsensitive";
    private static final String XML_REMOVE_ORIGINAL_STYLE = "removeOriginalStyle";
    private static final String XML_GROUP = "group";
    private static final String XML_URL_LINK = "urlLink";
    private static final String XML_URL_PATTERN = "urlPattern";
    private static final String XML_EXTERNAL = "external";
    private static final String XML_SCRIPT_LINK = "scriptLink";
    private static final String XML_LANGUAGE = "language";
    private static final String XML_COMMAND_LINK = "commandLink";
    private static final String XML_COMMAND = "command";
    private static final String XML_WORKING_DIR = "workingDir";
    private static final String XML_FILE_LINK = "fileLink";
    private static final String XML_FILE = "file";
    private static final String XML_BASE_DIR = "baseDir";
    private static final String XML_LINE_NUMBER = "lineNumber";
    private static final String XML_OFFSET = "offset";
    private static final String XML_JAVA_LINK = "javaLink";
    private static final String XML_TYPE = "type";
    private static final String XML_AUTOSTART_LINK = "type";
    private static final String XML_POPUP_NOTIFICATION = "popupNotification";
    private static final String XML_NOTIFICATION_TITLE = "notificationTitle";
    private static final String XML_NOTIFICATION_MESSAGE = "notificationMessage";
    private static final String XML_NOTIFICATION_LINK = "notificationLink";
    private static final String XML_SOUND_NOTIFICATION = "soundNotification";
    private static final String XML_STATISTICS_COUNT_LABEL = "statisticsCountLabel";
    private static final String XML_STATISTICS_VALUE_LABEL = "statisticsValueLabel";
    private static final String XML_STATISTICS_VALUE_PATTERN = "statisticsValuePattern";
    private static final String XML_ERROR_LOG_LEVEL = "errorLogLevel";
    private static final String XML_ERROR_LOG_MESSAGE = "errorLogMessage";
    private static final ErrorHandler SILENT_ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void warning(SAXParseException arg0) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException arg0) throws SAXException {
        }

        @Override
        public void error(SAXParseException arg0) throws SAXException {
        }
    };

    public String createXmlString(GrepExpressionRootFolder expressions) throws ParserConfigurationException, TransformerException {
        Document doc = this.createDocument(expressions);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        StreamResult result = new StreamResult(new StringWriter());
        transformer.transform(new DOMSource(doc), result);
        return result.getWriter().toString();
    }

    public Document createDocument(GrepExpressionRootFolder expressions) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder bd = factory.newDocumentBuilder();
        Document doc = bd.newDocument();
        doc.appendChild(this.createRootElement(doc, expressions));
        return doc;
    }

    public Element createRootElement(Document doc, GrepExpressionRootFolder expressions) {
        Element element = doc.createElementNS(NAMESPACE_URI, XML_FOLDERS);
        for (GrepStyle style : expressions.getStyles()) {
            element.appendChild(this.createStyleElement(doc, style));
        }
        element.appendChild(this.createFolderElement(doc, expressions, expressions));
        return element;
    }

    private Element createStyleElement(Document doc, GrepStyle style) {
        Element element = doc.createElementNS(NAMESPACE_URI, XML_STYLE);
        if (style != null) {
            this.setAttribute(element, XML_ID, style.getId());
            this.setAttribute(element, XML_NAME, style.getName());
            this.setAttribute(element, XML_FOREGROUND, style.getForeground());
            this.setAttribute(element, XML_BACKGROUND, style.getBackground());
            this.setAttribute(element, XML_BOLD, style.isBold());
            this.setAttribute(element, XML_ITALIC, style.isItalic());
            this.setAttribute(element, XML_UNDERLINE, style.isUnderline());
            this.setAttribute(element, XML_UNDERLINE_COLOR, style.getUnderlineColor());
            this.setAttribute(element, XML_STRIKEOUT, style.isStrikeout());
            this.setAttribute(element, XML_STRIKEOUT_COLOR, style.getStrikeoutColor());
            this.setAttribute(element, XML_BORDER, style.isBorder());
            this.setAttribute(element, XML_BORDER_COLOR, style.getBorderColor());
        }
        return element;
    }

    private void setAttribute(Element element, String attribute, Object value) {
        if (value != null) {
            element.setAttribute(attribute, value.toString());
        }
    }

    private void setAttribute(Element element, String attribute, RGB value) {
        if (value != null) {
            element.setAttribute(attribute, GrepConsoleUtil.rgbToString(value));
        }
    }

    private Element createFolderElement(Document doc, GrepExpressionFolder folder, GrepExpressionRootFolder root) {
        Element element = doc.createElementNS(NAMESPACE_URI, XML_FOLDER);
        this.setAttribute(element, XML_ID, folder.getId());
        this.setAttribute(element, XML_NAME, folder.getName());
        if (folder.isDefaultEnabled()) {
            this.setAttribute(element, XML_ENABLED, folder.isDefaultEnabled());
        }
        if (folder.isDefaultFilter()) {
            this.setAttribute(element, XML_FILTER, folder.isDefaultFilter());
        }
        if (folder.isDefaultStatistics()) {
            this.setAttribute(element, XML_STATISTICS, folder.isDefaultStatistics());
        }
        if (folder.isDefaultNotifications()) {
            this.setAttribute(element, XML_NOTIFICATIONS, folder.isDefaultNotifications());
        }
        for (AbstractGrepModelElement modelElement : folder.getChildren()) {
            if (modelElement instanceof GrepExpressionFolder) {
                element.appendChild(this.createFolderElement(doc, (GrepExpressionFolder)modelElement, root));
                continue;
            }
            element.appendChild(this.createItemElement(doc, (GrepExpressionItem)modelElement, root));
        }
        return element;
    }

    private Element createItemElement(Document doc, GrepExpressionItem item, GrepExpressionRootFolder root) {
        Element linkElement;
        Element groupElement;
        IGrepLink link;
        GrepStyle style;
        GrepGroup group;
        Element element = doc.createElementNS(NAMESPACE_URI, XML_ITEM);
        this.setAttribute(element, XML_ID, item.getId());
        this.setAttribute(element, XML_NAME, item.getName());
        this.setAttribute(element, XML_EXPRESSION, item.getGrepExpression());
        this.setAttribute(element, XML_QUICK_EXPRESSION, item.getQuickGrepExpression());
        this.setAttribute(element, XML_UNLESS_EXPRESSION, item.getUnlessGrepExpression());
        this.setAttribute(element, XML_REWRITE_EXPRESSION, item.getRewriteExpression());
        if (item.isDefaultEnabled()) {
            this.setAttribute(element, XML_ENABLED, item.isDefaultEnabled());
        }
        if (item.isDefaultFilter()) {
            this.setAttribute(element, XML_FILTER, item.isDefaultFilter());
        }
        if (item.isDefaultStatistics()) {
            this.setAttribute(element, XML_STATISTICS, item.isDefaultFilter());
        }
        if (item.isDefaultNotifications()) {
            this.setAttribute(element, XML_NOTIFICATIONS, item.isDefaultNotifications());
        }
        if (item.isCaseInsensitive()) {
            this.setAttribute(element, XML_CASE_INSENSITIVE, item.isCaseInsensitive());
        }
        if (item.isRemoveOriginalStyle()) {
            this.setAttribute(element, XML_REMOVE_ORIGINAL_STYLE, item.isRemoveOriginalStyle());
        }
        if (item.getAutostartLink() != null) {
            Element autostartLinkElement = doc.createElementNS(NAMESPACE_URI, "type");
            autostartLinkElement.appendChild(this.createLinkElement(doc, item.getAutostartLink()));
            element.appendChild(autostartLinkElement);
        }
        if (item.isPopupNotification()) {
            this.setAttribute(element, XML_POPUP_NOTIFICATION, item.isPopupNotification());
        }
        if (item.getNotificationTitle() != null) {
            this.setAttribute(element, XML_NOTIFICATION_TITLE, item.getNotificationTitle());
        }
        if (item.getNotificationMessage() != null) {
            Element messageElement = doc.createElementNS(NAMESPACE_URI, XML_NOTIFICATION_MESSAGE);
            messageElement.setTextContent(item.getNotificationMessage());
            element.appendChild(messageElement);
        }
        if (item.getNotificationLink() != null) {
            Element notificationLinkElement = doc.createElementNS(NAMESPACE_URI, XML_NOTIFICATION_LINK);
            notificationLinkElement.appendChild(this.createLinkElement(doc, item.getNotificationLink()));
            element.appendChild(notificationLinkElement);
        }
        if (item.getSoundNotificationPath() != null) {
            this.setAttribute(element, XML_SOUND_NOTIFICATION, item.getSoundNotificationPath());
        }
        if (item.getStatisticsCountLabel() != null) {
            this.setAttribute(element, XML_STATISTICS_COUNT_LABEL, item.getStatisticsCountLabel());
        }
        if (item.getStatisticsValueLabel() != null) {
            this.setAttribute(element, XML_STATISTICS_VALUE_LABEL, item.getStatisticsValueLabel());
        }
        if (item.getStatisticsValuePattern() != null) {
            this.setAttribute(element, XML_STATISTICS_VALUE_PATTERN, item.getStatisticsValuePattern());
        }
        if (item.getErrorLogLevel() > 0) {
            this.setAttribute(element, XML_ERROR_LOG_LEVEL, item.getErrorLogLevel());
        }
        if (item.getErrorLogMessage() != null) {
            this.setAttribute(element, XML_ERROR_LOG_MESSAGE, item.getErrorLogMessage());
        }
        GrepGroup[] grepGroupArray = item.getGroups();
        int n = grepGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            group = grepGroupArray[n2];
            style = group.getStyle();
            link = group.getLink();
            groupElement = doc.createElementNS(NAMESPACE_URI, XML_GROUP);
            if (group.getName() != null) {
                groupElement.setAttribute(XML_NAME, group.getName());
            }
            if (style != null) {
                groupElement.setAttribute(XML_STYLE, style.getId());
            }
            if ((linkElement = this.createLinkElement(doc, link)) != null) {
                groupElement.appendChild(linkElement);
            }
            element.appendChild(groupElement);
            ++n2;
        }
        if (item.getRewriteGroups() != null) {
            grepGroupArray = item.getRewriteGroups();
            n = grepGroupArray.length;
            n2 = 0;
            while (n2 < n) {
                group = grepGroupArray[n2];
                style = group.getStyle();
                link = group.getLink();
                groupElement = doc.createElementNS(NAMESPACE_URI, XML_REWRITE_GROUP);
                if (style != null) {
                    groupElement.setAttribute(XML_STYLE, style.getId());
                }
                if ((linkElement = this.createLinkElement(doc, link)) != null) {
                    groupElement.appendChild(linkElement);
                }
                element.appendChild(groupElement);
                ++n2;
            }
        }
        return element;
    }

    public String createLinkXmlString(IGrepLink link) throws ParserConfigurationException, TransformerException {
        if (link == null) {
            return null;
        }
        Document doc = this.createLinkDocument(link);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StreamResult result = new StreamResult(new StringWriter());
        transformer.transform(new DOMSource(doc), result);
        return result.getWriter().toString();
    }

    public Document createLinkDocument(IGrepLink link) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder bd = factory.newDocumentBuilder();
        Document doc = bd.newDocument();
        doc.appendChild(this.createLinkElement(doc, link));
        return doc;
    }

    private Element createLinkElement(Document doc, IGrepLink link) {
        Element linkElement;
        if (link instanceof UrlLink) {
            UrlLink urlLink = (UrlLink)link;
            linkElement = doc.createElementNS(NAMESPACE_URI, XML_URL_LINK);
            linkElement.setAttribute(XML_URL_PATTERN, urlLink.getUrlPattern());
            if (urlLink.isExternal()) {
                linkElement.setAttribute(XML_EXTERNAL, String.valueOf(Boolean.TRUE));
            }
        } else if (link instanceof FileLink) {
            FileLink fileLink = (FileLink)link;
            linkElement = doc.createElementNS(NAMESPACE_URI, XML_FILE_LINK);
            linkElement.setAttribute(XML_FILE, fileLink.getFilePattern());
            linkElement.setAttribute(XML_BASE_DIR, fileLink.getBaseDirPattern());
            linkElement.setAttribute(XML_LINE_NUMBER, fileLink.getLineNumberPattern());
            linkElement.setAttribute(XML_OFFSET, fileLink.getOffsetPattern());
        } else if (link instanceof JavaLink) {
            JavaLink javaLink = (JavaLink)link;
            linkElement = doc.createElementNS(NAMESPACE_URI, XML_JAVA_LINK);
            linkElement.setAttribute("type", javaLink.getTypePattern());
            linkElement.setAttribute(XML_LINE_NUMBER, javaLink.getLineNumberPattern());
            linkElement.setAttribute(XML_OFFSET, javaLink.getOffsetPattern());
        } else if (link instanceof CommandLink) {
            CommandLink commandLink = (CommandLink)link;
            linkElement = doc.createElementNS(NAMESPACE_URI, XML_COMMAND_LINK);
            linkElement.setAttribute(XML_COMMAND, commandLink.getCommandPattern());
            linkElement.setAttribute(XML_WORKING_DIR, commandLink.getWorkingDirPattern());
        } else if (link instanceof ScriptLink) {
            ScriptLink scriptLink = (ScriptLink)link;
            linkElement = doc.createElementNS(NAMESPACE_URI, XML_SCRIPT_LINK);
            linkElement.setAttribute(XML_LANGUAGE, scriptLink.getLanguage());
            linkElement.setTextContent(scriptLink.getCode());
        } else {
            linkElement = null;
        }
        return linkElement;
    }

    public IGrepLink readLink(String xml) throws XmlHandlerException {
        return this.readLink(new InputSource(new StringReader(xml)));
    }

    public IGrepLink readLink(InputStream in) throws XmlHandlerException {
        return this.readLink(new InputSource(in));
    }

    public IGrepLink readLink(InputSource source) throws XmlHandlerException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(SILENT_ERROR_HANDLER);
            Document doc = builder.parse(source);
            doc.getDocumentElement().normalize();
            return this.readLink(doc);
        }
        catch (ParserConfigurationException ex) {
            throw new XmlHandlerException(ex);
        }
        catch (SAXException ex) {
            throw new XmlHandlerException(ex);
        }
        catch (IOException ex) {
            throw new XmlHandlerException(ex);
        }
    }

    public IGrepLink readLink(Document doc) throws XmlHandlerException {
        return this.readLink(doc.getDocumentElement());
    }

    public GrepExpressionRootFolder readExpressions(String xml) throws XmlHandlerException {
        return this.readExpressions(new InputSource(new StringReader(xml)));
    }

    public GrepExpressionRootFolder readExpressions(InputStream in) throws XmlHandlerException {
        return this.readExpressions(new InputSource(in));
    }

    public GrepExpressionRootFolder readExpressions(InputSource source) throws XmlHandlerException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(SILENT_ERROR_HANDLER);
            Document doc = builder.parse(source);
            doc.getDocumentElement().normalize();
            return this.readExpressions(doc);
        }
        catch (ParserConfigurationException ex) {
            throw new XmlHandlerException(ex);
        }
        catch (SAXException ex) {
            throw new XmlHandlerException(ex);
        }
        catch (IOException ex) {
            throw new XmlHandlerException(ex);
        }
    }

    public GrepExpressionRootFolder readExpressions(Document doc) throws XmlHandlerException {
        return this.readExpressions(doc.getDocumentElement());
    }

    public GrepExpressionRootFolder readExpressions(Element element) throws XmlHandlerException {
        GrepExpressionRootFolder rootFolder = new GrepExpressionRootFolder();
        Element[] elementArray = this.getChildren(element, XML_STYLE);
        int n = elementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Element childElement = elementArray[n2];
            rootFolder.addStyle(this.readStyle(childElement));
            ++n2;
        }
        Element folderElement = this.getChild(element, XML_FOLDER);
        if (folderElement == null) {
            throw new XmlHandlerException("Element " + element.getLocalName() + " must have a " + XML_FOLDER + " element.");
        }
        this.fillFolderFromElement(folderElement, rootFolder, rootFolder);
        return rootFolder;
    }

    private Element getChild(Element element, String name) throws XmlHandlerException {
        Element[] children = this.getChildren(element, name);
        if (children.length > 1) {
            throw new XmlHandlerException("Element " + element.getLocalName() + " must not have more than one " + name + " element.");
        }
        return children.length == 0 ? null : children[0];
    }

    private GrepStyle readStyle(Element element) throws XmlHandlerException {
        String id = this.getAttribute(element, XML_ID, null);
        GrepStyle style = new GrepStyle(id);
        style.setName(this.getAttribute(element, XML_NAME, null));
        style.setForeground(this.getRgbAttribute(element, XML_FOREGROUND, null));
        style.setBackground(this.getRgbAttribute(element, XML_BACKGROUND, null));
        style.setBold(this.getBooleanAttribute(element, XML_BOLD, false));
        style.setItalic(this.getBooleanAttribute(element, XML_ITALIC, false));
        style.setUnderline(this.getBooleanAttribute(element, XML_UNDERLINE, false));
        style.setUnderlineColor(this.getRgbAttribute(element, XML_UNDERLINE_COLOR, null));
        style.setStrikeout(this.getBooleanAttribute(element, XML_STRIKEOUT, false));
        style.setStrikeoutColor(this.getRgbAttribute(element, XML_STRIKEOUT_COLOR, null));
        style.setBorder(this.getBooleanAttribute(element, XML_BORDER, false));
        style.setBorderColor(this.getRgbAttribute(element, XML_BORDER_COLOR, null));
        return style;
    }

    public GrepExpressionFolder readFolder(Element element, GrepExpressionRootFolder root) throws XmlHandlerException {
        String id = this.getAttribute(element, XML_ID, null);
        GrepExpressionFolder folder = new GrepExpressionFolder(id);
        this.fillFolderFromElement(element, folder, root);
        return folder;
    }

    private Element[] getChildren(Element element, String name) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1 && NAMESPACE_URI.equals(node.getNamespaceURI()) && (name == null || name.equals(node.getLocalName()))) {
                elements.add((Element)node);
            }
            ++i;
        }
        return elements.toArray(new Element[elements.size()]);
    }

    private void fillFolderFromElement(Element element, GrepExpressionFolder folder, GrepExpressionRootFolder root) throws XmlHandlerException {
        Boolean notifications;
        Boolean statistics;
        Boolean filter;
        folder.setName(this.getAttribute(element, XML_NAME, null));
        Boolean enablement = this.getBooleanAttribute(element, XML_ENABLED, false);
        if (enablement != null) {
            folder.setDefaultEnabled(enablement);
        }
        if ((filter = this.getBooleanAttribute(element, XML_FILTER, false)) != null) {
            folder.setDefaultFilter(filter);
        }
        if ((statistics = this.getBooleanAttribute(element, XML_STATISTICS, false)) != null) {
            folder.setDefaultStatistics(statistics);
        }
        if ((notifications = this.getBooleanAttribute(element, XML_NOTIFICATIONS, false)) != null) {
            folder.setDefaultNotifications(notifications);
        }
        Element[] elementArray = this.getChildren(element, null);
        int n = elementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Element childElement = elementArray[n2];
            String name = childElement.getLocalName();
            if (XML_FOLDER.equals(name)) {
                folder.add(this.readFolder(childElement, root));
            } else if (XML_ITEM.equals(name)) {
                folder.add(this.readItem(childElement, root));
            }
            ++n2;
        }
    }

    private AbstractGrepModelElement readItem(Element element, GrepExpressionRootFolder root) throws XmlHandlerException {
        Boolean removeOriginalStyle;
        Boolean caseInsensitive;
        Boolean notifications;
        Boolean statistics;
        Boolean filter;
        String id = this.getAttribute(element, XML_ID, null);
        GrepExpressionItem item = new GrepExpressionItem(id);
        Boolean enablement = this.getBooleanAttribute(element, XML_ENABLED, false);
        if (enablement != null) {
            item.setDefaultEnabled(enablement == null ? false : enablement);
        }
        if ((filter = this.getBooleanAttribute(element, XML_FILTER, false)) != null) {
            item.setDefaultFilter(filter);
        }
        if ((statistics = this.getBooleanAttribute(element, XML_STATISTICS, false)) != null) {
            item.setDefaultStatistics(statistics);
        }
        if ((notifications = this.getBooleanAttribute(element, XML_NOTIFICATIONS, false)) != null) {
            item.setDefaultNotifications(notifications);
        }
        if ((caseInsensitive = this.getBooleanAttribute(element, XML_CASE_INSENSITIVE, false)) != null) {
            item.setCaseInsensitive(caseInsensitive);
        }
        if ((removeOriginalStyle = this.getBooleanAttribute(element, XML_REMOVE_ORIGINAL_STYLE, false)) != null) {
            item.setRemoveOriginalStyle(removeOriginalStyle);
        }
        item.setName(this.getAttribute(element, XML_NAME, null));
        item.setGrepExpression(this.getAttribute(element, XML_EXPRESSION, null));
        item.setQuickGrepExpression(this.getAttribute(element, XML_QUICK_EXPRESSION, null));
        item.setUnlessGrepExpression(this.getAttribute(element, XML_UNLESS_EXPRESSION, null));
        item.setRewriteExpression(this.getAttribute(element, XML_REWRITE_EXPRESSION, null));
        item.setPopupNotification(this.getBooleanAttribute(element, XML_POPUP_NOTIFICATION, false));
        item.setNotificationTitle(this.getAttribute(element, XML_NOTIFICATION_TITLE, null));
        item.setSoundNotificationPath(this.getAttribute(element, XML_SOUND_NOTIFICATION, null));
        item.setStatisticsCountLabel(this.getAttribute(element, XML_STATISTICS_COUNT_LABEL, null));
        item.setStatisticsValueLabel(this.getAttribute(element, XML_STATISTICS_VALUE_LABEL, null));
        item.setStatisticsValuePattern(this.getAttribute(element, XML_STATISTICS_VALUE_PATTERN, null));
        item.setErrorLogLevel(this.getIntegerAttribute(element, XML_ERROR_LOG_LEVEL, 0));
        item.setErrorLogMessage(this.getAttribute(element, XML_ERROR_LOG_MESSAGE, null));
        ArrayList<GrepGroup> groups = new ArrayList<GrepGroup>();
        ArrayList<GrepGroup> rewriteGroups = new ArrayList<GrepGroup>();
        Element[] elementArray = this.getChildren(element, null);
        int n = elementArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            IGrepLink link;
            Element linkElement;
            GrepStyle style;
            Element childElement = elementArray[n2];
            if (XML_STYLE.equals(childElement.getLocalName())) {
                style = null;
                String styleId = this.getAttribute(childElement, XML_ID, null);
                if (styleId == null) {
                    style = null;
                } else {
                    style = root.getStyle(styleId);
                    if (style == null) {
                        throw new XmlHandlerException("Undefined style " + styleId + ".");
                    }
                }
                GrepGroup group = new GrepGroup();
                group.setName(null);
                group.setStyle(style);
                group.setLink(null);
                groups.add(group);
            } else if (XML_NOTIFICATION_MESSAGE.equals(childElement.getLocalName())) {
                item.setNotificationMessage(childElement.getTextContent());
            } else if (XML_NOTIFICATION_LINK.equals(childElement.getLocalName())) {
                linkElement = this.getChild(childElement, null);
                link = this.readLink(linkElement);
                if (link != null) {
                    item.setNotificationLink(link);
                }
            } else if ("type".equals(childElement.getLocalName())) {
                linkElement = this.getChild(childElement, null);
                link = this.readLink(linkElement);
                if (link != null) {
                    item.setAutostartLink(link);
                }
            } else if (XML_GROUP.equals(childElement.getLocalName())) {
                String name = this.getAttribute(childElement, XML_NAME, null);
                GrepStyle style2 = null;
                IGrepLink link2 = null;
                String styleId = this.getAttribute(childElement, XML_STYLE, null);
                if (styleId == null) {
                    style2 = null;
                } else {
                    style2 = root.getStyle(styleId);
                    if (style2 == null) {
                        throw new XmlHandlerException("Undefined style " + styleId + ".");
                    }
                }
                Element[] elementArray2 = this.getChildren(childElement, null);
                int n4 = elementArray2.length;
                n3 = 0;
                while (n3 < n4) {
                    Element groupChildElement = elementArray2[n3];
                    link2 = this.readLink(groupChildElement);
                    ++n3;
                }
                GrepGroup group = new GrepGroup();
                group.setName(name);
                group.setStyle(style2);
                group.setLink(link2);
                groups.add(group);
            } else if (XML_REWRITE_GROUP.equals(childElement.getLocalName())) {
                style = null;
                link = null;
                String styleId = this.getAttribute(childElement, XML_STYLE, null);
                if (styleId == null) {
                    style = null;
                } else {
                    style = root.getStyle(styleId);
                    if (style == null) {
                        throw new XmlHandlerException("Undefined style " + styleId + ".");
                    }
                }
                Element[] elementArray3 = this.getChildren(childElement, null);
                n3 = elementArray3.length;
                int n5 = 0;
                while (n5 < n3) {
                    Element groupChildElement = elementArray3[n5];
                    link = this.readLink(groupChildElement);
                    ++n5;
                }
                GrepGroup group = new GrepGroup();
                group.setStyle(style);
                group.setLink(link);
                rewriteGroups.add(group);
            }
            ++n2;
        }
        item.setGroups(groups.toArray(new GrepGroup[groups.size()]));
        item.setRewriteGroups(rewriteGroups == null ? null : rewriteGroups.toArray(new GrepGroup[rewriteGroups.size()]));
        return item;
    }

    private IGrepLink readLink(Element element) {
        if (!NAMESPACE_URI.equals(element.getNamespaceURI())) {
            return null;
        }
        if (XML_URL_LINK.equals(element.getLocalName())) {
            UrlLink urlLink = new UrlLink();
            urlLink.setUrlPattern(this.getAttribute(element, XML_URL_PATTERN, null));
            urlLink.setExternal(Boolean.parseBoolean(this.getAttribute(element, XML_EXTERNAL, String.valueOf(Boolean.FALSE))));
            return urlLink;
        }
        if (XML_COMMAND_LINK.equals(element.getLocalName())) {
            CommandLink commandLink = new CommandLink();
            commandLink.setCommandPattern(this.getAttribute(element, XML_COMMAND, null));
            commandLink.setWorkingDirPattern(this.getAttribute(element, XML_WORKING_DIR, null));
            return commandLink;
        }
        if (XML_FILE_LINK.equals(element.getLocalName())) {
            FileLink fileLink = new FileLink();
            fileLink.setFilePattern(this.getAttribute(element, XML_FILE, null));
            fileLink.setBaseDirPattern(this.getAttribute(element, XML_BASE_DIR, null));
            fileLink.setLineNumberPattern(this.getAttribute(element, XML_LINE_NUMBER, null));
            fileLink.setOffsetPattern(this.getAttribute(element, XML_OFFSET, null));
            return fileLink;
        }
        if (XML_JAVA_LINK.equals(element.getLocalName())) {
            JavaLink javaLink = new JavaLink();
            javaLink.setTypePattern(this.getAttribute(element, "type", null));
            javaLink.setLineNumberPattern(this.getAttribute(element, XML_LINE_NUMBER, null));
            javaLink.setOffsetPattern(this.getAttribute(element, XML_OFFSET, null));
            return javaLink;
        }
        if (XML_SCRIPT_LINK.equals(element.getLocalName())) {
            ScriptLink scriptLink = new ScriptLink();
            scriptLink.setLanguage(this.getAttribute(element, XML_LANGUAGE, null));
            scriptLink.setCode(element.getTextContent());
            return scriptLink;
        }
        return null;
    }

    private String getAttribute(Element element, String attribute, String defaultValue) {
        return element.hasAttribute(attribute) ? element.getAttribute(attribute) : defaultValue;
    }

    private Boolean getBooleanAttribute(Element element, String attribute, Boolean defaultValue) {
        String s = this.getAttribute(element, attribute, null);
        if (s == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(s);
    }

    private Integer getIntegerAttribute(Element element, String attribute, Integer defaultValue) {
        String s = this.getAttribute(element, attribute, null);
        if (s == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private RGB getRgbAttribute(Element element, String attribute, RGB defaultValue) throws XmlHandlerException {
        String s = this.getAttribute(element, attribute, null);
        if (s == null) {
            return defaultValue;
        }
        try {
            return GrepConsoleUtil.stringToRgb(s);
        }
        catch (NumberFormatException ex) {
            throw new XmlHandlerException("Not a valid RGB value: " + s, ex);
        }
    }

    public void recalculateStyleSet(GrepExpressionRootFolder folder) {
        LinkedHashSet<GrepStyle> styles = new LinkedHashSet<GrepStyle>(folder.getStyles());
        styles.clear();
        this.collectStyles(folder, styles);
        folder.setStyles(styles);
    }

    private void collectStyles(GrepExpressionFolder folder, Set<GrepStyle> styles) {
        for (AbstractGrepModelElement element : folder.getChildren()) {
            if (element instanceof GrepExpressionFolder) {
                this.collectStyles((GrepExpressionFolder)element, styles);
                continue;
            }
            GrepExpressionItem item = (GrepExpressionItem)element;
            GrepGroup[] grepGroupArray = item.getGroups();
            int n = grepGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                GrepGroup group = grepGroupArray[n2];
                styles.add(group.getStyle());
                ++n2;
            }
        }
    }
}

