/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import name.schedenig.eclipse.grepconsole.i18n.Messages;

public class SoundManager {
    private static final int BUFFER_SIZE = 4096;
    private LinkedHashMap<String, byte[]> samples;
    private ReentrantLock samplesLock = new ReentrantLock();

    public SoundManager(final int cacheSize) {
        this.samples = new LinkedHashMap<String, byte[]>(cacheSize){

            @Override
            public boolean removeEldestEntry(Map.Entry<String, byte[]> eldest) {
                return this.size() > cacheSize;
            }
        };
    }

    public synchronized void dispose() {
        this.samplesLock.lock();
        try {
            this.samples.clear();
        }
        finally {
            this.samplesLock.unlock();
        }
    }

    private synchronized AudioInputStream getAudioInputStream(String path) throws IOException, UnsupportedAudioFileException, LineUnavailableException {
        byte[] bytes;
        this.samplesLock.lock();
        try {
            bytes = (byte[])this.samples.remove(path);
            if (bytes == null) {
                File file = new File(path);
                if (!file.exists()) {
                    throw new IOException(MessageFormat.format(Messages.SoundManager_file_not_found_file, path));
                }
                FileInputStream in = new FileInputStream(file);
                try {
                    int count;
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    byte[] buffer = new byte[4096];
                    while ((count = in.read(buffer)) >= 0) {
                        bout.write(buffer, 0, count);
                    }
                    bout.close();
                    bytes = bout.toByteArray();
                }
                finally {
                    in.close();
                }
            }
            this.samples.put(path, bytes);
        }
        finally {
            this.samplesLock.unlock();
        }
        AudioInputStream in = AudioSystem.getAudioInputStream(new ByteArrayInputStream(bytes));
        return in;
    }

    public synchronized void playSound(String soundPath) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        AudioInputStream in = this.getAudioInputStream(soundPath);
        if (in != null) {
            AudioFormat format = in.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(in);
            this.startClip(clip);
        }
    }

    private synchronized void startClip(Clip clip) {
        new Thread(new PlayClipRunnable(clip)).start();
    }

    private class PlayClipRunnable
    implements Runnable,
    LineListener {
        private Clip clip;
        private CountDownLatch latch = new CountDownLatch(1);

        public PlayClipRunnable(Clip clip) {
            this.clip = clip;
        }

        @Override
        public void run() {
            this.clip.addLineListener(this);
            this.clip.start();
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            this.clip.close();
        }

        @Override
        public void update(LineEvent event) {
            if (event.getType() == LineEvent.Type.STOP) {
                this.latch.countDown();
            }
        }
    }
}

