/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.items;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.adapters.GrepLineStyleListener;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.AbstractGrepModelElement;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionFolder;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionItem;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionRootFolder;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionsWithSelection;
import name.schedenig.eclipse.grepconsole.model.xml.XmlHandler;
import name.schedenig.eclipse.grepconsole.model.xml.XmlHandlerException;
import name.schedenig.eclipse.grepconsole.util.GridLayoutBuilder;
import name.schedenig.eclipse.grepconsole.view.colors.ColorRegistry;
import name.schedenig.eclipse.grepconsole.view.common.CharacterMarginPainter;
import name.schedenig.eclipse.grepconsole.view.items.ExpressionDialog;
import name.schedenig.eclipse.grepconsole.view.items.FolderDialog;
import name.schedenig.eclipse.grepconsole.view.items.ItemsTreePanel;
import name.schedenig.eclipse.grepconsole.view.items.LineLengthChecker;
import name.schedenig.eclipse.grepconsole.view.items.PreviewColorHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class EditableItemsPanel
extends Composite
implements ItemsTreePanel.IItemTreeListener {
    public static final RGB COLOR_STYLE_MATCH_LENGTH_LIMIT = new RGB(64, 255, 64);
    public static final RGB COLOR_FILTER_MATCH_LENGTH_LIMIT = new RGB(64, 64, 255);
    private Integer sashPosition;
    private GrepLineStyleListener grepLineStyleListener;
    private ColorRegistry colorRegistry;
    private String previewText;
    private Button btnAddFolder;
    private Button btnAddExpression;
    private Button btnEdit;
    private Button btnRemove;
    private ItemsTreePanel treePanel;
    private Clipboard clipboard;
    private Button btnSaveSelected;
    private Button btnSaveAll;
    private Button btnLoad;
    private StyledText stPreview;
    private Menu treeMenu;
    private MenuItem miCut;
    private MenuItem miCopy;
    private MenuItem miPaste;
    private Composite panelTreeAndButtons;
    private Sash sash;
    private Menu menuPreview;
    private MenuItem miAddExpressionFromPreview;
    private MenuItem miLoadDefault;
    private MenuItem miSaveDefault;
    private Label labelPreview;
    private Font headerFont;
    private CharacterMarginPainter marginPainter;
    private LineLengthChecker lengthChecker;
    private Label labelLengthWarning;

    public EditableItemsPanel(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    private void init() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EditableItemsPanel.this.colorRegistry.disposeColors();
            }
        });
        this.headerFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
        this.colorRegistry = new ColorRegistry(Activator.getDefault().getColorRegistry());
        this.clipboard = new Clipboard(this.getDisplay());
        this.setLayoutData(new GridData(1808));
        FormLayout layout = new FormLayout();
        this.setLayout((Layout)layout);
        this.panelTreeAndButtons = new Composite((Composite)this, 0);
        new GridLayoutBuilder(this.panelTreeAndButtons, 2, false).setMargins(0).apply();
        this.treePanel = new ItemsTreePanel(this.panelTreeAndButtons, 2048);
        this.treePanel.setLayoutData(new GridData(4, 4, true, true, 1, 10));
        this.treePanel.addListener(this);
        this.hookTreeDragAndDrop();
        Tree tree = this.treePanel.getTree();
        this.treeMenu = new Menu((Control)tree);
        this.treeMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                EditableItemsPanel.this.refreshMenuItems();
            }
        });
        this.miCut = new MenuItem(this.treeMenu, 8);
        this.miCut.setText(Messages.EditableItemsPanel_cut);
        this.miCut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditableItemsPanel.this.doCopy(true);
            }
        });
        this.miCopy = new MenuItem(this.treeMenu, 8);
        this.miCopy.setText(Messages.EditableItemsPanel_copy);
        this.miCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditableItemsPanel.this.doCopy(false);
            }
        });
        this.miPaste = new MenuItem(this.treeMenu, 8);
        this.miPaste.setText(Messages.EditableItemsPanel_paste);
        this.miPaste.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditableItemsPanel.this.doPaste();
            }
        });
        tree.setMenu(this.treeMenu);
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    EditableItemsPanel.this.doRemove();
                    e.doit = false;
                } else if (e.keyCode == 0x100000B) {
                    EditableItemsPanel.this.doEdit();
                    e.doit = false;
                } else if (e.keyCode == 99 && (e.stateMask & SWT.MOD1) != 0) {
                    EditableItemsPanel.this.doCopy(false);
                    e.doit = false;
                } else if (e.keyCode == 120 && (e.stateMask & SWT.MOD1) != 0) {
                    EditableItemsPanel.this.doCopy(true);
                    e.doit = false;
                } else if (e.keyCode == 118 && (e.stateMask & SWT.MOD1) != 0) {
                    EditableItemsPanel.this.doPaste();
                }
            }
        });
        this.btnAddFolder = new Button(this.panelTreeAndButtons, 8);
        this.btnAddFolder.setText(Messages.EditableItemsPanel_add_folder);
        this.btnAddFolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnAddFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditableItemsPanel.this.doAddFolder();
            }
        });
        this.btnAddExpression = new Button(this.panelTreeAndButtons, 8);
        this.btnAddExpression.setText(Messages.EditableItemsPanel_add_expression);
        this.btnAddExpression.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnAddExpression.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditableItemsPanel.this.doAddExpression(null);
            }
        });
        this.btnEdit = new Button(this.panelTreeAndButtons, 8);
        this.btnEdit.setText(Messages.EditableItemsPanel_edit);
        this.btnEdit.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditableItemsPanel.this.doEdit();
            }
        });
        this.btnRemove = new Button(this.panelTreeAndButtons, 8);
        this.btnRemove.setText(Messages.EditableItemsPanel_remove);
        this.btnRemove.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditableItemsPanel.this.doRemove();
            }
        });
        this.btnLoad = new Button(this.panelTreeAndButtons, 8);
        this.btnLoad.setText(Messages.EditableItemsPanel_load);
        this.btnLoad.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditableItemsPanel.this.doLoad();
            }
        });
        this.btnSaveSelected = new Button(this.panelTreeAndButtons, 8);
        this.btnSaveSelected.setText(Messages.EditableItemsPanel_save_selected);
        this.btnSaveSelected.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnSaveSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditableItemsPanel.this.doSave(false);
            }
        });
        this.btnSaveAll = new Button(this.panelTreeAndButtons, 8);
        this.btnSaveAll.setText(Messages.EditableItemsPanel_save_all);
        this.btnSaveAll.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnSaveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditableItemsPanel.this.doSave(true);
            }
        });
        this.sash = new Sash((Composite)this, 65792);
        this.labelPreview = new Label((Composite)this, 0);
        this.labelPreview.setFont(this.headerFont);
        this.labelPreview.setText(Messages.EditableItemsPanel_preview);
        this.labelLengthWarning = new Label((Composite)this, 0);
        this.labelLengthWarning.setAlignment(0x1000008);
        this.labelLengthWarning.setText(LineLengthChecker.LABEL_TEXT);
        this.labelLengthWarning.setVisible(false);
        this.grepLineStyleListener = new GrepLineStyleListener(this.getShell(), null);
        this.grepLineStyleListener.setColorRegistry(this.colorRegistry);
        this.stPreview = new StyledText((Composite)this, 2818);
        this.stPreview.addLineStyleListener((LineStyleListener)this.grepLineStyleListener);
        this.stPreview.setFont(JFaceResources.getTextFont());
        this.updatePreviewToolTip();
        this.lengthChecker = new LineLengthChecker(this.stPreview);
        this.lengthChecker.addListener(new LineLengthChecker.Listener(){

            @Override
            public void exceedsChanged() {
                EditableItemsPanel.this.updateLengthWarning();
            }
        });
        this.marginPainter = new CharacterMarginPainter((Control)this.stPreview);
        this.marginPainter.addMargin(Activator.getDefault().getStyleMatchLength(), this.colorRegistry.get(COLOR_STYLE_MATCH_LENGTH_LIMIT));
        this.marginPainter.addMargin(Activator.getDefault().getFilterMatchLength(), this.colorRegistry.get(COLOR_FILTER_MATCH_LENGTH_LIMIT));
        this.menuPreview = new Menu((Control)this.stPreview);
        this.miAddExpressionFromPreview = new MenuItem(this.menuPreview, 8);
        this.miAddExpressionFromPreview.setText(Messages.EditableItemsPanel_add_expression);
        this.miAddExpressionFromPreview.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditableItemsPanel.this.doAddExpression(EditableItemsPanel.this.stPreview.getSelectionText());
            }
        });
        this.miLoadDefault = new MenuItem(this.menuPreview, 8);
        this.miLoadDefault.setText(Messages.EditableItemsPanel_load_default);
        this.miLoadDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditableItemsPanel.this.doLoadDefaultPreview();
            }
        });
        this.miSaveDefault = new MenuItem(this.menuPreview, 8);
        this.miSaveDefault.setText(Messages.EditableItemsPanel_save_default);
        this.miSaveDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditableItemsPanel.this.doSaveDefaultPreview();
            }
        });
        new MenuItem(this.menuPreview, 2);
        new PreviewColorHandler((Control)this.stPreview, this.menuPreview);
        this.menuPreview.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Set<AbstractGrepModelElement> selection = EditableItemsPanel.this.treePanel.getSelectedElements();
                boolean hasSelection = selection != null && !selection.isEmpty();
                String text = EditableItemsPanel.this.stPreview.getSelectionText();
                EditableItemsPanel.this.miAddExpressionFromPreview.setEnabled(hasSelection && text != null && text.length() > 0);
                super.menuShown(e);
            }
        });
        this.stPreview.setMenu(this.menuPreview);
        int preferredPreviewHeight = this.getDisplay().getDPI().y * JFaceResources.getTextFont().getFontData()[0].getHeight() / 72 * 4;
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment((Control)this.sash, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.panelTreeAndButtons.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -this.sash.computeSize((int)-1, (int)-1).y - preferredPreviewHeight);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.sash.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.sash, 5);
        fd.left = new FormAttachment(0, 0);
        this.labelPreview.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.sash, 5);
        fd.right = new FormAttachment(100, 0);
        this.labelLengthWarning.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.labelPreview, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.stPreview.setLayoutData((Object)fd);
        this.sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle sashBounds = EditableItemsPanel.this.sash.getBounds();
                Rectangle clientArea = EditableItemsPanel.this.getClientArea();
                EditableItemsPanel.this.setSashPosition(-(clientArea.height - sashBounds.height - e.y));
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int height = EditableItemsPanel.this.getSize().y;
                FormData fd = (FormData)EditableItemsPanel.this.sash.getLayoutData();
                int min = -height + 50;
                if (min > 0) {
                    min = 0;
                }
                if (fd.bottom.offset <= min) {
                    EditableItemsPanel.this.setSashPosition(min);
                }
            }
        });
        if (this.sashPosition != null) {
            this.setSashPosition(this.sashPosition);
        }
        this.refreshButtons();
        if (this.previewText == null || this.previewText.trim().length() == 0) {
            this.stPreview.setText(Activator.getDefault().getPreviewText());
        } else {
            this.stPreview.setText(this.previewText);
        }
    }

    private void doLoadDefaultPreview() {
        this.stPreview.setText(Activator.getDefault().getPreviewText());
    }

    private void doSaveDefaultPreview() {
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.Preview_save_default_preview_title, (String)Messages.Preview_save_default_preview_confirm)) {
            Activator.getDefault().setPreviewText(this.stPreview.getText());
        }
    }

    protected void setSashPosition(Integer sashPosition) {
        this.sashPosition = sashPosition;
        if (this.sash != null && sashPosition != null) {
            FormData fd = (FormData)this.sash.getLayoutData();
            fd.bottom = new FormAttachment(100, sashPosition.intValue());
            this.layout();
        }
    }

    public Integer getSashPosition() {
        return this.sashPosition;
    }

    private void hookTreeDragAndDrop() {
        final Tree tree = this.treePanel.getTree();
        Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
        DragSource source = new DragSource((Control)tree, 2);
        source.setTransfer(transferTypes);
        source.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = EditableItemsPanel.this.buildXml(false, null, true);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        DropTarget target = new DropTarget((Control)tree, 2);
        target.setTransfer(transferTypes);
        target.addDropListener(new DropTargetListener(){

            public void dropAccept(DropTargetEvent event) {
            }

            private GrepExpressionRootFolder getDropRoot(String xml) {
                XmlHandler handler = new XmlHandler();
                try {
                    return handler.readExpressions(xml);
                }
                catch (XmlHandlerException ex) {
                    Activator.getDefault().log(4, Messages.EditableItemsPanel_paste_failed, ex);
                    return null;
                }
            }

            public void drop(DropTargetEvent event) {
                int offset;
                GrepExpressionFolder targetFolder;
                if (event.data == null) {
                    event.detail = 0;
                    return;
                }
                event.detail = 0;
                GrepExpressionRootFolder dropRoot = this.getDropRoot((String)event.data);
                if (dropRoot == null) {
                    return;
                }
                HashSet<GrepExpressionFolder> folders = new HashSet<GrepExpressionFolder>();
                HashSet<GrepExpressionItem> items = new HashSet<GrepExpressionItem>();
                for (AbstractGrepModelElement element : dropRoot.getChildren()) {
                    if (element instanceof GrepExpressionFolder) {
                        folders.add((GrepExpressionFolder)element);
                        continue;
                    }
                    items.add((GrepExpressionItem)element);
                }
                if (!folders.isEmpty() && !items.isEmpty()) {
                    event.detail = 0;
                    return;
                }
                boolean droppingFolders = !folders.isEmpty();
                TreeItem item = (TreeItem)event.item;
                if (item == null) {
                    event.detail = 0;
                    return;
                }
                AbstractGrepModelElement targetElement = (AbstractGrepModelElement)item.getData();
                Point pt = tree.getDisplay().map(null, (Control)tree, event.x, event.y);
                Rectangle bounds = item.getBounds();
                GrepExpressionFolder root = EditableItemsPanel.this.getRootFolder();
                boolean isFolder = item.getData() instanceof GrepExpressionFolder;
                if (pt.y < bounds.y + (isFolder ? bounds.height / 3 : bounds.height / 2)) {
                    targetFolder = targetElement.getParent();
                    offset = targetFolder.getChildren().indexOf(targetElement);
                } else if (!isFolder || pt.y > bounds.y + 2 * bounds.height / 3) {
                    targetFolder = targetElement.getParent();
                    offset = targetFolder.getChildren().indexOf(targetElement) + 1;
                } else {
                    targetFolder = (GrepExpressionFolder)(isFolder ? targetElement : targetElement.getParent());
                    int n = offset = isFolder ? -1 : targetFolder.getChildren().indexOf(targetElement);
                }
                if (droppingFolders && targetFolder != root) {
                    offset = root.getChildren().indexOf(targetFolder) + 1;
                    targetFolder = root;
                } else if (!droppingFolders && targetFolder == root) {
                    if (offset <= 0 || offset > root.getChildren().size()) {
                        event.detail = 0;
                        return;
                    }
                    targetFolder = (GrepExpressionFolder)root.getChildren().get(offset - 1);
                    offset = -1;
                }
                LinkedList<AbstractGrepModelElement> remove = new LinkedList<AbstractGrepModelElement>();
                LinkedList<AbstractGrepModelElement> dropElements = new LinkedList<AbstractGrepModelElement>(dropRoot.getChildren());
                for (AbstractGrepModelElement element : dropElements) {
                    remove.add(root.findById(element.getId()));
                    targetFolder.add(element, offset);
                    if (offset < 0) continue;
                    ++offset;
                }
                for (AbstractGrepModelElement element : remove) {
                    element.getParent().remove(element);
                }
                EditableItemsPanel.this.treePanel.refresh();
            }

            public void dragOver(DropTargetEvent event) {
                TextTransfer textTransfer = TextTransfer.getInstance();
                if (!textTransfer.isSupportedType(event.currentDataType)) {
                    event.operations = 0;
                    return;
                }
                event.feedback = 24;
                if (event.item == null) {
                    return;
                }
                boolean droppingFolders = false;
                Object o = textTransfer.nativeToJava(event.currentDataType);
                String xml = (String)o;
                if (xml != null) {
                    GrepExpressionRootFolder dropRoot = this.getDropRoot(xml);
                    for (AbstractGrepModelElement element : dropRoot.getChildren()) {
                        if (!(element instanceof GrepExpressionFolder)) continue;
                        droppingFolders = true;
                        break;
                    }
                }
                TreeItem item = (TreeItem)event.item;
                Point pt = tree.getDisplay().map(null, (Control)tree, event.x, event.y);
                Rectangle bounds = item.getBounds();
                boolean isFolder = item.getData() instanceof GrepExpressionFolder;
                event.feedback = pt.y < bounds.y + (isFolder ? bounds.height / 3 : bounds.height / 2) ? (event.feedback |= 2) : (!isFolder || pt.y > bounds.y + 2 * bounds.height / 3 ? (event.feedback |= 4) : (droppingFolders ? 0 : (event.feedback |= 1)));
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragEnter(DropTargetEvent event) {
            }
        });
    }

    public void setExpressions(GrepExpressionsWithSelection expressions) {
        this.treePanel.setExpressions(expressions);
        this.refreshLineStyleListener();
        this.resizeColumns();
    }

    public void resizeColumns() {
        this.treePanel.resizeColumns();
    }

    private void refreshLineStyleListener() {
        LinkedList<GrepExpressionItem> items = new LinkedList<GrepExpressionItem>();
        GrepExpressionsWithSelection expressions = this.getExpressions();
        GrepExpressionRootFolder root = expressions.getRootFolder();
        this.addAllEnabledItems(items, root, expressions.getEnablementMap());
        this.grepLineStyleListener.setItems(items);
        this.stPreview.redraw();
    }

    private void addAllEnabledItems(LinkedList<GrepExpressionItem> items, AbstractGrepModelElement element, Map<String, Boolean> enablementMap) {
        Boolean enablement;
        Boolean bl = enablement = enablementMap == null ? null : enablementMap.get(element.getId());
        if (enablement == null) {
            enablement = element.isDefaultEnabled();
        }
        if (!(element instanceof GrepExpressionRootFolder) && !enablement.booleanValue()) {
            return;
        }
        if (element instanceof GrepExpressionItem) {
            items.add((GrepExpressionItem)element);
        } else if (element instanceof GrepExpressionFolder) {
            for (AbstractGrepModelElement child : ((GrepExpressionFolder)element).getChildren()) {
                this.addAllEnabledItems(items, child, enablementMap);
            }
        }
    }

    public GrepExpressionsWithSelection getExpressions() {
        return this.treePanel.getExpressions();
    }

    private void doAddFolder() {
        GrepExpressionFolder folder = new GrepExpressionFolder();
        if (this.editFolder(folder, true)) {
            this.getRootFolder().add(folder);
            this.treePanel.refresh();
        }
    }

    private GrepExpressionFolder getRootFolder() {
        return this.getExpressions().getRootFolder();
    }

    private void doAddExpression(String text) {
        GrepExpressionItem item = new GrepExpressionItem();
        GrepExpressionFolder folder = this.treePanel.getSelectedFolder();
        folder.add(item);
        if (text != null) {
            item.setGrepExpression("(" + Pattern.quote(text) + ")");
        }
        if (this.editExpression(item, true)) {
            this.treePanel.refresh();
            this.refreshLineStyleListener();
        } else {
            folder.remove(item);
        }
    }

    private void doEdit() {
        AbstractGrepModelElement element = this.treePanel.getSelectedElement();
        boolean refresh = element instanceof GrepExpressionFolder ? this.editFolder((GrepExpressionFolder)element, false) : this.editExpression((GrepExpressionItem)element, false);
        if (refresh) {
            this.treePanel.refresh();
            this.refreshLineStyleListener();
        }
    }

    public boolean editFolder(GrepExpressionFolder folder, boolean add) {
        FolderDialog dlg = new FolderDialog(this.getShell(), folder, add);
        return dlg.open() == 0;
    }

    public boolean editExpression(GrepExpressionItem item, boolean add) {
        ExpressionDialog dlg = new ExpressionDialog(this.getShell(), add);
        dlg.setPreviewText(this.stPreview.getText());
        dlg.setItem(item);
        return dlg.open() == 0;
    }

    private void doRemove() {
        Set<AbstractGrepModelElement> elements = this.treePanel.getSelectedElements();
        if (elements == null) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.EditableItemsPanel_delete_items, (String)Messages.EditableItemsPanel_really_delete_items)) {
            return;
        }
        HashSet<AbstractGrepModelElement> deleted = new HashSet<AbstractGrepModelElement>();
        for (AbstractGrepModelElement element : elements) {
            GrepExpressionFolder parent = element.getParent();
            if (deleted.contains(parent)) continue;
            parent.remove(element);
            deleted.add(element);
        }
        this.treePanel.refresh();
    }

    protected void doSave(boolean all) {
        block13: {
            String xml = this.buildXml(all, null, true);
            FileDialog dlg = new FileDialog(this.getShell(), 8192);
            String fileName = dlg.open();
            if (fileName != null) {
                File file = new File(fileName);
                BufferedWriter writer = null;
                try {
                    try {
                        writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8")));
                        writer.write(xml);
                    }
                    catch (IOException ex) {
                        Activator.getDefault().log(4, Messages.Error_could_not_save_settings, ex);
                        if (writer == null) break block13;
                        try {
                            writer.close();
                        }
                        catch (IOException ex2) {
                            Activator.getDefault().log(2, ex2);
                        }
                    }
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException ex) {
                            Activator.getDefault().log(2, ex);
                        }
                    }
                }
            }
        }
    }

    private String buildXml(boolean all, LinkedList<AbstractGrepModelElement> cutElements, boolean identityCopy) {
        GrepExpressionRootFolder copyRoot;
        if (all) {
            copyRoot = this.getExpressions().getRootFolder();
            LinkedHashSet<AbstractGrepModelElement> allElements = new LinkedHashSet<AbstractGrepModelElement>();
            allElements.addAll(copyRoot.getChildren());
        } else {
            Set<AbstractGrepModelElement> allElements = this.treePanel.getSelectedElements();
            copyRoot = new GrepExpressionRootFolder();
            for (AbstractGrepModelElement element : allElements) {
                GrepExpressionFolder parent = element.getParent();
                boolean skip = false;
                while (parent != null) {
                    if (allElements.contains(parent)) {
                        skip = true;
                        break;
                    }
                    parent = parent.getParent();
                }
                if (skip) continue;
                AbstractGrepModelElement newElement = element.copy(identityCopy);
                copyRoot.add(newElement);
                if (cutElements == null) continue;
                cutElements.add(element);
            }
        }
        XmlHandler handler = new XmlHandler();
        handler.recalculateStyleSet(copyRoot);
        try {
            return handler.createXmlString(copyRoot);
        }
        catch (ParserConfigurationException ex) {
            Activator.getDefault().log(4, ex);
        }
        catch (TransformerException ex) {
            Activator.getDefault().log(4, ex);
        }
        return null;
    }

    private void doCopy(boolean cut) {
        LinkedList<AbstractGrepModelElement> cutElements = cut ? new LinkedList<AbstractGrepModelElement>() : null;
        String xml = this.buildXml(false, cutElements, cut);
        TextTransfer textTransfer = TextTransfer.getInstance();
        this.clipboard.setContents(new Object[]{xml}, new Transfer[]{textTransfer});
        if (cut) {
            for (AbstractGrepModelElement element : cutElements) {
                element.getParent().remove(element);
            }
            this.treePanel.refresh();
        }
    }

    protected void doLoad() {
        StringBuilder sb;
        block17: {
            FileDialog dlg = new FileDialog(this.getShell(), 4096);
            String fileName = dlg.open();
            if (fileName == null) {
                return;
            }
            File file = new File(fileName);
            BufferedReader reader = null;
            sb = new StringBuilder();
            try {
                try {
                    String s;
                    reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                    while ((s = reader.readLine()) != null) {
                        if (sb.length() > 0) {
                            sb.append("\n");
                        }
                        sb.append(s);
                    }
                }
                catch (IOException ex) {
                    Activator.getDefault().log(4, Messages.Error_could_not_load_settings, ex);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ex2) {
                            Activator.getDefault().log(2, ex2);
                        }
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        Activator.getDefault().log(2, ex);
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    Activator.getDefault().log(2, ex);
                }
            }
        }
        String xml = sb.toString();
        this.paste(this.getExpressions().getRootFolder(), xml);
    }

    private void doPaste() {
        TextTransfer transfer = TextTransfer.getInstance();
        this.paste(this.treePanel.getSelectedElement(), (String)this.clipboard.getContents((Transfer)transfer));
    }

    private void paste(AbstractGrepModelElement selectedElement, String xml) {
        GrepExpressionRootFolder copyRoot;
        GrepExpressionFolder parent = selectedElement == null ? this.treePanel.getExpressions().getRootFolder() : (selectedElement instanceof GrepExpressionFolder ? (GrepExpressionFolder)selectedElement : selectedElement.getParent());
        GrepExpressionFolder root = parent.getParent() == null ? parent : parent.getParent();
        XmlHandler handler = new XmlHandler();
        try {
            copyRoot = handler.readExpressions(xml);
        }
        catch (XmlHandlerException ex) {
            Activator.getDefault().log(4, Messages.EditableItemsPanel_paste_failed, ex);
            return;
        }
        copyRoot.rewriteDuplicateIds(root.getAllIds(new HashSet<String>()));
        GrepExpressionFolder newFolder = null;
        for (AbstractGrepModelElement element : copyRoot.getChildren()) {
            boolean isItem = element instanceof GrepExpressionItem;
            if (isItem) {
                if (parent == root) {
                    if (newFolder == null) {
                        newFolder = new GrepExpressionFolder();
                        newFolder.setName(Messages.EditableItemsPanel_new_items_folder_title);
                        parent.add(newFolder);
                    }
                    newFolder.add(element.copy(true));
                    continue;
                }
                parent.add(element.copy(true));
                continue;
            }
            root.add(element.copy(true));
        }
        root.getRoot().addMissingStyles();
        this.treePanel.refresh();
    }

    @Override
    public void enabledExpressionsChanged() {
        this.refreshLineStyleListener();
    }

    public ItemsTreePanel getTreePanel() {
        return this.treePanel;
    }

    private void refreshMenuItems() {
        Set<AbstractGrepModelElement> selection = this.treePanel.getSelectedElements();
        boolean noSelection = selection == null || selection.isEmpty();
        boolean canPaste = false;
        TextTransfer transfer = TextTransfer.getInstance();
        String xml = (String)this.clipboard.getContents((Transfer)transfer);
        if (xml != null) {
            try {
                new XmlHandler().readExpressions(xml);
                canPaste = true;
            }
            catch (XmlHandlerException xmlHandlerException) {}
        }
        this.miCut.setEnabled(!noSelection);
        this.miCopy.setEnabled(!noSelection);
        this.miPaste.setEnabled(canPaste);
    }

    @Override
    public void elementDoubleClicked(AbstractGrepModelElement element) {
        this.doEdit();
    }

    @Override
    public void elementSelectionChanged(Set<AbstractGrepModelElement> elements) {
        this.refreshButtons();
    }

    private void refreshButtons() {
        Set<AbstractGrepModelElement> selection = this.treePanel.getSelectedElements();
        boolean hasSelection = selection != null && !selection.isEmpty();
        this.btnAddExpression.setEnabled(hasSelection);
        this.btnEdit.setEnabled(hasSelection);
        this.btnRemove.setEnabled(hasSelection);
        this.btnSaveSelected.setEnabled(hasSelection);
    }

    public void setPreviewText(String previewText) {
        this.previewText = previewText;
        if (this.stPreview != null && previewText != null) {
            this.stPreview.setText(previewText);
        }
    }

    public String getPreviewText() {
        return this.previewText;
    }

    @Override
    public void filterExpressionsChanged() {
    }

    @Override
    public void statisticsExpressionsChanged() {
    }

    @Override
    public void notificationsExpressionsChanged() {
    }

    public void refresh() {
        this.treePanel.refresh();
    }

    protected void updatePreviewToolTip() {
        Activator activator = Activator.getDefault();
        int styleLength = activator.getStyleMatchLength();
        int filterLength = activator.getFilterMatchLength();
        this.stPreview.setToolTipText(MessageFormat.format(LineLengthChecker.MESSAGE_PREVIEW_TOOLTIP, styleLength, filterLength));
    }

    protected void updateLengthWarning() {
        boolean warning;
        boolean bl = warning = this.lengthChecker.isStyleExceeded() || this.lengthChecker.isFilterExceeded();
        if (warning) {
            StringBuilder sb = new StringBuilder();
            if (this.lengthChecker.isStyleExceeded()) {
                sb.append(MessageFormat.format(LineLengthChecker.MESSAGE_STYLE_LENGTH_LIMIT_EXCEEDED, this.lengthChecker.getStyleMatchLength()));
            }
            if (this.lengthChecker.isFilterExceeded()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(MessageFormat.format(LineLengthChecker.MESSAGE_FILTER_LENGTH_LIMIT_EXCEEDED, this.lengthChecker.getFilterMatchLength()));
            }
            this.labelLengthWarning.setToolTipText(sb == null ? null : sb.toString());
        }
        this.labelLengthWarning.setVisible(warning);
    }
}

