/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.items;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import name.schedenig.eclipse.grepconsole.model.AbstractGrepModelElement;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionFolder;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionsWithSelection;
import name.schedenig.eclipse.grepconsole.model.InheritedFlagResolver;
import name.schedenig.eclipse.grepconsole.view.items.ItemCheckboxLabelProvider;
import name.schedenig.eclipse.grepconsole.view.items.ItemContentProvider;
import name.schedenig.eclipse.grepconsole.view.items.ItemLabelProvider;
import name.schedenig.eclipse.grepconsole.view.items.TristateEditingSupport;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class ItemsTreePanel
extends Composite {
    private LinkedHashSet<IItemTreeListener> listeners = new LinkedHashSet();
    private int treeStyle;
    private Tree tree;
    private TreeViewer viewer;
    private TreeViewerColumn colCheck;
    private TreeViewerColumn colLabel;
    private ItemCheckboxLabelProvider enablementLabelProvider;
    private TreeViewerColumn colFilter;
    private ItemCheckboxLabelProvider filterLabelProvider;
    private TreeViewerColumn colNotifications;
    private ItemCheckboxLabelProvider notificationsLabelProvider;
    private TreeViewerColumn colStatistics;
    private ItemCheckboxLabelProvider statisticsLabelProvider;

    public ItemsTreePanel(Composite parent, int style) {
        super(parent, style & 0xFFFFF7FF);
        this.treeStyle = style & 0x800;
        this.init();
    }

    private void init() {
        this.setLayout((Layout)new FillLayout());
        this.tree = new Tree((Composite)this, 0x10302 | this.treeStyle);
        this.tree.setLinesVisible(false);
        this.viewer = new TreeViewer(this.tree);
        this.viewer.setContentProvider((IContentProvider)new ItemContentProvider());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!(event.getSelection() instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                AbstractGrepModelElement element = (AbstractGrepModelElement)selection.getFirstElement();
                for (IItemTreeListener listener : ItemsTreePanel.this.listeners) {
                    listener.elementDoubleClicked(element);
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Set<AbstractGrepModelElement> elements = ItemsTreePanel.this.getSelectedElements();
                for (IItemTreeListener listener : ItemsTreePanel.this.listeners) {
                    listener.elementSelectionChanged(elements);
                }
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.colLabel = new TreeViewerColumn(this.viewer, 0);
        this.colLabel.setLabelProvider((CellLabelProvider)new ItemLabelProvider());
        this.colCheck = new TreeViewerColumn(this.viewer, 131072);
        this.enablementLabelProvider = new ItemCheckboxLabelProvider(){

            @Override
            public InheritedFlagResolver getFlagResolver() {
                return InheritedFlagResolver.ENABLED_RESOLVER;
            }

            @Override
            protected Map<String, Boolean> getInheritanceMap() {
                return ItemsTreePanel.this.getExpressions().getEnablementMap();
            }

            @Override
            public String getImageKey(boolean checked, boolean inherited, boolean greyed) {
                if (inherited) {
                    if (greyed) {
                        return checked ? "checkbox_on_inherited_greyed" : "checkbox_off_inherited_greyed";
                    }
                    return checked ? "checkbox_on_inherited" : "checkbox_off_inherited";
                }
                if (greyed) {
                    return checked ? "checkbox_on_greyed" : "checkbox_off";
                }
                return checked ? "checkbox_on" : "checkbox_off";
            }
        };
        this.colCheck.setLabelProvider((CellLabelProvider)this.enablementLabelProvider);
        this.colFilter = new TreeViewerColumn(this.viewer, 131072);
        this.filterLabelProvider = new ItemCheckboxLabelProvider(){

            @Override
            public InheritedFlagResolver getFlagResolver() {
                return InheritedFlagResolver.FILTER_RESOLVER;
            }

            @Override
            protected Map<String, Boolean> getInheritanceMap() {
                return ItemsTreePanel.this.getExpressions().getFilterMap();
            }

            @Override
            public String getImageKey(boolean checked, boolean inherited, boolean greyed) {
                if (inherited) {
                    if (greyed) {
                        return checked ? "filter_on_inherited_greyed" : "filter_off_inherited_greyed";
                    }
                    return checked ? "filter_on_inherited" : "filter_off_inherited";
                }
                if (greyed) {
                    return checked ? "filter_on_greyed" : "filter_off_greyed";
                }
                return checked ? "filter_on" : "filter_off";
            }
        };
        this.colFilter.setLabelProvider((CellLabelProvider)this.filterLabelProvider);
        this.colStatistics = new TreeViewerColumn(this.viewer, 131072);
        this.statisticsLabelProvider = new ItemCheckboxLabelProvider(){

            @Override
            public InheritedFlagResolver getFlagResolver() {
                return InheritedFlagResolver.STATISTICS_RESOLVER;
            }

            @Override
            protected Map<String, Boolean> getInheritanceMap() {
                return ItemsTreePanel.this.getExpressions().getStatisticsMap();
            }

            @Override
            public String getImageKey(boolean checked, boolean inherited, boolean greyed) {
                if (inherited) {
                    if (greyed) {
                        return checked ? "statistics_on_inherited_greyed" : "statistics_off_inherited_greyed";
                    }
                    return checked ? "statistics_on_inherited" : "statistics_off_inherited";
                }
                if (greyed) {
                    return checked ? "statistics_on_greyed" : "statistics_off_greyed";
                }
                return checked ? "statistics_on" : "statistics_off";
            }
        };
        this.colStatistics.setLabelProvider((CellLabelProvider)this.statisticsLabelProvider);
        this.colNotifications = new TreeViewerColumn(this.viewer, 131072);
        this.notificationsLabelProvider = new ItemCheckboxLabelProvider(){

            @Override
            public InheritedFlagResolver getFlagResolver() {
                return InheritedFlagResolver.NOTIFICATIONS_RESOLVER;
            }

            @Override
            protected Map<String, Boolean> getInheritanceMap() {
                return ItemsTreePanel.this.getExpressions().getNotificationsMap();
            }

            @Override
            public String getImageKey(boolean checked, boolean inherited, boolean greyed) {
                if (inherited) {
                    if (greyed) {
                        return checked ? "notification_on_inherited_greyed" : "notification_off_inherited_greyed";
                    }
                    return checked ? "notification_on_inherited" : "notification_off_inherited";
                }
                if (greyed) {
                    return checked ? "notification_on_greyed" : "notification_off_greyed";
                }
                return checked ? "notification_on" : "notification_off";
            }
        };
        this.colNotifications.setLabelProvider((CellLabelProvider)this.notificationsLabelProvider);
        this.tree.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ItemsTreePanel.this.resizeColumns();
            }
        });
        this.colCheck.setEditingSupport((EditingSupport)new TristateEditingSupport((ColumnViewer)this.viewer){

            @Override
            protected void toggleElementValue(AbstractGrepModelElement element) {
                element.setDefaultEnabled(!element.isDefaultEnabled());
            }

            @Override
            protected Map<String, Boolean> getInheritanceMap() {
                return ItemsTreePanel.this.getExpressions().getEnablementMap();
            }

            @Override
            protected boolean getElementValue(AbstractGrepModelElement element) {
                return element.isDefaultEnabled();
            }

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(element, value);
                ItemsTreePanel.this.fireEnabledExpressionsChanged();
            }
        });
        this.colFilter.setEditingSupport((EditingSupport)new TristateEditingSupport((ColumnViewer)this.viewer){

            @Override
            protected void toggleElementValue(AbstractGrepModelElement element) {
                element.setDefaultFilter(!element.isDefaultFilter());
            }

            @Override
            protected Map<String, Boolean> getInheritanceMap() {
                return ItemsTreePanel.this.getExpressions().getFilterMap();
            }

            @Override
            protected boolean getElementValue(AbstractGrepModelElement element) {
                return element.isDefaultFilter();
            }

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(element, value);
                ItemsTreePanel.this.fireFilterExpressionsChanged();
            }
        });
        this.colStatistics.setEditingSupport((EditingSupport)new TristateEditingSupport((ColumnViewer)this.viewer){

            @Override
            protected void toggleElementValue(AbstractGrepModelElement element) {
                element.setDefaultStatistics(!element.isDefaultStatistics());
            }

            @Override
            protected Map<String, Boolean> getInheritanceMap() {
                return ItemsTreePanel.this.getExpressions().getStatisticsMap();
            }

            @Override
            protected boolean getElementValue(AbstractGrepModelElement element) {
                return element.isDefaultStatistics();
            }

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(element, value);
                ItemsTreePanel.this.fireStatisticsExpressionsChanged();
            }
        });
        this.colNotifications.setEditingSupport((EditingSupport)new TristateEditingSupport((ColumnViewer)this.viewer){

            @Override
            protected void toggleElementValue(AbstractGrepModelElement element) {
                element.setDefaultNotifications(!element.isDefaultNotifications());
            }

            @Override
            protected Map<String, Boolean> getInheritanceMap() {
                return ItemsTreePanel.this.getExpressions().getNotificationsMap();
            }

            @Override
            protected boolean getElementValue(AbstractGrepModelElement element) {
                return element.isDefaultNotifications();
            }

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(element, value);
                ItemsTreePanel.this.fireNotificationsExpressionsChanged();
            }
        });
    }

    public synchronized void resizeColumns() {
        if (this.colCheck.getColumn() == null) {
            return;
        }
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ItemsTreePanel.this.tree.isDisposed()) {
                    return;
                }
                int availableWidth = ((ItemsTreePanel)ItemsTreePanel.this).tree.getClientArea().width - 2 * ItemsTreePanel.this.tree.getBorderWidth();
                ItemsTreePanel.this.colCheck.getColumn().pack();
                ItemsTreePanel.this.colFilter.getColumn().pack();
                ItemsTreePanel.this.colStatistics.getColumn().pack();
                ItemsTreePanel.this.colNotifications.getColumn().pack();
                ItemsTreePanel.this.colLabel.getColumn().setWidth(availableWidth - ItemsTreePanel.this.colCheck.getColumn().getWidth() - ItemsTreePanel.this.colFilter.getColumn().getWidth() - ItemsTreePanel.this.colStatistics.getColumn().getWidth() - ItemsTreePanel.this.colNotifications.getColumn().getWidth());
            }
        });
    }

    public void setExpressions(GrepExpressionsWithSelection expressions) {
        this.colCheck.getColumn().setWidth(0);
        this.colFilter.getColumn().setWidth(0);
        this.colStatistics.getColumn().setWidth(0);
        this.colNotifications.getColumn().setWidth(0);
        this.viewer.setInput((Object)expressions);
        this.viewer.expandAll();
        this.resizeColumns();
    }

    public GrepExpressionsWithSelection getExpressions() {
        return (GrepExpressionsWithSelection)this.viewer.getInput();
    }

    public GrepExpressionFolder getRootFolder() {
        return this.getExpressions().getRootFolder();
    }

    public AbstractGrepModelElement getSelectedElement() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (AbstractGrepModelElement)selection.getFirstElement();
    }

    public Set<AbstractGrepModelElement> getSelectedElements() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        LinkedHashSet<AbstractGrepModelElement> elements = new LinkedHashSet<AbstractGrepModelElement>(selection.toList());
        return elements;
    }

    public GrepExpressionFolder getSelectedFolder() {
        AbstractGrepModelElement element = this.getSelectedElement();
        return element instanceof GrepExpressionFolder ? (GrepExpressionFolder)element : element.getParent();
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public void refresh(AbstractGrepModelElement element) {
        this.viewer.refresh((Object)element);
    }

    public void addListener(IItemTreeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IItemTreeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireEnabledExpressionsChanged() {
        for (IItemTreeListener listener : this.listeners) {
            listener.enabledExpressionsChanged();
        }
    }

    private void fireFilterExpressionsChanged() {
        for (IItemTreeListener listener : this.listeners) {
            listener.filterExpressionsChanged();
        }
    }

    private void fireStatisticsExpressionsChanged() {
        for (IItemTreeListener listener : this.listeners) {
            listener.statisticsExpressionsChanged();
        }
    }

    private void fireNotificationsExpressionsChanged() {
        for (IItemTreeListener listener : this.listeners) {
            listener.notificationsExpressionsChanged();
        }
    }

    public Tree getTree() {
        return this.tree;
    }

    public static interface IItemTreeListener {
        public void enabledExpressionsChanged();

        public void filterExpressionsChanged();

        public void statisticsExpressionsChanged();

        public void notificationsExpressionsChanged();

        public void elementSelectionChanged(Set<AbstractGrepModelElement> var1);

        public void elementDoubleClicked(AbstractGrepModelElement var1);
    }
}

