/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.items;

import java.util.LinkedHashSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.links.IGrepLink;
import name.schedenig.eclipse.grepconsole.model.xml.XmlHandler;
import name.schedenig.eclipse.grepconsole.model.xml.XmlHandlerException;
import name.schedenig.eclipse.grepconsole.view.items.StyleAssignmentsLinkLabelProvider;
import name.schedenig.eclipse.grepconsole.view.items.links.LinkDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class LinkPickerLine {
    private LinkedHashSet<ILinkChangeListener> listeners = new LinkedHashSet();
    private IGrepLink link;
    private Label label;
    private Text text;
    private Menu menu;
    private MenuItem miCopy;
    private MenuItem miPaste;
    private Clipboard clipboard;

    public LinkPickerLine(Composite parent) {
        this.init(parent);
    }

    private void init(final Composite parent) {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LinkPickerLine.this.dispose();
            }
        });
        this.clipboard = new Clipboard(parent.getDisplay());
        this.label = new Label(parent, 0);
        this.label.setText("");
        this.label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.text = new Text(parent, 2056);
        this.text.setText("");
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Button btnNotificationLink = new Button(parent, 8);
        btnNotificationLink.setText(Messages.LinkPickerLine_edit);
        btnNotificationLink.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        btnNotificationLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LinkDialog dlg = new LinkDialog(parent.getShell(), false);
                dlg.setLink(LinkPickerLine.this.link);
                if (dlg.open() == 0) {
                    LinkPickerLine.this.link = dlg.getLink();
                    LinkPickerLine.this.refreshLinkText();
                    LinkPickerLine.this.fireLinkChanged(LinkPickerLine.this.link);
                }
            }
        });
        this.menu = new Menu((Control)this.text);
        this.miCopy = new MenuItem(this.menu, 8);
        this.miCopy.setText(Messages.ExpressionDialog_copy_link);
        this.miCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LinkPickerLine.this.copyLink(LinkPickerLine.this.link);
            }
        });
        this.miPaste = new MenuItem(this.menu, 8);
        this.miPaste.setText(Messages.ExpressionDialog_paste_link);
        this.miPaste.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IGrepLink newLink = LinkPickerLine.this.getLinkFromClipboard();
                if (newLink != null) {
                    LinkPickerLine.this.link = newLink;
                    LinkPickerLine.this.refreshLinkText();
                    LinkPickerLine.this.fireLinkChanged(LinkPickerLine.this.link);
                }
            }
        });
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                LinkPickerLine.this.miCopy.setEnabled(LinkPickerLine.this.link != null);
            }
        });
        this.text.setMenu(this.menu);
    }

    protected void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
    }

    protected void copyLink(IGrepLink link) {
        XmlHandler xmlHandler = new XmlHandler();
        try {
            String xml = xmlHandler.createLinkXmlString(link);
            TextTransfer textTransfer = TextTransfer.getInstance();
            this.clipboard.setContents(new Object[]{xml}, new Transfer[]{textTransfer});
        }
        catch (ParserConfigurationException ex) {
            Activator.getDefault().log(4, "Could not copy link to clipboard.", ex);
        }
        catch (TransformerException ex) {
            Activator.getDefault().log(4, "Could not copy link to clipboard.", ex);
        }
    }

    private IGrepLink getLinkFromClipboard() {
        TextTransfer transfer = TextTransfer.getInstance();
        String xml = (String)this.clipboard.getContents((Transfer)transfer);
        XmlHandler handler = new XmlHandler();
        try {
            return handler.readLink(xml);
        }
        catch (XmlHandlerException ex) {
            Activator.getDefault().log(4, Messages.EditableItemsPanel_paste_failed, ex);
            return null;
        }
    }

    private void refreshLinkText() {
        this.text.setText(StyleAssignmentsLinkLabelProvider.getLinkDisplayText(this.link, true));
    }

    private void fireLinkChanged(IGrepLink link) {
        for (ILinkChangeListener listener : this.listeners) {
            listener.linkChanged(this, link);
        }
    }

    public void addListener(ILinkChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ILinkChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public String getText() {
        return this.label.getText();
    }

    public IGrepLink getLink() {
        return this.link;
    }

    public void setLink(IGrepLink link) {
        this.link = link;
        this.refreshLinkText();
    }

    public static interface ILinkChangeListener {
        public void linkChanged(LinkPickerLine var1, IGrepLink var2);
    }
}

