/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.items;

import java.text.MessageFormat;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.GrepGroup;
import name.schedenig.eclipse.grepconsole.model.links.CommandLink;
import name.schedenig.eclipse.grepconsole.model.links.FileLink;
import name.schedenig.eclipse.grepconsole.model.links.IGrepLink;
import name.schedenig.eclipse.grepconsole.model.links.JavaLink;
import name.schedenig.eclipse.grepconsole.model.links.ScriptLink;
import name.schedenig.eclipse.grepconsole.model.links.UrlLink;
import name.schedenig.eclipse.grepconsole.view.items.links.LinkDialog;
import name.schedenig.eclipse.grepconsole.view.styles.StyleLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.graphics.Image;

public class StyleAssignmentsLinkLabelProvider
extends StyleLabelProvider {
    public StyleAssignmentsLinkLabelProvider(ColumnViewer viewer) {
        super(viewer);
    }

    @Override
    public String getText(Object element) {
        IGrepLink link = this.getLink(element);
        String s = StyleAssignmentsLinkLabelProvider.getLinkDisplayText(link, false);
        if (s == null) {
            return link == null ? "" : link.toString();
        }
        return s;
    }

    public static String getLinkDisplayText(IGrepLink link, boolean detailed) {
        String linkName = LinkDialog.TYPE_NAMES.get(link == null ? LinkDialog.NoLink.class : link.getClass());
        String detail = detailed ? StyleAssignmentsLinkLabelProvider.getLinkDetail(link) : null;
        return detail == null ? linkName : MessageFormat.format(Messages.StyleAssignmentsLinkLabelProvider_linkname_detail, linkName, detail);
    }

    private static String getLinkDetail(IGrepLink link) {
        if (link == null) {
            return null;
        }
        if (link instanceof CommandLink) {
            return ((CommandLink)link).getCommandPattern();
        }
        if (link instanceof FileLink) {
            return ((FileLink)link).getFilePattern();
        }
        if (link instanceof JavaLink) {
            return ((JavaLink)link).getTypePattern();
        }
        if (link instanceof ScriptLink) {
            return ((ScriptLink)link).getLanguage();
        }
        if (link instanceof UrlLink) {
            return ((UrlLink)link).getUrlPattern();
        }
        return null;
    }

    @Override
    public Image getImage(Object element) {
        return null;
    }

    private IGrepLink getLink(Object element) {
        Integer index = (Integer)element;
        GrepGroup[] groups = (GrepGroup[])this.getViewer().getInput();
        return groups[index] == null ? null : groups[index].getLink();
    }
}

