/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.actions;

import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.actions.AddExpressionToFolderAction;
import name.schedenig.eclipse.grepconsole.adapters.GrepPageParticipant;
import name.schedenig.eclipse.grepconsole.model.AbstractGrepModelElement;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionFolder;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;

public class AddExpressionAction
implements IViewActionDelegate,
IMenuCreator,
Activator.IGrepConsoleListener {
    private IConsoleView view;
    private String selected;
    private Menu menu;

    public void init(IViewPart view) {
        this.view = (IConsoleView)view;
        Activator.getDefault().addListener(this);
    }

    public void dispose() {
        Activator.getDefault().removeListener(this);
        this.disposeMenu();
    }

    private void disposeMenu() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        ITextSelection ts;
        if (action.getMenuCreator() != this) {
            action.setMenuCreator((IMenuCreator)this);
        }
        this.selected = null;
        if (selection instanceof ITextSelection && (ts = (ITextSelection)selection).getStartLine() == ts.getEndLine() && ts.getText() != null && ts.getText().length() > 0) {
            this.selected = ts.getText();
        }
        action.setEnabled(this.selected != null);
        if (this.menu != null) {
            this.updateMenu();
        }
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        this.disposeMenu();
        this.menu = new Menu(parent);
        this.updateMenu();
        return this.menu;
    }

    private void updateMenu() {
        MenuItem[] menuItemArray = this.menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            item.dispose();
            ++n2;
        }
        Activator plugin = Activator.getDefault();
        Shell shell = this.view.getViewSite().getShell();
        GrepPageParticipant participant = this.getActiveParticipant();
        for (AbstractGrepModelElement group : plugin.getExpressions().getChildren()) {
            GrepConsoleUtil.addActionToMenu(this.menu, (IAction)new AddExpressionToFolderAction(shell, participant, (GrepExpressionFolder)group, this.selected));
        }
        ActionContributionItem aci = new ActionContributionItem((IAction)new AddExpressionToFolderAction(shell, participant, null, this.selected));
        aci.fill(this.menu, -1);
    }

    private GrepPageParticipant getActiveParticipant() {
        IConsole console = this.view.getConsole();
        return console == null ? null : Activator.getDefault().getParticipant(console);
    }

    @Override
    public void participantAdded(GrepPageParticipant participant) {
    }

    @Override
    public void participantRemoved(GrepPageParticipant participant) {
    }

    @Override
    public void participantActivated(GrepPageParticipant participant) {
    }

    @Override
    public void settingsChanged() {
        if (this.menu != null) {
            this.updateMenu();
        }
    }
}

