/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.adapters.links;

import java.util.LinkedList;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.adapters.GrepLineStyleListener;
import name.schedenig.eclipse.grepconsole.adapters.GrepStyleRange;
import name.schedenig.eclipse.grepconsole.adapters.TextFilter;
import name.schedenig.eclipse.grepconsole.adapters.links.GrepLinkAdapter;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class LinkListener
implements KeyListener,
MouseListener,
MouseMoveListener,
MouseTrackListener,
IPropertyChangeListener {
    private StyledText styledText;
    private GrepLineStyleListener lineStyleListener;
    private int lastX;
    private int lastY;
    private boolean mouseInside;
    private int modifier;

    public LinkListener(StyledText styledText, GrepLineStyleListener lineStyleListener) {
        this.styledText = styledText;
        this.lineStyleListener = lineStyleListener;
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.init();
    }

    public void dispose() {
        ScopedPreferenceStore debugUiPrefs = GrepConsoleUtil.getDebugUiPreferences();
        if (debugUiPrefs != null) {
            debugUiPrefs.removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    private void init() {
        this.modifier = Activator.getDefault().getLinkModifierKey();
    }

    public void setLineStyleListener(GrepLineStyleListener lineStyleListener) {
        this.lineStyleListener = lineStyleListener;
    }

    public GrepLineStyleListener getLineStyleListener() {
        return this.lineStyleListener;
    }

    public void attach() {
        this.styledText.addKeyListener((KeyListener)this);
        this.styledText.addMouseListener((MouseListener)this);
        this.styledText.addMouseMoveListener((MouseMoveListener)this);
        this.styledText.addMouseTrackListener((MouseTrackListener)this);
        this.styledText.getShell().getDisplay().addFilter(1, new Listener(){

            public void handleEvent(Event event) {
                if (LinkListener.this.mouseInside && !LinkListener.this.styledText.isDisposed() && event.keyCode == LinkListener.this.modifier) {
                    LinkListener.this.updateLinkCursor();
                }
            }
        });
        this.styledText.getShell().getDisplay().addFilter(2, new Listener(){

            public void handleEvent(Event event) {
                if (!LinkListener.this.styledText.isDisposed() && event.keyCode == LinkListener.this.modifier) {
                    LinkListener.this.styledText.setCursor(null);
                    LinkListener.this.styledText.setToolTipText(null);
                }
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private StyleRange getStyleAt(int x, int y) {
        try {
            TextFilter textFilter;
            TextFilter.Line line;
            int offset = this.styledText.getOffsetAtLocation(new Point(x, y));
            int lineIndex = this.styledText.getLineAtOffset(offset);
            int lineOffset = this.styledText.getOffsetAtLine(lineIndex);
            if (this.styledText.getContent() instanceof TextFilter && (line = (textFilter = (TextFilter)this.styledText.getContent()).getLineElement(lineIndex)) != null && line.isRewritten()) {
                int offsetInLine = offset - lineOffset;
                GrepStyleRange[] styles = textFilter.getLineStyles(lineIndex);
                LinkedList<GrepStyleRange> foundStyles = new LinkedList<GrepStyleRange>();
                GrepStyleRange[] grepStyleRangeArray = styles;
                int n = styles.length;
                int n2 = 0;
                while (n2 < n) {
                    GrepStyleRange style = grepStyleRangeArray[n2];
                    if (style.getFirstIndex() > offsetInLine) break;
                    if (style.getLastIndex() >= offsetInLine) {
                        foundStyles.add(style);
                    }
                    ++n2;
                }
                if (foundStyles.isEmpty()) {
                    return null;
                }
                StyleRange styleRange = new StyleRange();
                this.lineStyleListener.collapseStyles(foundStyles, styleRange);
                return styleRange;
            }
            String lineText = this.styledText.getLine(lineIndex);
            return this.lineStyleListener.lineGetStyleAt(lineOffset, lineText, offset, false, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public void mouseMove(MouseEvent e) {
        this.lastX = e.x;
        this.lastY = e.y;
        if (this.styledText.isDisposed() || this.lineStyleListener == null) {
            return;
        }
        if ((e.stateMask & this.modifier) == 0) {
            return;
        }
        this.updateLinkCursor();
    }

    public void updateLinkCursor() {
        StyleRange style = this.getStyleAt(this.lastX, this.lastY);
        if (style != null && style.data instanceof GrepLinkAdapter) {
            this.styledText.setCursor(Activator.getDefault().getLinkCursor());
            this.styledText.setToolTipText(((GrepLinkAdapter)style.data).getToolTipText());
        } else {
            this.styledText.setCursor(null);
            this.styledText.setToolTipText(null);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (this.styledText.isDisposed() || this.lineStyleListener == null) {
            return;
        }
        if ((e.stateMask & this.modifier) == 0) {
            return;
        }
        StyleRange style = this.getStyleAt(e.x, e.y);
        if (style != null && style.data instanceof GrepLinkAdapter) {
            GrepLinkAdapter link = (GrepLinkAdapter)style.data;
            link.openLink();
        }
    }

    public void mouseUp(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == this.modifier) {
            this.updateLinkCursor();
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.keyCode == this.modifier) {
            this.styledText.setCursor(null);
            this.styledText.setToolTipText(null);
        }
    }

    public void mouseEnter(MouseEvent e) {
        this.mouseInside = true;
    }

    public void mouseExit(MouseEvent e) {
        this.mouseInside = false;
        this.styledText.setCursor(null);
        this.styledText.setToolTipText(null);
    }

    public void mouseHover(MouseEvent e) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getProperty();
        if ("linkModifierKey".equals(prop)) {
            this.init();
        }
    }
}

