/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.colors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

public class OwnerColorRegistry {
    private Device device;
    private Map<RGB, Color> colors = new HashMap<RGB, Color>();
    private Map<Object, Set<RGB>> rgbByOwner = new HashMap<Object, Set<RGB>>();
    private Map<RGB, Set<Object>> ownersByRgb = new HashMap<RGB, Set<Object>>();

    public OwnerColorRegistry(Device device) {
        this.device = device;
    }

    public synchronized void disposeColors() {
        for (Color color : this.colors.values()) {
            color.dispose();
        }
        this.colors.clear();
        this.rgbByOwner.clear();
        this.ownersByRgb.clear();
    }

    public synchronized void disposeColors(Object owner) {
        Set<RGB> owned = this.rgbByOwner.get(owner);
        if (owned == null) {
            return;
        }
        for (RGB rgb : owned) {
            Set<Object> owners = this.ownersByRgb.get(rgb);
            owners.remove(owner);
            if (!owners.isEmpty()) continue;
            this.ownersByRgb.remove(rgb);
            Color color = this.colors.remove(rgb);
            color.dispose();
        }
        this.rgbByOwner.remove(owner);
    }

    public synchronized Color get(Object owner, RGB rgb) {
        Set<RGB> owned;
        if (rgb == null) {
            return null;
        }
        Color color = this.colors.get(rgb);
        if (color == null) {
            color = new Color(this.device, rgb);
            this.colors.put(rgb, color);
        }
        if ((owned = this.rgbByOwner.get(owner)) == null) {
            owned = new HashSet<RGB>();
            this.rgbByOwner.put(owner, owned);
        }
        owned.add(rgb);
        Set<Object> owners = this.ownersByRgb.get(rgb);
        if (owners == null) {
            owners = new HashSet<Object>();
            this.ownersByRgb.put(rgb, owners);
        }
        owners.add(owner);
        return color;
    }
}

