/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.grepstatistics;

import java.util.LinkedHashMap;
import java.util.Map;
import name.schedenig.eclipse.grepconsole.adapters.GrepPageParticipant;
import name.schedenig.eclipse.grepconsole.adapters.IStatisticsListener;
import name.schedenig.eclipse.grepconsole.adapters.StatisticsEntry;
import name.schedenig.eclipse.grepconsole.adapters.TextFilter;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.view.common.GrepConsoleView;
import name.schedenig.eclipse.grepconsole.view.grepstatistics.LabelLabelProvider;
import name.schedenig.eclipse.grepconsole.view.grepstatistics.StatisticsContentProvider;
import name.schedenig.eclipse.grepconsole.view.grepstatistics.ValueLabelProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class StatisticsView
extends GrepConsoleView
implements IStatisticsListener {
    private Table table;
    private TableViewer viewer;
    private TableViewerColumn colLabel;
    private TableViewerColumn colValue;
    private TextFilter filter;
    private Map<String, StatisticsEntry> values = new LinkedHashMap<String, StatisticsEntry>();

    @Override
    public void createPartControl(Composite parent) {
        this.table = new Table(parent, 0);
        this.table.setHeaderVisible(true);
        this.viewer = new TableViewer(this.table);
        this.colLabel = new TableViewerColumn(this.viewer, 16384);
        this.colLabel.getColumn().setText(Messages.StatisticsView_label);
        this.colLabel.getColumn().setWidth(100);
        this.colLabel.setLabelProvider((CellLabelProvider)new LabelLabelProvider());
        this.colValue = new TableViewerColumn(this.viewer, 16384);
        this.colValue.getColumn().setText(Messages.StatisticsView_value);
        this.colValue.getColumn().setWidth(100);
        this.colValue.setLabelProvider((CellLabelProvider)new ValueLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new StatisticsContentProvider());
    }

    @Override
    protected void setParticipant(GrepPageParticipant participant) {
        if (this.filter != null) {
            this.filter.removeStatisticsListener(this);
        }
        super.setParticipant(participant);
        if (participant == null) {
            this.filter = null;
        } else {
            this.filter = participant.getTextFilter();
            if (this.filter != null) {
                this.filter.addStatisticsListener(this);
                this.viewer.setInput(this.filter.getStatisticEntries());
            }
        }
    }

    @Override
    public void statisticsUpdated(TextFilter src, StatisticsEntry entry, boolean isNew) {
        StatisticsEntry oldValue;
        if (isNew && (oldValue = this.values.remove(entry.getLabel())) != null) {
            this.viewer.remove((Object)oldValue);
        }
        this.values.put(entry.getLabel(), entry);
        if (isNew) {
            this.viewer.add((Object)entry);
        } else {
            this.viewer.update((Object)entry, null);
        }
    }

    @Override
    public void statisticsRemoved(TextFilter textFilter, StatisticsEntry entry) {
        this.values.remove(entry.getLabel());
        this.viewer.remove((Object)entry);
    }
}

