/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.grepview;

import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.actions.ScrollLockAction;
import name.schedenig.eclipse.grepconsole.adapters.GrepLineStyleListener;
import name.schedenig.eclipse.grepconsole.adapters.GrepPageParticipant;
import name.schedenig.eclipse.grepconsole.adapters.TextFilter;
import name.schedenig.eclipse.grepconsole.adapters.links.LinkListener;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import name.schedenig.eclipse.grepconsole.view.colors.ColorRegistry;
import name.schedenig.eclipse.grepconsole.view.common.GrepConsoleView;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GrepView
extends GrepConsoleView
implements TextChangeListener,
IContextProvider {
    private static final String KEY_SCROLL_LOCK = "scrollLock";
    private GrepLineStyleListener lineStyleListener;
    private boolean linkedToConsole = true;
    private boolean scrollLock = false;
    private ScrollLockAction scrollLockAction;
    private StyledText text;
    private MenuItem miJumpTo;
    private int selectedLineIndex;
    private LinkListener linkAdapter;
    private ColorRegistry colorRegistry;

    @Override
    public void dispose() {
        if (this.linkAdapter != null) {
            this.linkAdapter.dispose();
            this.linkAdapter = null;
        }
        if (this.colorRegistry != null) {
            this.colorRegistry.disposeColors();
            this.colorRegistry = null;
        }
        super.dispose();
    }

    @Override
    public void init(IViewSite site) throws PartInitException {
        IToolBarManager toolbar = site.getActionBars().getToolBarManager();
        this.scrollLockAction = new ScrollLockAction(this);
        toolbar.add((IAction)this.scrollLockAction);
        super.init(site);
    }

    @Override
    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.scrollLock = this.getMementoBoolean(memento, KEY_SCROLL_LOCK, this.scrollLock);
        this.scrollLockAction.setChecked(this.scrollLock);
    }

    @Override
    public void createPartControl(Composite parent) {
        this.colorRegistry = new ColorRegistry(Activator.getDefault().getColorRegistry());
        this.text = new StyledText(parent, 776);
        this.text.setFont(JFaceResources.getTextFont());
        ScopedPreferenceStore debugUiPrefs = GrepConsoleUtil.getDebugUiPreferences();
        if (debugUiPrefs != null) {
            debugUiPrefs.addPropertyChangeListener((IPropertyChangeListener)this);
            this.refreshColors();
        }
        this.text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GrepView.this.text.getContent().removeTextChangeListener((TextChangeListener)GrepView.this);
            }
        });
        this.linkAdapter = new LinkListener(this.text, this.lineStyleListener);
        this.linkAdapter.attach();
        Menu menu = new Menu((Control)this.text);
        this.miJumpTo = new MenuItem(menu, 8);
        this.miJumpTo.setText(Messages.GrepView_jump_to);
        this.miJumpTo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int offset = GrepView.this.calculateOriginalOffset(GrepView.this.selectedLineIndex);
                if (offset < 0) {
                    return;
                }
                GrepView.this.getParticipant().getStyledText().setSelection(offset);
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int y = e.y;
                GrepView.this.selectedLineIndex = GrepView.this.text.getLineIndex(y);
            }
        });
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                int offset = GrepView.this.calculateOriginalOffset(GrepView.this.selectedLineIndex);
                GrepView.this.miJumpTo.setEnabled(offset >= 0);
            }
        });
        this.text.setMenu(menu);
        this.participantActivated(Activator.getDefault().getActiveParticipant());
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getProperty();
        if ("org.eclipse.debug.ui.outColor".equals(prop) || "org.eclipse.debug.ui.consoleBackground".equals(prop) || "grepViewBackgroundColor".equals(prop) || "grepViewForegroundColor".equals(prop)) {
            this.refreshColors();
        }
    }

    private void refreshColors() {
        this.text.setForeground(this.colorRegistry.get(GrepConsoleUtil.getGrepViewTextColor()));
        this.text.setBackground(this.colorRegistry.get(GrepConsoleUtil.getGrepViewBackgroundColor()));
    }

    protected int calculateOriginalOffset(int selectedLineIndex) {
        TextFilter filter = (TextFilter)this.getContent();
        return filter.getOriginalOffsetAtLine(selectedLineIndex);
    }

    @Override
    public void setFocus() {
    }

    public StyledTextContent getContent() {
        return this.text.getContent();
    }

    public void setLineStyleListener(GrepLineStyleListener lineStyleListener) {
        if (this.lineStyleListener != null) {
            this.text.removeLineStyleListener((LineStyleListener)this.lineStyleListener);
        }
        this.lineStyleListener = lineStyleListener;
        if (lineStyleListener != null) {
            this.text.addLineStyleListener((LineStyleListener)lineStyleListener);
        }
        this.linkAdapter.setLineStyleListener(lineStyleListener);
        this.text.redraw();
    }

    private void setContent(StyledTextContent content) {
        this.text.getContent().removeTextChangeListener((TextChangeListener)this);
        if (content == null) {
            this.text.setVisible(false);
        } else {
            this.text.setVisible(true);
            this.text.setContent(content);
            content.addTextChangeListener((TextChangeListener)this);
        }
    }

    @Override
    protected void setParticipant(GrepPageParticipant participant) {
        if (participant != null) {
            participant.removeListener(this);
        }
        super.setParticipant(participant);
        if (participant == null) {
            this.setContent(null);
            this.setLineStyleListener(null);
        } else {
            participant.addListener(this);
            this.resetTextFilter();
        }
    }

    protected void resetTextFilter() {
        GrepPageParticipant participant = this.getParticipant();
        if (participant == null) {
            this.setLineStyleListener(null);
            this.setContent(null);
        } else {
            this.setLineStyleListener(participant.getLineStyleListener());
            this.setContent(participant.getTextFilter());
        }
    }

    public void textChanging(TextChangingEvent event) {
    }

    public void textChanged(TextChangedEvent event) {
        this.autoScroll();
    }

    public void textSet(TextChangedEvent event) {
        this.autoScroll();
    }

    public void autoScroll() {
        if (!this.scrollLock) {
            this.text.setSelection(this.text.getCharCount());
        }
    }

    public boolean isScrollLock() {
        return this.scrollLock;
    }

    public void setScrollLock(boolean scrollLock) {
        this.scrollLock = scrollLock;
    }

    @Override
    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putBoolean(KEY_SCROLL_LOCK, this.scrollLock);
    }

    @Override
    public void participantChanged(GrepPageParticipant grepPageParticipant) {
        this.resetTextFilter();
        this.text.redraw();
    }

    public int getContextChangeMask() {
        return 0;
    }

    public IContext getContext(Object target) {
        return HelpSystem.getContext((String)"name.schedenig.eclipse.grepconsole.grep_view");
    }

    public String getSearchExpression(Object target) {
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (IContextProvider.class.equals((Object)adapter)) {
            return this;
        }
        return super.getAdapter(adapter);
    }
}

