/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.items;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.adapters.GrepLineStyleListener;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionItem;
import name.schedenig.eclipse.grepconsole.model.GrepGroup;
import name.schedenig.eclipse.grepconsole.model.GrepStyle;
import name.schedenig.eclipse.grepconsole.model.links.IGrepLink;
import name.schedenig.eclipse.grepconsole.model.xml.XmlHandler;
import name.schedenig.eclipse.grepconsole.model.xml.XmlHandlerException;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import name.schedenig.eclipse.grepconsole.util.GridLayoutBuilder;
import name.schedenig.eclipse.grepconsole.view.DefaultSizeDialog;
import name.schedenig.eclipse.grepconsole.view.colors.ColorRegistry;
import name.schedenig.eclipse.grepconsole.view.common.CharacterMarginPainter;
import name.schedenig.eclipse.grepconsole.view.items.DoubleClickEditingSupport;
import name.schedenig.eclipse.grepconsole.view.items.EditableItemsPanel;
import name.schedenig.eclipse.grepconsole.view.items.LineLengthChecker;
import name.schedenig.eclipse.grepconsole.view.items.LinkPickerLine;
import name.schedenig.eclipse.grepconsole.view.items.LogLevelContentProvider;
import name.schedenig.eclipse.grepconsole.view.items.LogLevelLabelProvider;
import name.schedenig.eclipse.grepconsole.view.items.PreviewColorHandler;
import name.schedenig.eclipse.grepconsole.view.items.StyleAssignmentsContentProvider;
import name.schedenig.eclipse.grepconsole.view.items.StyleAssignmentsGroupLabelProvider;
import name.schedenig.eclipse.grepconsole.view.items.StyleAssignmentsLinkLabelProvider;
import name.schedenig.eclipse.grepconsole.view.items.StyleAssignmentsStyleLabelProvider;
import name.schedenig.eclipse.grepconsole.view.items.links.LinkDialog;
import name.schedenig.eclipse.grepconsole.view.styles.StylesPanel;
import name.schedenig.eclipse.grepconsole.view.whatsnew.WhatsNewDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExpressionDialog
extends DefaultSizeDialog
implements StylesPanel.IStylesListener {
    public static final String DIALOG_SETTINGS_SECTION = "expressionDialog";
    protected static final String URL_PATTERN_HELP = "http://docs.oracle.com/javase/6/docs/api/java/util/regex/Pattern.html";
    private boolean add;
    private GrepExpressionItem item;
    private GrepExpressionItem workItem;
    private String previewText;
    private ColorRegistry colorRegistry;
    private GrepLineStyleListener grepLineStyleListener;
    private GrepGroup[] groupArray;
    private GrepGroup[] rewriteGroupArray;
    private HashSet<GrepStyle> backupStyles;
    private boolean duplicateGroupNames = false;
    private Label labelName;
    private Text textName;
    private Label labelExpression;
    private Text textExpression;
    private Label labelUnlessExpression;
    private Text textUnlessExpression;
    private Composite panelHeader;
    private StyledText stPreview;
    private Menu menuPreview;
    private MenuItem miAddExpressionFromPreview;
    private MenuItem miAddUnlessExpressionFromPreview;
    private TableViewerColumn colGroup;
    private TableViewerColumn colStyle;
    private Composite panelStyleAssignments;
    private Table tableStyleAssignments;
    private TableViewer viewerStyleAssignments;
    private StylesPanel panelAvailableStyles;
    private Button btnAssignStyle;
    private SashForm panelStyleTables;
    private Button cbActiveByDefault;
    private Button cbFilterDefault;
    private Button cbCaseSensitive;
    private MenuItem miLoadDefault;
    private MenuItem miSaveDefault;
    private TableViewerColumn colLink;
    private Menu menuGroups;
    private MenuItem miCopyLink;
    private MenuItem miPasteLink;
    private Clipboard clipboard;
    private Link labelPatternHelp;
    private Button cbRemoveOriginalStyle;
    private Label labelRewrite;
    private Text textRewrite;
    private StyleAssignmentsGroupLabelProvider groupLabelProvider;
    private Label labelQuickExpression;
    private Text textQuickExpression;
    private TabFolder tabs;
    private TabItem tiStyles;
    private TabItem tiGeneral;
    private Composite panelGeneral;
    private TabItem tiNotifications;
    private Composite panelNotifications;
    private Button cbPopupNotification;
    private Text textNotificationTitle;
    private Text textNotificationMessage;
    private Text textSoundNotification;
    private Button cbSoundNotification;
    private Button btnSoundNotification;
    private Button btnPlaySoundNotification;
    private Button cbNotificationsDefault;
    private Label labelPopupNotifications;
    private Label labelSoundNotifications;
    private Font headerFont;
    private Label labelPreview;
    private LinkPickerLine pickerNotificationLink;
    private LinkPickerLine pickerAutostartLink;
    private Label labelAutostartLink;
    private Composite compositePopupNotification;
    private Composite compositeOtherNotifications;
    private TabItem tiGrepView;
    private Composite panelGrepView;
    private TabItem tiStatistics;
    private Label labelStatisticsCountLabel;
    private Text textStatisticsCountLabel;
    private Label labelStatisticsValueLabel;
    private Text textStatisticsValueLabel;
    private Composite panelStatistics;
    private Label labelStatisticsValuePattern;
    private Text textStatisticsValuePattern;
    private Button cbStatisticsDefault;
    private Label labelStatisticsCountHeader;
    private Label labelStatisticsValueHeader;
    private Label labelLengthWarning;
    private LineLengthChecker lengthChecker;
    private CharacterMarginPainter marginPainter;
    private Label labelLogLevel;
    private Combo comboLogLevel;
    private Label labelLogMessage;
    private Text textLogMessage;
    private ComboViewer viewerLogLevel;
    private Label labelErrorLog;

    public ExpressionDialog(Shell parentShell, boolean add) {
        super(parentShell);
        this.add = add;
    }

    public void create() {
        super.create();
        this.refresh();
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.add ? Messages.ExpressionDialog_title_add_expression : Messages.ExpressionDialog_title_edit_expression);
        newShell.addShellListener((ShellListener)new WhatsNewDialog.ShellListener());
    }

    protected Control createDialogArea(Composite parent) {
        this.headerFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ExpressionDialog.this.colorRegistry != null) {
                    ExpressionDialog.this.colorRegistry.disposeColors();
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "name.schedenig.eclipse.grepconsole.edit_expression");
        this.colorRegistry = new ColorRegistry(Activator.getDefault().getColorRegistry());
        this.clipboard = new Clipboard(parent.getDisplay());
        Composite composite = parent;
        new GridLayoutBuilder(composite, 1, false).apply();
        this.panelHeader = this.createHeaderPanel(composite);
        this.panelHeader.setLayoutData((Object)new GridData(4, 128, true, false));
        this.tabs = new TabFolder(composite, 128);
        this.tabs.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tiGeneral = new TabItem(this.tabs, 0);
        this.tiGeneral.setText(Messages.ExpressionDialog_general);
        this.panelGeneral = this.createGeneralPanel((Composite)this.tabs);
        this.tiGeneral.setControl((Control)this.panelGeneral);
        this.tiStyles = new TabItem(this.tabs, 0);
        this.tiStyles.setText(Messages.ExpressionDialog_styles_links);
        this.tiGrepView = new TabItem(this.tabs, 0);
        this.tiGrepView.setText(Messages.ExpressionDialog_grep_view);
        this.panelGrepView = this.createGrepViewPanel((Composite)this.tabs);
        this.tiGrepView.setControl((Control)this.panelGrepView);
        this.tiNotifications = new TabItem(this.tabs, 0);
        this.tiNotifications.setText(Messages.ExpressionDialog_notifications_tab);
        this.panelNotifications = this.createNotificationsPanel((Composite)this.tabs);
        this.tiNotifications.setControl((Control)this.panelNotifications);
        this.tiStatistics = new TabItem(this.tabs, 0);
        this.tiStatistics.setText(Messages.ExpressionDialog_statistics_tab);
        this.panelStatistics = this.createStatisticsPanel((Composite)this.tabs);
        this.tiStatistics.setControl((Control)this.panelStatistics);
        this.panelStyleTables = new SashForm((Composite)this.tabs, 256);
        this.panelStyleTables.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tiStyles.setControl((Control)this.panelStyleTables);
        this.panelStyleAssignments = new Composite((Composite)this.panelStyleTables, 0);
        this.panelStyleAssignments.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayoutBuilder builder = new GridLayoutBuilder(this.panelStyleAssignments, 3, false).setMarginRight(0);
        builder.apply();
        GridLayout panelStyleAssignmentsLayout = builder.getLayout();
        this.panelStyleTables.setSashWidth(((GridLayout)this.panelStyleAssignments.getLayout()).marginLeft);
        this.tableStyleAssignments = new Table(this.panelStyleAssignments, 67584);
        this.tableStyleAssignments.setHeaderVisible(true);
        this.tableStyleAssignments.setLinesVisible(false);
        this.tableStyleAssignments.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.viewerStyleAssignments = new TableViewer(this.tableStyleAssignments);
        this.viewerStyleAssignments.setContentProvider((IContentProvider)new StyleAssignmentsContentProvider());
        this.groupLabelProvider = new StyleAssignmentsGroupLabelProvider((ColumnViewer)this.viewerStyleAssignments);
        this.colGroup = new TableViewerColumn(this.viewerStyleAssignments, 16384);
        this.colGroup.getColumn().setText(Messages.ExpressionDialog_column_group);
        this.colGroup.getColumn().setWidth(130);
        this.colGroup.setLabelProvider((CellLabelProvider)this.groupLabelProvider);
        this.colStyle = new TableViewerColumn(this.viewerStyleAssignments, 16384);
        this.colStyle.getColumn().setText(Messages.ExpressionDialog_column_style);
        this.colStyle.getColumn().setWidth(130);
        this.colStyle.setLabelProvider((CellLabelProvider)new StyleAssignmentsStyleLabelProvider((ColumnViewer)this.viewerStyleAssignments));
        this.colLink = new TableViewerColumn(this.viewerStyleAssignments, 131072);
        this.colLink.getColumn().setText(Messages.ExpressionDialog_link);
        this.colLink.getColumn().setWidth(70);
        this.colLink.setLabelProvider((CellLabelProvider)new StyleAssignmentsLinkLabelProvider((ColumnViewer)this.viewerStyleAssignments));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewerStyleAssignments);
        this.menuGroups = new Menu((Control)this.tableStyleAssignments);
        this.miCopyLink = new MenuItem(this.menuGroups, 8);
        this.miCopyLink.setText(Messages.ExpressionDialog_copy_link);
        this.miCopyLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionDialog.this.copyLink();
            }
        });
        this.miPasteLink = new MenuItem(this.menuGroups, 8);
        this.miPasteLink.setText(Messages.ExpressionDialog_paste_link);
        this.miPasteLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionDialog.this.pasteLink();
            }
        });
        this.menuGroups.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Integer group = ExpressionDialog.this.getSelectedGroup((IStructuredSelection)ExpressionDialog.this.viewerStyleAssignments.getSelection());
                ExpressionDialog.this.miCopyLink.setEnabled(group != null && ExpressionDialog.this.getGroup(group).getLink() != null);
                ExpressionDialog.this.miPasteLink.setEnabled(group != null);
            }
        });
        this.tableStyleAssignments.setMenu(this.menuGroups);
        this.viewerStyleAssignments.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExpressionDialog.this.groupSelected(ExpressionDialog.this.getSelectedGroup((IStructuredSelection)event.getSelection()));
            }
        });
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this.viewerStyleAssignments, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewerStyleAssignments));
        ColumnViewerEditorActivationStrategy activationSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewerStyleAssignments){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                if (event.eventType == 3) {
                    EventObject source = event.sourceEvent;
                    return !(source instanceof MouseEvent) || ((MouseEvent)source).button != 3;
                }
                return false;
            }
        };
        TableViewerEditor.create((TableViewer)this.viewerStyleAssignments, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)activationSupport, (int)58);
        EditingSupport nameEditingSupport = new EditingSupport((ColumnViewer)this.viewerStyleAssignments){

            protected void setValue(Object element, Object value) {
                String s = ((String)value).trim();
                if (s.length() == 0) {
                    s = null;
                }
                ExpressionDialog.this.getGroup((Integer)element).setName(s);
                ExpressionDialog.this.viewerStyleAssignments.refresh(element);
                ExpressionDialog.this.updateDuplicateGroupNames();
            }

            protected Object getValue(Object element) {
                GrepGroup group = ExpressionDialog.this.getGroup((Integer)element);
                return group.getName() == null ? "" : group.getName();
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)ExpressionDialog.this.viewerStyleAssignments.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        };
        this.colGroup.setEditingSupport(nameEditingSupport);
        DoubleClickEditingSupport styleEditingSupport = new DoubleClickEditingSupport((ColumnViewer)this.viewerStyleAssignments){

            @Override
            protected void doEdit(Object value) {
                Integer group = ExpressionDialog.this.getSelectedGroup((IStructuredSelection)ExpressionDialog.this.viewerStyleAssignments.getSelection());
                final GrepStyle style = ExpressionDialog.this.getGroup(group).getStyle();
                ExpressionDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (style == null) {
                            ExpressionDialog.this.panelAvailableStyles.doNewStyle();
                        } else {
                            ExpressionDialog.this.panelAvailableStyles.doEditStyle(style);
                        }
                    }
                });
            }
        };
        this.colStyle.setEditingSupport((EditingSupport)styleEditingSupport);
        this.colLink.setEditingSupport((EditingSupport)new DoubleClickEditingSupport((ColumnViewer)this.viewerStyleAssignments){

            @Override
            protected void doEdit(Object value) {
                final Integer groupIndex = ExpressionDialog.this.getSelectedGroup((IStructuredSelection)ExpressionDialog.this.viewerStyleAssignments.getSelection());
                final GrepGroup group = ExpressionDialog.this.getGroup(groupIndex);
                ExpressionDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LinkDialog dlg = new LinkDialog(ExpressionDialog.this.getShell(), groupIndex < ExpressionDialog.this.workItem.getGroups().length);
                        dlg.setLink(group.getLink());
                        if (dlg.open() == 0) {
                            group.setLink(dlg.getLink());
                            ExpressionDialog.this.viewerStyleAssignments.refresh();
                        }
                    }
                });
            }
        });
        this.cbRemoveOriginalStyle = new Button(this.panelStyleAssignments, 32);
        this.cbRemoveOriginalStyle.setText(Messages.ExpressionDialog_remove_original_style);
        this.cbRemoveOriginalStyle.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        this.cbRemoveOriginalStyle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionDialog.this.workItem.setRemoveOriginalStyle(ExpressionDialog.this.cbRemoveOriginalStyle.getSelection());
                ExpressionDialog.this.refreshPreview();
            }
        });
        this.grepLineStyleListener = new GrepLineStyleListener(this.getShell(), null);
        this.grepLineStyleListener.setColorRegistry(this.colorRegistry);
        this.labelPreview = new Label(this.panelStyleAssignments, 0);
        this.labelPreview.setFont(this.headerFont);
        this.labelPreview.setText(Messages.ExpressionDialog_preview);
        GridData gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        gridData.verticalIndent = 10;
        this.labelPreview.setLayoutData((Object)gridData);
        this.labelLengthWarning = new Label(this.panelStyleAssignments, 0);
        this.labelLengthWarning.setAlignment(0x1000008);
        this.labelLengthWarning.setText(LineLengthChecker.LABEL_TEXT);
        this.labelLengthWarning.setVisible(false);
        gridData = new GridData(0x1000008, 0x1000000, true, false, 1, 1);
        gridData.verticalIndent = 10;
        this.labelLengthWarning.setLayoutData((Object)gridData);
        this.stPreview = new StyledText(this.panelStyleAssignments, 2818);
        GridData gd = new GridData(4, 4, true, true, 3, 1);
        gd.heightHint = parent.getDisplay().getDPI().y * JFaceResources.getTextFont().getFontData()[0].getHeight() / 72 * 4;
        this.stPreview.setLayoutData((Object)gd);
        this.stPreview.addLineStyleListener((LineStyleListener)this.grepLineStyleListener);
        this.stPreview.setFont(JFaceResources.getTextFont());
        this.updatePreviewToolTip();
        this.lengthChecker = new LineLengthChecker(this.stPreview);
        this.lengthChecker.addListener(new LineLengthChecker.Listener(){

            @Override
            public void exceedsChanged() {
                ExpressionDialog.this.updateLengthWarning();
            }
        });
        this.marginPainter = new CharacterMarginPainter((Control)this.stPreview);
        this.marginPainter.addMargin(Activator.getDefault().getStyleMatchLength(), this.colorRegistry.get(EditableItemsPanel.COLOR_STYLE_MATCH_LENGTH_LIMIT));
        this.marginPainter.addMargin(Activator.getDefault().getFilterMatchLength(), this.colorRegistry.get(EditableItemsPanel.COLOR_FILTER_MATCH_LENGTH_LIMIT));
        this.menuPreview = new Menu((Control)this.stPreview);
        this.miAddExpressionFromPreview = new MenuItem(this.menuPreview, 8);
        this.miAddExpressionFromPreview.setText(Messages.ExpressionDialog_use_as_expression);
        this.miAddExpressionFromPreview.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionDialog.this.setExpression(ExpressionDialog.this.stPreview.getSelectionText());
            }
        });
        this.miAddUnlessExpressionFromPreview = new MenuItem(this.menuPreview, 8);
        this.miAddUnlessExpressionFromPreview.setText(Messages.ExpressionDialog_use_as_unless_expression);
        this.miAddUnlessExpressionFromPreview.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionDialog.this.setUnlessExpression(ExpressionDialog.this.stPreview.getSelectionText());
            }
        });
        this.miLoadDefault = new MenuItem(this.menuPreview, 8);
        this.miLoadDefault.setText(Messages.ExpressionDialog_load_default);
        this.miLoadDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionDialog.this.doLoadDefaultPreview();
            }
        });
        this.miSaveDefault = new MenuItem(this.menuPreview, 8);
        this.miSaveDefault.setText(Messages.ExpressionDialog_save_default);
        this.miSaveDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionDialog.this.doSaveDefaultPreview();
            }
        });
        this.menuPreview.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                String text = ExpressionDialog.this.stPreview.getSelectionText();
                ExpressionDialog.this.miAddExpressionFromPreview.setEnabled(text != null && text.length() > 0);
                super.menuShown(e);
            }
        });
        new MenuItem(this.menuPreview, 2);
        new PreviewColorHandler((Control)this.stPreview, this.menuPreview);
        this.stPreview.setMenu(this.menuPreview);
        this.panelAvailableStyles = new StylesPanel((Composite)this.panelStyleTables, 0){

            @Override
            protected void doStylesSelected(Collection<GrepStyle> styles) {
                ExpressionDialog.this.btnAssignStyle.setEnabled(styles.size() == 1);
                super.doStylesSelected(styles);
            }

            @Override
            protected void createButtons(Composite parent) {
                ExpressionDialog.this.btnAssignStyle = new Button(parent, 8);
                ExpressionDialog.this.btnAssignStyle.setText(Messages.ExpressionDialog_assign);
                ExpressionDialog.this.btnAssignStyle.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ExpressionDialog.this.doAssignStyle(ExpressionDialog.this.panelAvailableStyles.getSelectedStyle());
                    }
                });
                super.createButtons(parent);
            }
        };
        GridLayout panelAvailableStylesLayout = (GridLayout)this.panelAvailableStyles.getLayout();
        panelAvailableStylesLayout.marginLeft = panelStyleAssignmentsLayout.marginRight;
        panelAvailableStylesLayout.marginRight = panelStyleAssignmentsLayout.marginLeft;
        panelAvailableStylesLayout.marginWidth = panelStyleAssignmentsLayout.marginWidth;
        panelAvailableStylesLayout.marginHeight = panelStyleAssignmentsLayout.marginHeight;
        panelAvailableStylesLayout.marginTop = panelStyleAssignmentsLayout.marginTop;
        panelAvailableStylesLayout.marginBottom = panelStyleAssignmentsLayout.marginBottom;
        this.panelAvailableStyles.setIncludeNullStyle(true);
        this.panelAvailableStyles.addListener(this);
        if (this.workItem != null) {
            this.panelAvailableStyles.setRoot(this.workItem.getRoot());
        }
        this.textExpression.setFocus();
        return composite;
    }

    protected void pasteLink() {
        Integer group = this.getSelectedGroup((IStructuredSelection)this.viewerStyleAssignments.getSelection());
        if (group == null) {
            return;
        }
        IGrepLink link = this.getLinkFromClipboard();
        if (link != null) {
            this.getGroup(group).setLink(link);
            this.viewerStyleAssignments.refresh();
        }
    }

    private IGrepLink getLinkFromClipboard() {
        TextTransfer transfer = TextTransfer.getInstance();
        String xml = (String)this.clipboard.getContents((Transfer)transfer);
        XmlHandler handler = new XmlHandler();
        try {
            return handler.readLink(xml);
        }
        catch (XmlHandlerException ex) {
            Activator.getDefault().log(4, Messages.EditableItemsPanel_paste_failed, ex);
            return null;
        }
    }

    protected void copyLink() {
        Integer group = this.getSelectedGroup((IStructuredSelection)this.viewerStyleAssignments.getSelection());
        if (group == null) {
            return;
        }
        this.copyLink(this.getGroup(group).getLink());
    }

    protected void copyLink(IGrepLink link) {
        XmlHandler xmlHandler = new XmlHandler();
        try {
            String xml = xmlHandler.createLinkXmlString(link);
            TextTransfer textTransfer = TextTransfer.getInstance();
            this.clipboard.setContents(new Object[]{xml}, new Transfer[]{textTransfer});
        }
        catch (ParserConfigurationException ex) {
            Activator.getDefault().log(4, "Could not copy link to clipboard.", ex);
        }
        catch (TransformerException ex) {
            Activator.getDefault().log(4, "Could not copy link to clipboard.", ex);
        }
    }

    private Composite createHeaderPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        new GridLayoutBuilder(composite, 2, false).setMargins(0).apply();
        this.labelExpression = new Label(composite, 0);
        this.labelExpression.setText(Messages.ExpressionDialog_expression);
        this.labelExpression.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textExpression = new Text(composite, 2048);
        this.textExpression.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textExpression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExpressionDialog.this.expressionChanged(ExpressionDialog.this.textExpression.getText());
            }
        });
        return composite;
    }

    private Composite createGeneralPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        new GridLayoutBuilder(composite, 2, false).apply();
        this.labelName = new Label(composite, 0);
        this.labelName.setText(Messages.ExpressionDialog_name);
        this.labelName.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textName = new Text(composite, 2048);
        this.textName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ExpressionDialog.this.textName.getText();
                ExpressionDialog.this.workItem.setName(text.length() > 0 ? text : null);
            }
        });
        this.labelQuickExpression = new Label(composite, 0);
        this.labelQuickExpression.setText(Messages.ExpressionDialog_quick_expression);
        this.labelQuickExpression.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textQuickExpression = new Text(composite, 2048);
        this.textQuickExpression.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textQuickExpression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExpressionDialog.this.quickExpressionChanged(ExpressionDialog.this.textQuickExpression.getText());
            }
        });
        this.labelUnlessExpression = new Label(composite, 0);
        this.labelUnlessExpression.setText(Messages.ExpressionDialog_unless_expression);
        this.labelUnlessExpression.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textUnlessExpression = new Text(composite, 2048);
        this.textUnlessExpression.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textUnlessExpression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExpressionDialog.this.unlessExpressionChanged(ExpressionDialog.this.textUnlessExpression.getText());
            }
        });
        this.cbCaseSensitive = new Button(composite, 32);
        this.cbCaseSensitive.setText(Messages.ExpressionDialog_case_sensitive);
        this.cbCaseSensitive.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.cbCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionDialog.this.workItem.setCaseInsensitive(!ExpressionDialog.this.cbCaseSensitive.getSelection());
                ExpressionDialog.this.refreshPreview();
            }
        });
        this.labelPatternHelp = new Link(composite, 0);
        this.labelPatternHelp.setText("<a>" + Messages.ExpressionDialog_pattern_help + "</a>");
        this.labelPatternHelp.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 2, 1));
        this.labelPatternHelp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)ExpressionDialog.URL_PATTERN_HELP);
            }
        });
        Label labelDefaults = new Label(composite, 0);
        labelDefaults.setText(Messages.ExpressionDialog_defaults);
        labelDefaults.setFont(this.headerFont);
        labelDefaults.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        Composite panelDefaults = new Composite(composite, 0);
        new GridLayoutBuilder(panelDefaults, 4, false).setMargins(0).apply();
        panelDefaults.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.cbActiveByDefault = new Button(panelDefaults, 32);
        this.cbActiveByDefault.setText(Messages.ExpressionDialog_active_by_default);
        this.cbActiveByDefault.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        this.cbActiveByDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionDialog.this.workItem.setDefaultEnabled(ExpressionDialog.this.cbActiveByDefault.getSelection());
            }
        });
        this.cbFilterDefault = new Button(panelDefaults, 32);
        this.cbFilterDefault.setText(Messages.ExpressionDialog_filter_default);
        this.cbFilterDefault.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        this.cbFilterDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionDialog.this.workItem.setDefaultFilter(ExpressionDialog.this.cbFilterDefault.getSelection());
            }
        });
        this.cbStatisticsDefault = new Button(panelDefaults, 32);
        this.cbStatisticsDefault.setText(Messages.ExpressionDialog_statistics_default);
        this.cbStatisticsDefault.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        this.cbStatisticsDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionDialog.this.workItem.setDefaultStatistics(ExpressionDialog.this.cbStatisticsDefault.getSelection());
            }
        });
        this.cbNotificationsDefault = new Button(panelDefaults, 32);
        this.cbNotificationsDefault.setText(Messages.ExpressionDialog_notifications);
        this.cbNotificationsDefault.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        this.cbNotificationsDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionDialog.this.workItem.setDefaultNotifications(ExpressionDialog.this.cbNotificationsDefault.getSelection());
            }
        });
        return composite;
    }

    private Composite createGrepViewPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        new GridLayoutBuilder(composite, 2, false).apply();
        this.labelRewrite = new Label(composite, 0);
        this.labelRewrite.setText(Messages.ExpressionDialog_rewrite);
        this.labelRewrite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textRewrite = new Text(composite, 2048);
        this.textRewrite.setToolTipText(Messages.LinkPanel_pattern_tooltip_without_capture_group);
        this.textRewrite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textRewrite.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ExpressionDialog.this.textRewrite.getText();
                ExpressionDialog.this.workItem.setRewriteExpression(text.trim().length() > 0 ? text : null);
                ExpressionDialog.this.refreshGroups();
            }
        });
        return composite;
    }

    private Composite createNotificationsPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        FillLayout layout = new FillLayout(256);
        composite.setLayout((Layout)layout);
        this.compositePopupNotification = new Composite(composite, 0);
        new GridLayoutBuilder(this.compositePopupNotification, 4, false).apply();
        this.compositeOtherNotifications = new Composite(composite, 0);
        new GridLayoutBuilder(this.compositeOtherNotifications, 4, false).apply();
        this.labelPopupNotifications = new Label(this.compositePopupNotification, 0);
        this.labelPopupNotifications.setText(Messages.ExpressionDialog_popup_notification);
        this.labelPopupNotifications.setFont(this.headerFont);
        this.labelPopupNotifications.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.cbPopupNotification = new Button(this.compositePopupNotification, 32);
        this.cbPopupNotification.setText(Messages.ExpressionDialog_enabled);
        this.cbPopupNotification.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.cbPopupNotification.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionDialog.this.workItem.setPopupNotification(ExpressionDialog.this.cbPopupNotification.getSelection());
                ExpressionDialog.this.refreshPreview();
            }
        });
        Label labelNotificationTitle = new Label(this.compositePopupNotification, 0);
        labelNotificationTitle.setText(Messages.ExpressionDialog_title);
        labelNotificationTitle.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.textNotificationTitle = new Text(this.compositePopupNotification, 2048);
        this.textNotificationTitle.setToolTipText(Messages.LinkPanel_pattern_tooltip_with_capture_group);
        this.textNotificationTitle.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.textNotificationTitle.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ExpressionDialog.this.textNotificationTitle.getText().trim();
                ExpressionDialog.this.workItem.setNotificationTitle(text.length() > 0 ? text : null);
            }
        });
        Label labelNotificationMessage = new Label(this.compositePopupNotification, 0);
        labelNotificationMessage.setText(Messages.ExpressionDialog_message);
        labelNotificationMessage.setLayoutData((Object)new GridData(4, 0x1000008, false, false, 4, 1));
        this.textNotificationMessage = new Text(this.compositePopupNotification, 2114);
        this.textNotificationMessage.setToolTipText(Messages.LinkPanel_pattern_tooltip_with_capture_group);
        this.textNotificationMessage.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.textNotificationMessage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ExpressionDialog.this.textNotificationMessage.getText().trim();
                ExpressionDialog.this.workItem.setNotificationMessage(text.length() > 0 ? text : null);
            }
        });
        this.pickerNotificationLink = new LinkPickerLine(this.compositePopupNotification);
        this.pickerNotificationLink.setText(Messages.ExpressionDialog_link_label);
        this.pickerNotificationLink.addListener(new LinkPickerLine.ILinkChangeListener(){

            @Override
            public void linkChanged(LinkPickerLine source, IGrepLink link) {
                ExpressionDialog.this.workItem.setNotificationLink(link);
            }
        });
        this.labelSoundNotifications = new Label(this.compositeOtherNotifications, 0);
        this.labelSoundNotifications.setFont(this.headerFont);
        this.labelSoundNotifications.setText(Messages.ExpressionDialog_sound_notification);
        GridData gridData = new GridData(4, 0x1000000, true, false, 4, 1);
        this.labelSoundNotifications.setLayoutData((Object)gridData);
        this.cbSoundNotification = new Button(this.compositeOtherNotifications, 32);
        this.cbSoundNotification.setText(Messages.ExpressionDialog_sound);
        this.cbSoundNotification.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.cbSoundNotification.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionDialog.this.textSoundNotification.setEnabled(ExpressionDialog.this.cbSoundNotification.getSelection());
                ExpressionDialog.this.btnPlaySoundNotification.setEnabled(ExpressionDialog.this.cbSoundNotification.getSelection());
                if (ExpressionDialog.this.cbSoundNotification.getSelection()) {
                    if (ExpressionDialog.this.workItem.getSoundNotificationPath() != null) {
                        ExpressionDialog.this.textSoundNotification.setText(ExpressionDialog.this.workItem.getSoundNotificationPath());
                    }
                } else {
                    ExpressionDialog.this.workItem.setSoundNotificationPath(null);
                }
            }
        });
        this.textSoundNotification = new Text(this.compositeOtherNotifications, 2048);
        this.textSoundNotification.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textSoundNotification.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ExpressionDialog.this.textSoundNotification.getText().trim();
                ExpressionDialog.this.workItem.setSoundNotificationPath(text.length() > 0 ? text : null);
            }
        });
        this.btnPlaySoundNotification = new Button(this.compositeOtherNotifications, 8);
        this.btnPlaySoundNotification.setToolTipText(Messages.ExpressionDialog_play);
        this.btnPlaySoundNotification.setImage(Activator.getDefault().getImageRegistry().get("play"));
        this.btnPlaySoundNotification.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnPlaySoundNotification.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = ExpressionDialog.this.textSoundNotification.getText().trim();
                if (text.length() > 0) {
                    ExpressionDialog.this.playSound(text);
                }
            }
        });
        this.btnSoundNotification = new Button(this.compositeOtherNotifications, 8);
        this.btnSoundNotification.setText(Messages.ExpressionDialog_browse);
        this.btnSoundNotification.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnSoundNotification.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionDialog.this.selectSoundNotification();
            }
        });
        this.labelAutostartLink = new Label(this.compositeOtherNotifications, 0);
        this.labelAutostartLink.setFont(this.headerFont);
        this.labelAutostartLink.setText(Messages.ExpressionDialog_autostart_action);
        gridData = new GridData(4, 0x1000000, true, false, 4, 1);
        gridData.verticalIndent = 10;
        this.labelAutostartLink.setLayoutData((Object)gridData);
        this.pickerAutostartLink = new LinkPickerLine(this.compositeOtherNotifications);
        this.pickerAutostartLink.setText(Messages.ExpressionDialog_action);
        this.pickerAutostartLink.addListener(new LinkPickerLine.ILinkChangeListener(){

            @Override
            public void linkChanged(LinkPickerLine source, IGrepLink link) {
                ExpressionDialog.this.workItem.setAutostartLink(link);
            }
        });
        this.labelErrorLog = new Label(this.compositeOtherNotifications, 0);
        this.labelErrorLog.setFont(this.headerFont);
        this.labelErrorLog.setText(Messages.ExpressionDialog_label_error_log);
        gridData = new GridData(4, 0x1000000, true, false, 4, 1);
        this.labelErrorLog.setLayoutData((Object)gridData);
        this.labelLogLevel = new Label(this.compositeOtherNotifications, 0);
        this.labelLogLevel.setText(Messages.ExpressionDialog_label_error_log_level);
        this.labelLogLevel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboLogLevel = new Combo(this.compositeOtherNotifications, 4);
        this.comboLogLevel.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 3, 1));
        this.viewerLogLevel = new ComboViewer(this.comboLogLevel);
        this.viewerLogLevel.setContentProvider((IContentProvider)new LogLevelContentProvider());
        this.viewerLogLevel.setLabelProvider((IBaseLabelProvider)new LogLevelLabelProvider());
        this.viewerLogLevel.setInput((Object)new Integer[]{0, 1, 2, 4});
        this.viewerLogLevel.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                int level = (Integer)selection.getFirstElement();
                ExpressionDialog.this.workItem.setErrorLogLevel(level);
            }
        });
        this.labelLogMessage = new Label(this.compositeOtherNotifications, 0);
        this.labelLogMessage.setText(Messages.ExpressionDialog_label_error_log_message);
        this.labelLogMessage.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textLogMessage = new Text(this.compositeOtherNotifications, 2048);
        this.textLogMessage.setToolTipText(Messages.LinkPanel_pattern_tooltip_without_capture_group);
        this.textLogMessage.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.textLogMessage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ExpressionDialog.this.textLogMessage.getText();
                ExpressionDialog.this.workItem.setErrorLogMessage(text.trim().length() > 0 ? text : null);
            }
        });
        return composite;
    }

    private Composite createStatisticsPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        new GridLayoutBuilder(composite, 2, false).apply();
        this.labelStatisticsCountHeader = new Label(composite, 0);
        this.labelStatisticsCountHeader.setFont(this.headerFont);
        this.labelStatisticsCountHeader.setText(Messages.ExpressionDialog_statistics_count_header);
        this.labelStatisticsCountHeader.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.labelStatisticsCountLabel = new Label(composite, 0);
        this.labelStatisticsCountLabel.setText(Messages.ExpressionDialog_statistics_count_label);
        this.labelStatisticsCountLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textStatisticsCountLabel = new Text(composite, 2048);
        this.textStatisticsCountLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textStatisticsCountLabel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ExpressionDialog.this.textStatisticsCountLabel.getText().trim();
                ExpressionDialog.this.workItem.setStatisticsCountLabel(text.length() > 0 ? text : null);
            }
        });
        this.labelStatisticsValueHeader = new Label(composite, 0);
        this.labelStatisticsValueHeader.setFont(this.headerFont);
        this.labelStatisticsValueHeader.setText(Messages.ExpressionDialog_statistics_value_header);
        GridData gridData = new GridData(1, 0x1000000, false, false, 2, 1);
        gridData.verticalIndent = 10;
        this.labelStatisticsValueHeader.setLayoutData((Object)gridData);
        this.labelStatisticsValueLabel = new Label(composite, 0);
        this.labelStatisticsValueLabel.setText(Messages.ExpressionDialog_statistics_value_label);
        this.labelStatisticsValueLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textStatisticsValueLabel = new Text(composite, 2048);
        this.textStatisticsValueLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textStatisticsValueLabel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ExpressionDialog.this.textStatisticsValueLabel.getText().trim();
                ExpressionDialog.this.workItem.setStatisticsValueLabel(text.length() > 0 ? text : null);
            }
        });
        this.labelStatisticsValuePattern = new Label(composite, 0);
        this.labelStatisticsValuePattern.setText(Messages.ExpressionDialog_statistics_value_pattern);
        this.labelStatisticsValuePattern.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textStatisticsValuePattern = new Text(composite, 2048);
        this.textStatisticsValuePattern.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textStatisticsValuePattern.setToolTipText(Messages.LinkPanel_pattern_tooltip_without_capture_group);
        this.textStatisticsValuePattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ExpressionDialog.this.textStatisticsValuePattern.getText().trim();
                ExpressionDialog.this.workItem.setStatisticsValuePattern(text.length() > 0 ? text : null);
            }
        });
        return composite;
    }

    protected void playSound(String path) {
        String error = null;
        try {
            Activator.getDefault().getSoundManager().playSound(path);
        }
        catch (UnsupportedAudioFileException ex) {
            error = ex.getLocalizedMessage();
        }
        catch (IOException ex) {
            error = ex.getLocalizedMessage();
        }
        catch (LineUnavailableException ex) {
            error = ex.getLocalizedMessage();
        }
        if (error != null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ExpressionDialog_sound_error, (String)MessageFormat.format(Messages.ExpressionDialog_could_not_play_sound, error));
        }
    }

    protected void selectSoundNotification() {
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        dlg.setText(Messages.ExpressionDialog_select_notification_sound);
        dlg.setFilterNames(new String[]{Messages.ExpressionDialog_audio_files, Messages.ExpressionDialog_all_files});
        dlg.setFilterExtensions(new String[]{"*.wav;*.aif;*.au", "*.*"});
        String path = dlg.open();
        if (path != null) {
            path = path.trim();
            this.textSoundNotification.setText(path);
            this.workItem.setSoundNotificationPath(path);
            this.cbSoundNotification.setSelection(true);
            this.textSoundNotification.setEnabled(true);
            this.btnPlaySoundNotification.setEnabled(true);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_SECTION);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return settings;
    }

    @Override
    protected Point getDefaultSize() {
        Shell shell = this.getShell();
        return GrepConsoleUtil.charsToPixelDimensions((Drawable)shell, 120, 30);
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        shell.setMinimumSize(GrepConsoleUtil.charsToPixelDimensions((Drawable)shell, 70, 25));
    }

    private void doLoadDefaultPreview() {
        this.stPreview.setText(Activator.getDefault().getPreviewText());
    }

    private void doSaveDefaultPreview() {
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.Preview_save_default_preview_title, (String)Messages.Preview_save_default_preview_confirm)) {
            Activator.getDefault().setPreviewText(this.stPreview.getText());
        }
    }

    protected void fillStyleRange(StyleRange style, GrepStyle grepStyle) {
        RGB rgbForeground = grepStyle.getForeground();
        RGB rgbBackground = grepStyle.getBackground();
        RGB rgbUnderline = grepStyle.getUnderlineColor();
        RGB rgbStrikethrough = grepStyle.getStrikeoutColor();
        RGB rgbBorder = grepStyle.getBorderColor();
        if (rgbBackground == null) {
            rgbBackground = new RGB(255, 255, 255);
        }
        style.foreground = this.colorRegistry.get(rgbForeground);
        style.background = this.colorRegistry.get(rgbBackground);
        style.fontStyle = (grepStyle.isBold() ? 1 : 0) | (grepStyle.isItalic() ? 2 : 0);
        style.underline = grepStyle.isUnderline();
        style.underlineColor = this.colorRegistry.get(rgbUnderline);
        style.strikeout = grepStyle.isStrikeout();
        style.strikeoutColor = this.colorRegistry.get(rgbStrikethrough);
        style.borderStyle = grepStyle.isBorder() ? 1 : 0;
        style.borderColor = this.colorRegistry.get(rgbBorder);
    }

    protected GrepStyle getSelectedStyle(IStructuredSelection selection) {
        Object o = selection == null || selection.isEmpty() ? null : selection.getFirstElement();
        return (GrepStyle)(o instanceof GrepStyle ? o : null);
    }

    protected void setExpression(String text) {
        String expression = "(" + Pattern.quote(text) + ")";
        this.textExpression.setText(expression);
        this.textExpression.selectAll();
        this.expressionChanged(expression);
    }

    protected void setUnlessExpression(String text) {
        String expression = Pattern.quote(text);
        this.textUnlessExpression.setText(expression);
        this.textUnlessExpression.selectAll();
        this.unlessExpressionChanged(expression);
    }

    protected void expressionChanged(String expression) {
        this.workItem.setGrepExpression(expression);
        this.refreshGroups();
        this.refreshPreview();
    }

    protected void quickExpressionChanged(String quickExpression) {
        String s = quickExpression.trim();
        this.workItem.setQuickGrepExpression(s.length() == 0 ? null : s);
        this.refreshPreview();
    }

    protected void unlessExpressionChanged(String unlessExpression) {
        String s = unlessExpression.trim();
        this.workItem.setUnlessGrepExpression(s.length() == 0 ? null : s);
        this.refreshPreview();
    }

    protected GrepGroup getGroup(Integer index) {
        if (index == null) {
            return null;
        }
        int styleGroupCount = this.workItem.getGroups().length;
        if (index < styleGroupCount) {
            return this.workItem.getGroups()[index];
        }
        return this.workItem.getRewriteGroups()[index - styleGroupCount];
    }

    protected void groupSelected(Integer index) {
        GrepGroup group = this.getGroup(index);
        GrepStyle style = group == null ? null : group.getStyle();
        this.panelAvailableStyles.setSelection(style);
    }

    protected void doAssignStyle(GrepStyle style) {
        Integer groupIndex = this.getSelectedGroup((IStructuredSelection)this.viewerStyleAssignments.getSelection());
        if (groupIndex != null) {
            GrepGroup group = this.getGroup(groupIndex);
            group.setStyle(style);
            this.refreshPreview();
            this.viewerStyleAssignments.refresh();
            this.refreshPreview();
        }
    }

    private Integer getSelectedGroup(IStructuredSelection selection) {
        if (selection == null) {
            return null;
        }
        return selection.isEmpty() ? null : (Integer)selection.getFirstElement();
    }

    protected void refreshGroups() {
        String regex = this.textExpression.getText().trim();
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regex);
            this.textExpression.setForeground(null);
            this.textExpression.setToolTipText(null);
        }
        catch (PatternSyntaxException ex) {
            this.textExpression.setToolTipText(ex.getLocalizedMessage());
            this.textExpression.setForeground(this.textExpression.getDisplay().getSystemColor(3));
        }
        int groups = pattern == null ? 0 : pattern.matcher("").groupCount();
        this.groupArray = Arrays.copyOf(this.groupArray == null ? this.workItem.getGroups() : this.groupArray, Math.max(groups + 1, this.groupArray == null ? 0 : this.groupArray.length));
        int i = 0;
        while (i < this.groupArray.length) {
            if (i < this.workItem.getGroups().length) {
                GrepGroup group = this.workItem.getGroups()[i];
                this.groupArray[i] = group == null ? null : group.copy(true);
            } else if (this.groupArray[i] == null) {
                this.groupArray[i] = new GrepGroup();
            }
            ++i;
        }
        this.workItem.setGroups(Arrays.copyOf(this.groupArray, groups + 1));
        int rewriteGroups = this.workItem.getRewriteExpression() == null ? 0 : 1 + GrepConsoleUtil.countGroups(this.workItem.getRewriteExpression());
        this.rewriteGroupArray = Arrays.copyOf(this.rewriteGroupArray == null ? this.workItem.getRewriteGroups() : this.rewriteGroupArray, Math.max(rewriteGroups, this.rewriteGroupArray == null ? 0 : this.rewriteGroupArray.length));
        int i2 = 0;
        while (i2 < this.rewriteGroupArray.length) {
            if (i2 < this.workItem.getRewriteGroups().length) {
                GrepGroup group = this.workItem.getRewriteGroups()[i2];
                this.rewriteGroupArray[i2] = group == null ? null : group.copy(true);
            } else if (this.rewriteGroupArray[i2] == null) {
                this.rewriteGroupArray[i2] = new GrepGroup();
            }
            ++i2;
        }
        this.workItem.setRewriteGroups(Arrays.copyOf(this.rewriteGroupArray, rewriteGroups));
        GrepGroup[] displayedGroups = new GrepGroup[this.workItem.getGroups().length + this.workItem.getRewriteGroups().length];
        System.arraycopy(this.workItem.getGroups(), 0, displayedGroups, 0, this.workItem.getGroups().length);
        System.arraycopy(this.workItem.getRewriteGroups(), 0, displayedGroups, this.workItem.getGroups().length, this.workItem.getRewriteGroups().length);
        this.groupLabelProvider.setCaptureGroupCount(this.workItem.getGroups().length);
        this.viewerStyleAssignments.setInput((Object)displayedGroups);
        this.viewerStyleAssignments.refresh();
        if (this.panelAvailableStyles.getSelectedStyle() == null) {
            this.viewerStyleAssignments.setSelection((ISelection)new StructuredSelection((Object)0));
        }
    }

    public GrepExpressionItem getItem() {
        return this.item;
    }

    public void setItem(GrepExpressionItem item) {
        this.item = item;
        this.workItem = item.copy(true);
        this.backupStyles = new HashSet();
        for (GrepStyle style : item.getRoot().getStyles()) {
            this.backupStyles.add(style.copy(true));
        }
        if (this.textName != null) {
            this.refresh();
        }
        if (this.panelAvailableStyles != null) {
            this.panelAvailableStyles.setRoot(this.workItem.getRoot());
        }
    }

    private void updateDuplicateGroupNames() {
        HashSet<String> names = new HashSet<String>();
        boolean duplicates = false;
        GrepGroup[] grepGroupArray = this.workItem.getGroups();
        int n = grepGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            GrepGroup group = grepGroupArray[n2];
            String name = group.getName();
            if (name != null) {
                if (names.contains(name = name.toLowerCase())) {
                    duplicates = true;
                    break;
                }
                names.add(name);
            }
            ++n2;
        }
        if (duplicates != this.duplicateGroupNames) {
            this.duplicateGroupNames = duplicates;
            this.refresh();
        }
    }

    private void refresh() {
        this.textName.setText(this.item == null || this.item.getName() == null ? "" : this.item.getName());
        this.textQuickExpression.setText(this.item == null || this.item.getQuickGrepExpression() == null ? "" : this.item.getQuickGrepExpression());
        this.textExpression.setText(this.item == null || this.item.getGrepExpression() == null ? "" : this.item.getGrepExpression());
        this.textUnlessExpression.setText(this.item == null || this.item.getUnlessGrepExpression() == null ? "" : this.item.getUnlessGrepExpression());
        this.textRewrite.setText(this.item == null || this.item.getRewriteExpression() == null ? "" : this.item.getRewriteExpression());
        this.cbActiveByDefault.setSelection(this.workItem.isDefaultEnabled());
        this.cbFilterDefault.setSelection(this.workItem.isDefaultFilter());
        this.cbStatisticsDefault.setSelection(this.workItem.isDefaultStatistics());
        this.cbNotificationsDefault.setSelection(this.workItem.isDefaultNotifications());
        this.cbCaseSensitive.setSelection(!this.workItem.isCaseInsensitive());
        this.cbRemoveOriginalStyle.setSelection(this.workItem.isRemoveOriginalStyle());
        this.stPreview.setText(this.previewText == null ? "" : this.previewText);
        this.cbPopupNotification.setSelection(this.workItem.isPopupNotification());
        this.textNotificationTitle.setText(this.workItem.getNotificationTitle() == null ? "" : this.workItem.getNotificationTitle());
        this.textNotificationMessage.setText(this.workItem.getNotificationMessage() == null ? "" : this.workItem.getNotificationMessage());
        this.cbSoundNotification.setSelection(this.workItem.getSoundNotificationPath() != null && this.workItem.getSoundNotificationPath().length() > 0);
        this.textSoundNotification.setText(this.workItem.getSoundNotificationPath() == null ? "" : this.workItem.getSoundNotificationPath());
        this.textSoundNotification.setEnabled(this.cbSoundNotification.getSelection());
        this.btnPlaySoundNotification.setEnabled(this.cbSoundNotification.getSelection());
        this.pickerNotificationLink.setLink(this.item == null ? null : this.item.getNotificationLink());
        this.pickerAutostartLink.setLink(this.item == null ? null : this.item.getAutostartLink());
        this.textStatisticsCountLabel.setText(this.item == null || this.item.getStatisticsCountLabel() == null ? "" : this.item.getStatisticsCountLabel());
        this.textStatisticsValueLabel.setText(this.item == null || this.item.getStatisticsValueLabel() == null ? "" : this.item.getStatisticsValueLabel());
        this.textStatisticsValuePattern.setText(this.item == null || this.item.getStatisticsValuePattern() == null ? "" : this.item.getStatisticsValuePattern());
        this.viewerLogLevel.setSelection((ISelection)new StructuredSelection((Object)this.item.getErrorLogLevel()));
        this.textLogMessage.setText(this.item == null || this.item.getErrorLogMessage() == null ? "" : this.item.getErrorLogMessage());
        this.textExpression.selectAll();
        this.textUnlessExpression.selectAll();
        this.getButton(0).setEnabled(!this.duplicateGroupNames);
    }

    public boolean close() {
        if (this.getReturnCode() != 0) {
            this.item.getRoot().setStyles(this.backupStyles);
        }
        return super.close();
    }

    protected void okPressed() {
        Pattern pattern = Pattern.compile(this.workItem.getGrepExpression());
        int groups = pattern.matcher("").groupCount();
        this.workItem.setGroups(Arrays.copyOf(this.workItem.getGroups(), groups + 1));
        this.item.copyFrom(this.workItem, true);
        super.okPressed();
    }

    public void setPreviewText(String text) {
        this.previewText = text;
        if (this.stPreview != null) {
            this.stPreview.setText(text);
        }
    }

    public String getPreviewText() {
        return this.previewText;
    }

    protected void refreshPreview() {
        this.grepLineStyleListener.setItems(Collections.singleton(this.workItem));
        this.stPreview.redraw();
    }

    @Override
    public void onNewStyle(StylesPanel panel, GrepStyle style) {
        this.doAssignStyle(style);
    }

    @Override
    public void onStyleDeleted(StylesPanel panel, GrepStyle style) {
    }

    @Override
    public void onStyleChanged(StylesPanel panel, GrepStyle style) {
        this.viewerStyleAssignments.refresh();
        this.refreshPreview();
    }

    @Override
    public void onStyleSelected(StylesPanel panel, GrepStyle style) {
    }

    @Override
    public boolean onStyleDoubleClicked(StylesPanel panel, GrepStyle style) {
        this.doAssignStyle(style);
        return true;
    }

    protected void updatePreviewToolTip() {
        Activator activator = Activator.getDefault();
        int styleLength = activator.getStyleMatchLength();
        int filterLength = activator.getFilterMatchLength();
        this.stPreview.setToolTipText(MessageFormat.format(LineLengthChecker.MESSAGE_PREVIEW_TOOLTIP, styleLength, filterLength));
    }

    protected void updateLengthWarning() {
        boolean warning;
        boolean bl = warning = this.lengthChecker.isStyleExceeded() || this.lengthChecker.isFilterExceeded();
        if (warning) {
            StringBuilder sb = new StringBuilder();
            if (this.lengthChecker.isStyleExceeded()) {
                sb.append(MessageFormat.format(LineLengthChecker.MESSAGE_STYLE_LENGTH_LIMIT_EXCEEDED, this.lengthChecker.getStyleMatchLength()));
            }
            if (this.lengthChecker.isFilterExceeded()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(MessageFormat.format(LineLengthChecker.MESSAGE_FILTER_LENGTH_LIMIT_EXCEEDED, this.lengthChecker.getFilterMatchLength()));
            }
            this.labelLengthWarning.setToolTipText(sb == null ? null : sb.toString());
        }
        this.labelLengthWarning.setVisible(warning);
    }
}

