/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.editor;

import java.util.Collection;
import org.eclipse.jface.preference.IPreferenceStore;
import org.sweetlemonade.eclipse.json.model.JsonArray;
import org.sweetlemonade.eclipse.json.model.JsonElement;
import org.sweetlemonade.eclipse.json.model.JsonObject;
import org.sweetlemonade.eclipse.json.model.JsonPrimitive;

public class JsonFormatter {
    private final JsonElement mElement;
    private boolean mWrapArray;
    private boolean mWrapObject;
    private boolean mArrayBracketsNewLine;
    private boolean mObjectBracketsNewLine;
    private boolean mAfterComma;
    private boolean mAfterColon;
    private boolean mBeforeColon;
    private boolean mBlankLineAfterComplex;
    private boolean mSpaceAfterObjectOpen;
    private boolean mSpaceBeforeObjectClose;
    private boolean mSpaceAfterArrayOpen;
    private boolean mSpaceBeforeArrayClose;
    private boolean mSpaces;
    private int mTabSize;
    private final IPreferenceStore mStore;

    public JsonFormatter(JsonElement element, IPreferenceStore store) {
        this.mElement = element;
        this.mStore = store;
    }

    public String format(int initialCapacity) {
        this.mWrapArray = this.mStore.getBoolean("wrapArray");
        this.mWrapObject = this.mStore.getBoolean("wrapObject");
        this.mArrayBracketsNewLine = this.mStore.getBoolean("arrayBrackets");
        this.mObjectBracketsNewLine = this.mStore.getBoolean("objectBrackets");
        this.mAfterComma = this.mStore.getBoolean("spaceAfterComma");
        this.mAfterColon = this.mStore.getBoolean("spaceAfterColon");
        this.mBeforeColon = this.mStore.getBoolean("spaceBeforeColon");
        this.mBlankLineAfterComplex = this.mStore.getBoolean("newLineAfterComplex");
        this.mSpaceAfterObjectOpen = this.mStore.getBoolean("spaceAfterObjectOpen");
        this.mSpaceBeforeObjectClose = this.mStore.getBoolean("spaceAfterObjectClose");
        this.mSpaceAfterArrayOpen = this.mStore.getBoolean("spaceAfterArrayOpen");
        this.mSpaceBeforeArrayClose = this.mStore.getBoolean("spaceAfterArrayClose");
        this.mSpaces = this.mStore.getBoolean("spacesForTabs");
        this.mTabSize = this.mStore.getInt("tabWidth");
        StringBuilder builder = new StringBuilder(initialCapacity);
        this.toFormatedString(this.mElement, builder, 0);
        return builder.toString();
    }

    private void toFormatedString(JsonElement element, StringBuilder builder, int indent) {
        if (element.isArray()) {
            JsonArray array = (JsonArray)element;
            builder.append('[');
            if (this.mSpaceAfterArrayOpen) {
                builder.append(' ');
            }
            if (this.mWrapArray) {
                builder.append('\n');
                this.indent(builder, indent + 1);
            }
            boolean first = true;
            boolean wasComplex = false;
            for (JsonElement jsonElement : array) {
                if (!first) {
                    builder.append(',');
                    if (this.mAfterComma) {
                        builder.append(' ');
                    }
                    if (wasComplex && this.mBlankLineAfterComplex && this.mWrapArray) {
                        builder.append('\n');
                    }
                    if (this.mWrapArray) {
                        builder.append('\n');
                        this.indent(builder, indent + 1);
                    }
                }
                wasComplex = false;
                first = false;
                this.toFormatedString(jsonElement, builder, indent + 1);
                if (!jsonElement.isObject() && !jsonElement.isArray()) continue;
                wasComplex = true;
            }
            if (this.mWrapArray) {
                builder.append('\n');
                this.indent(builder, indent);
            }
            if (this.mSpaceBeforeArrayClose) {
                builder.append(' ');
            }
            builder.append(']');
        } else if (element.isObject()) {
            JsonObject object = (JsonObject)element;
            builder.append('{');
            if (this.mSpaceAfterObjectOpen) {
                builder.append(' ');
            }
            if (this.mWrapObject) {
                builder.append('\n');
                this.indent(builder, indent + 1);
            }
            Collection<JsonObject.Key> keySet = object.keys();
            boolean first = true;
            boolean wasComplex = true;
            for (JsonObject.Key key : keySet) {
                JsonElement jsonElement;
                if (!first) {
                    builder.append(',');
                    if (this.mAfterComma) {
                        builder.append(' ');
                    }
                    if (wasComplex && this.mBlankLineAfterComplex && this.mWrapObject) {
                        builder.append('\n');
                    }
                    if (this.mWrapObject) {
                        builder.append('\n');
                        this.indent(builder, indent + 1);
                    }
                }
                wasComplex = false;
                first = false;
                builder.append('\"');
                builder.append(key);
                builder.append('\"');
                if (this.mBeforeColon) {
                    builder.append(' ');
                }
                builder.append(':');
                if (this.mAfterColon) {
                    builder.append(' ');
                }
                if ((jsonElement = object.get(key)).isArray() && this.mArrayBracketsNewLine) {
                    builder.append('\n');
                    this.indent(builder, indent + 1);
                } else if (jsonElement.isObject() && this.mObjectBracketsNewLine) {
                    builder.append('\n');
                    this.indent(builder, indent + 1);
                }
                this.toFormatedString(jsonElement, builder, indent + 1);
                if (!jsonElement.isArray() && !jsonElement.isObject()) continue;
                wasComplex = true;
            }
            if (this.mWrapObject) {
                builder.append('\n');
                this.indent(builder, indent);
            }
            if (this.mSpaceBeforeObjectClose) {
                builder.append(' ');
            }
            builder.append('}');
        } else {
            JsonPrimitive primitive = (JsonPrimitive)element;
            if (primitive.getType() == JsonPrimitive.PrimitiveType.STRING) {
                builder.append('\"');
            }
            builder.append(primitive.getValue());
            if (primitive.getType() == JsonPrimitive.PrimitiveType.STRING) {
                builder.append('\"');
            }
        }
    }

    private void indent(StringBuilder builder, int indent) {
        if (this.mSpaces) {
            int i = 0;
            while (i < indent * this.mTabSize) {
                builder.append(' ');
                ++i;
            }
        } else {
            int i = 0;
            while (i < indent) {
                builder.append('\t');
                ++i;
            }
        }
    }
}

