/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.model.antlr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonErrorNode;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.sweetlemonade.eclipse.json.JsonPlugin;
import org.sweetlemonade.eclipse.json.model.JsonArray;
import org.sweetlemonade.eclipse.json.model.JsonElement;
import org.sweetlemonade.eclipse.json.model.JsonObject;
import org.sweetlemonade.eclipse.json.model.JsonPrimitive;
import org.sweetlemonade.eclipse.json.model.antlr.DocumentCharStream;
import org.sweetlemonade.eclipse.json.model.antlr.IllegalParseStateException;
import org.sweetlemonade.eclipse.json.model.antlr.JsonLexer;
import org.sweetlemonade.eclipse.json.model.antlr.JsonParser;

public class ParseUtils {
    private static ParseError fillError(RecognitionException e, BaseRecognizer recognizer, IDocument document) {
        ParseError error = new ParseError();
        error.error = e;
        error.line = e.line;
        CommonToken token = (CommonToken)e.token;
        if (token != null) {
            error.start = token.getStartIndex();
            error.stop = token.getStopIndex();
            if (error.stop == error.start) {
                ++error.stop;
            }
        } else {
            error.start = e.index;
        }
        error.text = recognizer.getErrorMessage(e, recognizer.getTokenNames());
        return error;
    }

    public static ParseResult parse(final IDocument document) throws IllegalParseStateException {
        IPreferenceStore store = JsonPlugin.getDefault().getPreferenceStore();
        final boolean validate = store.getBoolean("validate");
        int maxErrorsPrefs = store.getInt("maxError");
        final int maxErrors = maxErrorsPrefs == 0 ? Integer.MAX_VALUE : maxErrorsPrefs;
        final ParseResult result = new ParseResult();
        result.currErrors = 0;
        final ArrayList<ParseError> errors = new ArrayList<ParseError>();
        result.errors = errors;
        final DocumentCharStream charStream = new DocumentCharStream(document);
        JsonLexer lexer = new JsonLexer(charStream){

            public void reportError(RecognitionException e) {
                if (!validate || result.currErrors >= maxErrors) {
                    charStream.seek(charStream.size() - 1);
                } else {
                    ParseResult parseResult = result;
                    parseResult.currErrors = parseResult.currErrors + 1;
                    super.reportError(e);
                    errors.add(ParseUtils.fillError(e, (BaseRecognizer)this, document));
                }
            }
        };
        final CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        JsonParser parser = new JsonParser((TokenStream)tokenStream){

            public void reportError(RecognitionException e) {
                if (!validate || result.currErrors >= maxErrors) {
                    tokenStream.seek(tokenStream.size() - 1);
                } else {
                    ParseResult parseResult = result;
                    parseResult.currErrors = parseResult.currErrors + 1;
                    super.reportError(e);
                    errors.add(ParseUtils.fillError(e, (BaseRecognizer)this, document));
                }
            }
        };
        result.tree = parser.jsonText().getTree();
        return result;
    }

    public static JsonElement tree(Object t) {
        return ParseUtils.element((CommonTree)t, null);
    }

    private static JsonElement element(CommonTree tree, JsonElement parent) {
        if (tree instanceof CommonErrorNode) {
            return null;
        }
        Token token = tree.getToken();
        if (token == null) {
            tree.getClass();
        }
        int type = token.getType();
        String text = token.getText();
        JsonPrimitive.PrimitiveType type2 = null;
        switch (type) {
            case 12: {
                return ParseUtils.object(tree, parent);
            }
            case 4: {
                return ParseUtils.array(tree, parent);
            }
            case 7: 
            case 14: {
                type2 = JsonPrimitive.PrimitiveType.BOOLEAN;
                break;
            }
            case 10: {
                type2 = JsonPrimitive.PrimitiveType.NULL;
                break;
            }
            case 11: {
                type2 = JsonPrimitive.PrimitiveType.NUMBER;
                break;
            }
            case 13: {
                text = ParseUtils.dequote(text);
                type2 = JsonPrimitive.PrimitiveType.STRING;
                break;
            }
            default: {
                return null;
            }
        }
        return ParseUtils.fill(new JsonPrimitive(parent, text, type2), tree);
    }

    private static String dequote(String text) {
        return text.substring(0, text.length());
    }

    private static JsonArray array(CommonTree t, JsonElement parent) {
        JsonArray array = ParseUtils.fill(new JsonArray(parent), t);
        List children = t.getChildren();
        for (Object object : children) {
            CommonTree child = (CommonTree)object;
            JsonElement element = ParseUtils.element(child, array);
            if (element == null) continue;
            array.add(element);
        }
        return array;
    }

    public static JsonObject object(CommonTree t, JsonElement parent) {
        JsonObject object = ParseUtils.fill(new JsonObject(parent), t);
        List children = t.getChildren();
        for (Object object2 : children) {
            CommonTree child = (CommonTree)object2;
            if (child.getType() != 13) continue;
            CommonToken token = (CommonToken)child.getToken();
            String text = token.getText();
            text = ParseUtils.dequote(text);
            JsonObject.Key key = new JsonObject.Key(text);
            key.setStart(token.getStartIndex());
            key.setStop(token.getStopIndex() + 1);
            key.setLine(token.getLine());
            JsonElement element = ParseUtils.element((CommonTree)child.getChild(0), object);
            if (element == null) continue;
            object.put(key, element);
        }
        return object;
    }

    private static <T extends JsonElement> T fill(T element, CommonTree tree) {
        CommonToken startToken;
        CommonToken lastToken = startToken = (CommonToken)tree.getToken();
        int childCount = tree.getChildCount();
        if (childCount > 0) {
            lastToken = (CommonToken)((CommonTree)tree.getChild(childCount - 1)).getToken();
        }
        element.setStart(startToken.getStartIndex());
        element.setEnd(lastToken.getStopIndex() + 1);
        element.setStartLine(startToken.getLine());
        element.setEndLine(lastToken.getLine());
        return element;
    }

    public static class ParseError {
        public RecognitionException error;
        public String text;
        public int line;
        public int start = -1;
        public int stop = -1;
    }

    public static class ParseResult {
        public Object tree;
        public Collection<ParseError> errors;
        private int currErrors;
    }
}

