/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.outline;

import java.util.Collection;
import org.sweetlemonade.eclipse.json.model.JsonElement;

public class Checker {
    public static JsonElement find(String text, JsonElement jsonElement) {
        String key = jsonElement.getKey();
        if (Checker.include(key, text)) {
            return jsonElement;
        }
        if (jsonElement.isPrimitive()) {
            if (Checker.checkPrimitive(text, jsonElement)) {
                return jsonElement;
            }
        } else if (jsonElement.hasChilds()) {
            Collection<JsonElement> childs = jsonElement.getChilds();
            for (JsonElement child : childs) {
                JsonElement find = Checker.find(text, child);
                if (find == null) continue;
                return find;
            }
        }
        return null;
    }

    public static boolean check(String text, JsonElement jsonElement) {
        return Checker.find(text, jsonElement) != null;
    }

    private static boolean checkPrimitive(String text, JsonElement jsonElement) {
        return Checker.include(jsonElement.asPrimitive().getValue(), text);
    }

    private static boolean include(String original, String filter) {
        if (original == null) {
            return false;
        }
        return original.toLowerCase().contains(filter);
    }
}

