/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.outline;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.TextStyle;
import org.sweetlemonade.eclipse.json.JsonPlugin;
import org.sweetlemonade.eclipse.json.model.JsonElement;
import org.sweetlemonade.eclipse.json.model.JsonPrimitive;
import org.sweetlemonade.eclipse.json.preference.JsonPreferences;
import org.sweetlemonade.eclipse.json.preference.JsonPreferencesInitializer;

public class JsonLabelProvider
extends ColumnLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public String getText(Object element) {
        return this.getStyledText(element).toString();
    }

    public StyledString getStyledText(Object element) {
        int index;
        JsonElement jsonElement = (JsonElement)element;
        StyledString string = new StyledString();
        String key = jsonElement.getKey();
        if (key != null && key.length() > 0) {
            string.append(key, (StyledString.Styler)new SimpleStyler(JsonPreferencesInitializer.TokenType.KEYS));
            string.append(" : ", (StyledString.Styler)new SimpleStyler(JsonPreferencesInitializer.TokenType.DEFAULT));
        }
        if ((index = jsonElement.getIndex()) != -1) {
            string.append("[" + index + "] : ", (StyledString.Styler)new SimpleStyler(JsonPreferencesInitializer.TokenType.DEFAULT));
        }
        if (jsonElement.isObject()) {
            string.append("{}", (StyledString.Styler)new SimpleStyler(JsonPreferencesInitializer.TokenType.OBJECT_BRACKETS));
        } else if (jsonElement.isArray()) {
            string.append("[" + jsonElement.asArray().size() + "]", (StyledString.Styler)new SimpleStyler(JsonPreferencesInitializer.TokenType.OBJECT_BRACKETS));
        } else if (jsonElement.isPrimitive()) {
            JsonPrimitive primitive = (JsonPrimitive)jsonElement;
            JsonPrimitive.PrimitiveType type = primitive.getType();
            SimpleStyler styler = null;
            switch (type) {
                case NULL: {
                    styler = new SimpleStyler(JsonPreferencesInitializer.TokenType.NULL);
                    break;
                }
                case BOOLEAN: {
                    styler = new SimpleStyler(JsonPreferencesInitializer.TokenType.BOOLEANS);
                    break;
                }
                case NUMBER: {
                    styler = new SimpleStyler(JsonPreferencesInitializer.TokenType.NUMBERS);
                    break;
                }
                case STRING: {
                    styler = new SimpleStyler(JsonPreferencesInitializer.TokenType.STRINGS);
                }
            }
            string.append(primitive.getValue(), (StyledString.Styler)styler);
        }
        return string;
    }

    private static class SimpleStyler
    extends StyledString.Styler {
        private final JsonPreferencesInitializer.TokenType mType;

        public SimpleStyler(JsonPreferencesInitializer.TokenType type) {
            this.mType = type;
        }

        public void applyStyles(TextStyle textStyle) {
            JsonPreferences preferences = JsonPlugin.getPreferences();
            int style = preferences.getStyle(this.mType);
            if (textStyle instanceof StyleRange) {
                StyleRange range = (StyleRange)textStyle;
                range.fontStyle = JsonPreferences.extractBoldItalic(style);
            }
            textStyle.foreground = preferences.getColor(this.mType);
            textStyle.underline = JsonPreferences.isUnderline(style);
            textStyle.strikeout = JsonPreferences.isStrike(style);
        }
    }
}

