/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.outline;

import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.sweetlemonade.eclipse.json.SelectionsFinder;
import org.sweetlemonade.eclipse.json.editor.JsonEditor;
import org.sweetlemonade.eclipse.json.model.JsonElement;
import org.sweetlemonade.eclipse.json.outline.JsonLabelProvider;
import org.sweetlemonade.eclipse.json.outline.JsonOutlineContentProvider;
import org.sweetlemonade.eclipse.json.outline.JsonTreeExpander;

public class JsonOutlinePage
extends ContentOutlinePage
implements ISelectionListener {
    private final JsonEditor mEditor;
    private JsonTreeExpander mExpander;
    private JsonElement mElement;
    private JsonElement mSelectedElement;
    private final SelectionsFinder mFinder = new SelectionsFinder();

    public JsonOutlinePage(JsonEditor editor) {
        this.mEditor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new JsonOutlineContentProvider());
        DelegatingStyledCellLabelProvider delegatingStyledCellLabelProvider = new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new JsonLabelProvider());
        viewer.setLabelProvider((IBaseLabelProvider)delegatingStyledCellLabelProvider);
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
        this.mExpander = new JsonTreeExpander(viewer);
        if (this.mElement != null) {
            this.mExpander.update(this.mElement);
        }
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.mEditor.resetHighlightRange();
        } else {
            JsonElement jsonElement = (JsonElement)((IStructuredSelection)selection).getFirstElement();
            if (jsonElement == this.mSelectedElement) {
                this.mSelectedElement = null;
                return;
            }
            try {
                this.mEditor.selectAndReveal(jsonElement.getStart(), jsonElement.getLength());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.mEditor.resetHighlightRange();
            }
        }
    }

    public void setInput(JsonElement element) {
        this.mElement = element;
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null) {
            this.mExpander.update(this.mElement);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof ITextSelection && part instanceof JsonEditor) {
            ITextSelection textSelection = (ITextSelection)selection;
            int start = textSelection.getOffset();
            this.mSelectedElement = this.mFinder.findSelectedScope(start, this.mElement);
            if (this.mSelectedElement != null) {
                TreeViewer treeViewer = this.getTreeViewer();
                TreeSelection treeSelection = new TreeSelection(new TreePath(new Object[]{this.mSelectedElement}));
                treeViewer.reveal((Object)this.mSelectedElement);
                treeViewer.setSelection((ISelection)treeSelection);
            }
        }
    }
}

