/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.preference.colors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.sweetlemonade.eclipse.json.ColorManager;
import org.sweetlemonade.eclipse.json.JsonPlugin;
import org.sweetlemonade.eclipse.json.preference.JsonPreferences;
import org.sweetlemonade.eclipse.json.preference.JsonPreferencesInitializer;

public class TextHighlighter {
    private static final String TEXT = "\"key\" : \"string\",\n\"key\" : -12.0e+13,\n\"key\" : true,\n\"key\" : null,\n\"key\" : {\"key\" : \"string\"},\n\"key\" : [1, 2, 3]";
    private final TextViewer mViewer;
    private final IPreferenceStore mStore;
    private final ColorManager mManager;

    public TextHighlighter(TextViewer viewer, IPreferenceStore store) {
        this.mStore = store;
        this.mManager = JsonPlugin.getColorManager();
        this.mViewer = viewer;
        this.mViewer.setInput((Object)new Document(TEXT));
    }

    public void update() {
        JsonPreferencesInitializer.TokenType[] types = JsonPreferencesInitializer.TokenType.values();
        this.mViewer.setTextColor(this.mManager.getColor(JsonPreferencesInitializer.TokenType.DEFAULT.getColor(this.mStore)));
        JsonPreferencesInitializer.TokenType[] tokenTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            JsonPreferencesInitializer.TokenType type = tokenTypeArray[n2];
            Color color = this.mManager.getColor(type.getColor(this.mStore));
            int style = type.getStyle(this.mStore);
            List<Integer> inds = null;
            switch (type) {
                case KEYS: {
                    inds = this.calcInds("\"key\"");
                    break;
                }
                case ARRAY_BRACKETS: {
                    inds = this.calcInds("[", "]");
                    break;
                }
                case BOOLEANS: {
                    inds = this.calcInds("true", "false");
                    break;
                }
                case NULL: {
                    inds = this.calcInds("null");
                    break;
                }
                case NUMBERS: {
                    inds = this.calcInds("-12.0e+13", "1", "2", "3");
                    break;
                }
                case OBJECT_BRACKETS: {
                    inds = this.calcInds("{", "}");
                    break;
                }
                case STRINGS: {
                    inds = this.calcInds("\"string\"");
                }
            }
            if (inds != null) {
                int i = 0;
                while (i < inds.size()) {
                    StyleRange textStyle = new StyleRange(inds.get(i).intValue(), inds.get(i + 1).intValue(), color, null);
                    textStyle.fontStyle = JsonPreferences.extractBoldItalic(style);
                    textStyle.underline = JsonPreferences.isUnderline(style);
                    textStyle.strikeout = JsonPreferences.isStrike(style);
                    this.mViewer.getTextWidget().setStyleRange(textStyle);
                    i += 2;
                }
            }
            ++n2;
        }
    }

    private List<Integer> calcInds(String ... str) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        String[] stringArray = str;
        int n = str.length;
        int n2 = 0;
        while (n2 < n) {
            int of;
            String string = stringArray[n2];
            int start = 0;
            while ((of = TEXT.indexOf(string, start)) != -1) {
                list.add(of);
                list.add(string.length());
                start = of + string.length();
            }
            ++n2;
        }
        return list;
    }
}

