/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.internal.IRepositoryCommit;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.DiffDocument;
import org.eclipse.egit.ui.internal.commit.DiffEditorInput;
import org.eclipse.egit.ui.internal.commit.DiffEditorOutlinePage;
import org.eclipse.egit.ui.internal.commit.DiffRegionFormatter;
import org.eclipse.egit.ui.internal.commit.DiffViewer;
import org.eclipse.egit.ui.internal.commit.OldNewLogicalLineNumberRulerColumn;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class DiffEditor
extends TextEditor
implements IShowInSource,
IShowInTargetList {
    public static final String EDITOR_ID = "org.eclipse.egit.ui.diffEditor";
    private static final String CONTEXT_ID = "org.eclipse.egit.ui.DiffViewer";
    private static final String ADD_ANNOTATION_TYPE = "org.eclipse.egit.ui.commitEditor.diffAdded";
    private static final String REMOVE_ANNOTATION_TYPE = "org.eclipse.egit.ui.commitEditor.diffRemoved";
    private static final String QUICK_OUTLINE_COMMAND = "org.eclipse.egit.ui.commit.DiffEditorQuickOutlineCommand";
    private DiffEditorOutlinePage outlinePage;
    private Annotation[] currentFoldingAnnotations;
    private Annotation[] currentOverviewAnnotations;
    private ThemePreferenceStore overviewStore;
    private DiffRegionFormatter.FileDiffRegion currentFileDiffRange;
    private OldNewLogicalLineNumberRulerColumn lineNumberColumn;
    private boolean plainLineNumbers = false;

    public DiffEditor() {
        this.setPartName(UIText.DiffEditor_Title);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IContentOutlinePage.class.equals(adapter)) {
            if (this.outlinePage == null) {
                this.outlinePage = this.createOutlinePage();
                this.outlinePage.setInput(this.getDocumentProvider().getDocument((Object)this.getEditorInput()));
                if (this.currentFileDiffRange != null) {
                    this.outlinePage.setSelection((ISelection)new StructuredSelection((Object)this.currentFileDiffRange));
                }
            }
            return adapter.cast((Object)this.outlinePage);
        }
        return (T)super.getAdapter(adapter);
    }

    private DiffEditorOutlinePage createOutlinePage() {
        DiffEditorOutlinePage page = new DiffEditorOutlinePage();
        page.addSelectionChangedListener(event -> this.setSelectionAndActivate(event.getSelection(), false));
        page.addOpenListener(event -> this.setSelectionAndActivate(event.getSelection(), true));
        return page;
    }

    protected DiffEditorOutlinePage getOutlinePage() {
        return this.outlinePage;
    }

    protected void setSelectionAndActivate(ISelection selection, boolean activate) {
        if (activate) {
            this.getSite().getPage().activate((IWorkbenchPart)this);
        }
        this.doSetSelection(selection);
    }

    public void dispose() {
        if (this.overviewStore != null) {
            this.overviewStore.dispose();
            this.overviewStore = null;
        }
        super.dispose();
    }

    public boolean isSaveAsAllowed() {
        IDocumentProvider provider = this.getDocumentProvider();
        return provider != null && provider.getDocument((Object)this.getEditorInput()) instanceof DiffDocument;
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        Shell shell = this.getSite().getShell();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(path);
        FileEditorInput newInput = new FileEditorInput(file);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation((IEditorInput)newInput){
            private final /* synthetic */ IEditorInput val$newInput;
            {
                this.val$newInput = iEditorInput;
            }

            public void execute(IProgressMonitor monitor) throws CoreException {
                IDocumentProvider provider = DiffEditor.this.getDocumentProvider();
                if (provider != null) {
                    provider.saveDocument(monitor, (Object)this.val$newInput, provider.getDocument((Object)DiffEditor.this.getEditorInput()), true);
                }
            }
        };
        try {
            ((IProgressService)this.getSite().getService(IProgressService.class)).busyCursorWhile((IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Activator.handleError(UIText.DiffEditor_SaveError, e.getCause(), true);
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        DiffViewer viewer = new DiffViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles, (IContextService)this.getSite().getService(IContextService.class)){

            @Override
            protected void setFont(Font font) {
            }
        };
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        ProjectionSupport projector = new ProjectionSupport((ProjectionViewer)viewer, this.getAnnotationAccess(), this.getSharedColors());
        projector.install();
        viewer.getTextWidget().addCaretListener(event -> {
            if (this.outlinePage != null) {
                DiffRegionFormatter.FileDiffRegion region = this.getFileDiffRange(event.caretOffset);
                if (region != null && !region.equals((Object)this.currentFileDiffRange)) {
                    this.currentFileDiffRange = region;
                    this.outlinePage.setSelection((ISelection)new StructuredSelection((Object)region));
                } else {
                    this.currentFileDiffRange = region;
                }
            }
        });
        return viewer;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{CONTEXT_ID});
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        this.lineNumberColumn = new OldNewLogicalLineNumberRulerColumn(this.plainLineNumbers);
        this.initializeLineNumberRulerColumn(this.lineNumberColumn);
        return this.lineNumberColumn;
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.overviewStore = new ThemePreferenceStore();
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{this.overviewStore, EditorsUI.getPreferenceStore()}));
        this.setDocumentProvider((IDocumentProvider)new DiffDocumentProvider());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new DiffViewer.Configuration(this.getPreferenceStore()){

            public IReconciler getReconciler(ISourceViewer sourceViewer) {
                return null;
            }
        });
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.currentFileDiffRange = null;
        if (input instanceof DiffEditorInput) {
            DiffEditorInput diffInput = (DiffEditorInput)input;
            if (diffInput.getDocument() != null) {
                DiffRegionFormatter.FileDiffRegion region;
                this.setFolding();
                this.currentFileDiffRange = region = this.getFileDiffRange(0);
                this.setOverviewAnnotations();
            } else {
                this.formatDiff(diffInput);
            }
        }
        if (this.outlinePage != null) {
            this.outlinePage.setInput(this.getDocumentProvider().getDocument((Object)input));
            if (this.currentFileDiffRange != null) {
                this.outlinePage.setSelection((ISelection)new StructuredSelection((Object)this.currentFileDiffRange));
            }
        }
    }

    protected void doSetSelection(ISelection selection) {
        Object selected;
        if (!selection.isEmpty() && selection instanceof StructuredSelection && (selected = ((StructuredSelection)selection).getFirstElement()) instanceof DiffRegionFormatter.FileDiffRegion) {
            DiffRegionFormatter.FileDiffRegion newRange = (DiffRegionFormatter.FileDiffRegion)((Object)selected);
            if (!newRange.equals((Object)this.currentFileDiffRange)) {
                this.currentFileDiffRange = newRange;
                this.selectAndReveal(newRange.getOffset(), 0);
                if (this.outlinePage != null) {
                    this.outlinePage.setSelection((ISelection)new StructuredSelection(selected));
                }
            }
            return;
        }
        super.doSetSelection(selection);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "group.copy", ITextEditorActionConstants.SELECT_ALL);
        menu.remove("ShiftRight");
        menu.remove("ShiftLeft");
        menu.appendToGroup("group.open", this.getAction(QUICK_OUTLINE_COMMAND));
    }

    protected void createActions() {
        super.createActions();
        this.createQuickOutlineAction();
    }

    private void createQuickOutlineAction() {
        Action outlineAction = new Action(UIText.DiffEditor_QuickOutlineAction){

            public void run() {
                DiffEditorOutlinePage.openQuickOutline(DiffEditor.this.getDocumentProvider().getDocument((Object)DiffEditor.this.getEditorInput()), DiffEditor.this.getEditorSite().getSelectionProvider());
            }
        };
        outlineAction.setActionDefinitionId(QUICK_OUTLINE_COMMAND);
        this.setAction(outlineAction.getActionDefinitionId(), (IAction)outlineAction);
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        IContributionItem showLineNumbers = menu.find("Linenumbers.Toggle");
        boolean isShowingLineNumbers = EditorsUI.getPreferenceStore().getBoolean("lineNumberRuler");
        if (showLineNumbers instanceof ActionContributionItem) {
            ((ActionContributionItem)showLineNumbers).getAction().setChecked(isShowingLineNumbers);
        }
        if (isShowingLineNumbers) {
            final boolean plain = this.lineNumberColumn.isPlain();
            Action togglePlain = new Action(UIText.DiffEditor_ToggleLineNumbers, 2){

                public void run() {
                    DiffEditor.this.plainLineNumbers = !plain;
                    DiffEditor.this.lineNumberColumn.setPlain(!plain);
                }
            };
            togglePlain.setChecked(!plain);
            menu.appendToGroup("rulers", (IAction)togglePlain);
        }
    }

    public ShowInContext getShowInContext() {
        IRepositoryCommit commit = (IRepositoryCommit)Adapters.adapt((Object)this.getEditorInput(), IRepositoryCommit.class);
        if (commit != null) {
            return new ShowInContext((Object)this.getEditorInput(), (ISelection)new StructuredSelection((Object)commit));
        }
        return null;
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.team.ui.GenericHistoryView", "org.eclipse.egit.ui.RepositoriesView"};
    }

    private void setFolding() {
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        if (document instanceof DiffDocument) {
            DiffRegionFormatter.FileDiffRegion[] regions = ((DiffDocument)document).getFileRegions();
            if (regions == null || regions.length <= 1) {
                viewer.disableProjection();
                return;
            }
            viewer.enableProjection();
            HashMap<ProjectionAnnotation, Position> newAnnotations = new HashMap<ProjectionAnnotation, Position>();
            DiffRegionFormatter.FileDiffRegion[] fileDiffRegionArray = regions;
            int n = regions.length;
            int n2 = 0;
            while (n2 < n) {
                DiffRegionFormatter.FileDiffRegion region = fileDiffRegionArray[n2];
                newAnnotations.put(new ProjectionAnnotation(), new Position(region.getOffset(), region.getLength()));
                ++n2;
            }
            viewer.getProjectionAnnotationModel().modifyAnnotations(this.currentFoldingAnnotations, newAnnotations, null);
            this.currentFoldingAnnotations = newAnnotations.keySet().toArray(new Annotation[0]);
        } else {
            viewer.disableProjection();
            this.currentFoldingAnnotations = null;
        }
    }

    private void setOverviewAnnotations() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        IDocument document = documentProvider.getDocument((Object)this.getEditorInput());
        if (!(document instanceof DiffDocument)) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null) {
            return;
        }
        DiffRegionFormatter.DiffRegion[] diffs = ((DiffDocument)document).getRegions();
        if (diffs == null || diffs.length == 0) {
            return;
        }
        HashMap<Annotation, Position> newAnnotations = new HashMap<Annotation, Position>();
        DiffRegionFormatter.DiffRegion[] diffRegionArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            DiffRegionFormatter.DiffRegion region = diffRegionArray[n2];
            if (DiffRegionFormatter.DiffRegion.Type.ADD.equals((Object)region.getType())) {
                newAnnotations.put(new Annotation(ADD_ANNOTATION_TYPE, true, null), new Position(region.getOffset(), region.getLength()));
            } else if (DiffRegionFormatter.DiffRegion.Type.REMOVE.equals((Object)region.getType())) {
                newAnnotations.put(new Annotation(REMOVE_ANNOTATION_TYPE, true, null), new Position(region.getOffset(), region.getLength()));
            }
            ++n2;
        }
        if (annotationModel instanceof IAnnotationModelExtension) {
            ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.currentOverviewAnnotations, newAnnotations);
        } else {
            if (this.currentOverviewAnnotations != null) {
                diffRegionArray = this.currentOverviewAnnotations;
                n = this.currentOverviewAnnotations.length;
                n2 = 0;
                while (n2 < n) {
                    DiffRegionFormatter.DiffRegion existing = diffRegionArray[n2];
                    annotationModel.removeAnnotation((Annotation)existing);
                    ++n2;
                }
            }
            for (Map.Entry entry : newAnnotations.entrySet()) {
                annotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
            }
        }
        this.currentOverviewAnnotations = newAnnotations.keySet().toArray(new Annotation[0]);
    }

    private DiffRegionFormatter.FileDiffRegion getFileDiffRange(int widgetOffset) {
        DiffViewer viewer = (DiffViewer)this.getSourceViewer();
        if (viewer != null) {
            int offset = viewer.widgetOffset2ModelOffset(widgetOffset);
            IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            if (document instanceof DiffDocument) {
                return ((DiffDocument)document).findFileRegion(offset);
            }
        }
        return null;
    }

    private void formatDiff(final @NonNull DiffEditorInput input) {
        IRepositoryCommit commit = input.getTip();
        IRepositoryCommit base = input.getBase();
        if (!(base != null || commit.getRevCommit().getParentCount() <= 1 || commit instanceof RepositoryCommit && ((RepositoryCommit)commit).isStash())) {
            input.setDocument((IDocument)new Document());
            this.setInput(input);
            return;
        }
        final DiffJob job = DiffEditor.getDiffer(commit, base);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    return;
                }
                new UIJob(UIText.DiffEditor_TaskUpdatingViewer){

                    public IStatus runInUIThread(IProgressMonitor uiMonitor) {
                        if (UIUtils.isUsable((Control)DiffEditor.this.getSourceViewer().getTextWidget())) {
                            input.setDocument((IDocument)job.getDocument());
                            DiffEditor.this.setInput(input);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        });
        job.schedule();
    }

    public static DiffJob getDiffer(final @NonNull IRepositoryCommit tip, final IRepositoryCommit base) {
        return new DiffJob(){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                FileDiff[] diffs = this.getDiffs((IProgressMonitor)progress.newChild(1));
                this.setDocument(this.formatDiffs(diffs, (IProgressMonitor)progress.newChild(1)));
                return Status.OK_STATUS;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private FileDiff[] getDiffs(IProgressMonitor monitor) {
                ArrayList<FileDiff> diffResult = new ArrayList<FileDiff>();
                if (base == null) {
                    if (tip instanceof RepositoryCommit) {
                        diffResult.addAll(Arrays.asList(((RepositoryCommit)tip).getDiffs()));
                        if (tip.getRevCommit().getParentCount() > 2) {
                            RevCommit untrackedCommit = tip.getRevCommit().getParent(2);
                            diffResult.addAll(Arrays.asList(new RepositoryCommit(tip.getRepository(), untrackedCommit).getDiffs()));
                        }
                    }
                } else {
                    Repository repository = tip.getRepository();
                    RevCommit tipCommit = tip.getRevCommit();
                    RevCommit baseCommit = base.getRevCommit();
                    FileDiff[] diffsResult = null;
                    try {
                        Throwable throwable = null;
                        Object var8_11 = null;
                        try {
                            RevWalk revWalk = new RevWalk(repository);
                            try {
                                try (TreeWalk treewalk = new TreeWalk(revWalk.getObjectReader());){
                                    treewalk.setRecursive(true);
                                    treewalk.setFilter(TreeFilter.ANY_DIFF);
                                    revWalk.parseBody((RevObject)tipCommit);
                                    revWalk.parseBody((RevObject)baseCommit);
                                    diffsResult = FileDiff.compute(repository, treewalk, tipCommit, new RevCommit[]{baseCommit}, monitor, TreeFilter.ALL);
                                }
                                if (revWalk == null) return diffsResult;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (revWalk == null) throw throwable;
                                revWalk.close();
                                throw throwable;
                            }
                            revWalk.close();
                            return diffsResult;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            } else {
                                if (throwable == throwable3) throw throwable;
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        return new FileDiff[0];
                    }
                }
                FileDiff[] result = diffResult.toArray(new FileDiff[0]);
                Arrays.sort(result, FileDiff.PATH_COMPARATOR);
                return result;
            }

            private DiffDocument formatDiffs(FileDiff[] diffs, IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)diffs.length);
                DiffDocument document = new DiffDocument();
                Throwable throwable = null;
                Object var6_7 = null;
                try (DiffRegionFormatter formatter = new DiffRegionFormatter((IDocument)document);){
                    FileDiff[] fileDiffArray = diffs;
                    int n = diffs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FileDiff diff = fileDiffArray[n2];
                        if (progress.isCanceled()) break;
                        progress.subTask(diff.getPath());
                        try {
                            formatter.write(diff);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        progress.worked(1);
                        ++n2;
                    }
                    document.connect(formatter);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return document;
            }

            public boolean belongsTo(Object family) {
                return JobFamilies.DIFF == family || super.belongsTo(family);
            }
        };
    }

    private static class DiffDocumentProvider
    extends FileDocumentProvider {
        private DiffDocumentProvider() {
        }

        public IStatus getStatus(Object element) {
            IRepositoryCommit commit;
            DiffEditorInput input;
            if (!(!(element instanceof DiffEditorInput) || (input = (DiffEditorInput)element).getBase() != null || (commit = input.getTip()).getRevCommit() == null || commit.getRevCommit().getParentCount() <= 1 || commit instanceof RepositoryCommit && ((RepositoryCommit)commit).isStash())) {
                return Activator.createErrorStatus(UIText.DiffEditor_WarningNoDiffForMerge);
            }
            return Status.OK_STATUS;
        }

        protected IDocument createDocument(Object element) throws CoreException {
            IDocument document;
            if (element instanceof DiffEditorInput && (document = ((DiffEditorInput)element).getDocument()) != null) {
                return document;
            }
            return new Document();
        }

        protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
            return new AnnotationModel();
        }

        protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
            return null;
        }
    }

    public static abstract class DiffJob
    extends Job {
        private DiffDocument document;

        protected DiffJob() {
            super(UIText.DiffEditor_TaskGeneratingDiff);
        }

        public DiffDocument getDocument() {
            return this.document;
        }

        public void setDocument(DiffDocument document) {
            this.document = document;
        }
    }

    private static class ThemePreferenceStore
    extends PreferenceStore {
        private static final String ADD_ANNOTATION_COLOR_PREFERENCE = "org.eclipse.egit.ui.commitEditor.diffAddedColor";
        private static final String REMOVE_ANNOTATION_COLOR_PREFERENCE = "org.eclipse.egit.ui.commitEditor.diffRemovedColor";
        private final IPropertyChangeListener listener = event -> {
            String property = event.getProperty();
            if ("CHANGE_CURRENT_THEME".equals(property)) {
                this.setColorRegistry();
                this.initColors();
            } else if ("org.eclipse.egit.ui.DiffAddBackgroundColor".equals(property) || "org.eclipse.egit.ui.DiffRemoveBackgroundColor".equals(property)) {
                this.initColors();
            }
        };
        private ColorRegistry currentColors;

        public ThemePreferenceStore() {
            this.setColorRegistry();
            this.initColors();
            PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.listener);
        }

        private void setColorRegistry() {
            if (this.currentColors != null) {
                this.currentColors.removeListener(this.listener);
            }
            this.currentColors = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
            this.currentColors.addListener(this.listener);
        }

        private void initColors() {
            RGB rgb = this.adjust(this.currentColors.getRGB("org.eclipse.egit.ui.DiffAddBackgroundColor"), 4.0);
            this.setValue(ADD_ANNOTATION_COLOR_PREFERENCE, StringConverter.asString((RGB)rgb));
            rgb = this.adjust(this.currentColors.getRGB("org.eclipse.egit.ui.DiffRemoveBackgroundColor"), 4.0);
            this.setValue(REMOVE_ANNOTATION_COLOR_PREFERENCE, StringConverter.asString((RGB)rgb));
        }

        private RGB adjust(RGB rgb, double saturation) {
            float[] hsb = rgb.getHSB();
            return new RGB(hsb[0], (float)Math.min((double)hsb[1] * saturation, 1.0), (double)hsb[2] < 0.5 ? hsb[2] * 2.0f : hsb[2]);
        }

        public void dispose() {
            PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.listener);
            if (this.currentColors != null) {
                this.currentColors.removeListener(this.listener);
                this.currentColors = null;
            }
        }
    }
}

