/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.editor;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.services.IDisposable;
import org.sweetlemonade.eclipse.json.SelectionsFinder;
import org.sweetlemonade.eclipse.json.editor.JsonEditor;
import org.sweetlemonade.eclipse.json.model.JsonArray;
import org.sweetlemonade.eclipse.json.model.JsonElement;
import org.sweetlemonade.eclipse.json.model.JsonObject;

public class JsonAnnotationer
implements ISelectionListener,
IDisposable {
    private final ProjectionAnnotationModel mProjectionModel;
    private JsonElement mElement;
    private final JsonEditor mEditor;
    private final SelectionsFinder mFinder = new SelectionsFinder();
    private Map<JsonElement, ProjectionAnnotation> mAnnos;
    private final Map<ProjectionAnnotation, Boolean> mState = new IdentityHashMap<ProjectionAnnotation, Boolean>();
    private final ISourceViewer mViewer;

    public JsonAnnotationer(ProjectionAnnotationModel projectionModel, JsonEditor editor, ISourceViewer viewer) {
        this.mProjectionModel = projectionModel;
        this.mEditor = editor;
        this.mViewer = viewer;
        this.mEditor.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
    }

    public void store() {
        if (this.mAnnos == null) {
            return;
        }
        Collection<ProjectionAnnotation> values = this.mAnnos.values();
        this.mState.clear();
        for (ProjectionAnnotation projectionAnnotation : values) {
            this.mState.put(projectionAnnotation, projectionAnnotation.isCollapsed());
        }
    }

    public void update(int start) {
        if (this.mElement != null) {
            JsonElement selected = this.mFinder.findSelectedScope(start, this.mElement);
            if (selected == null) {
                this.mViewer.setRangeIndicator(null);
                return;
            }
            if (selected.isPrimitive()) {
                selected = selected.getParent();
            }
            this.mViewer.setRangeIndication(selected.getStart(), selected.getLength(), false);
        }
    }

    public void update(JsonElement element) {
        if (element != null) {
            IdentityHashMap<JsonElement, ProjectionAnnotation> annos = new IdentityHashMap<JsonElement, ProjectionAnnotation>();
            IdentityHashMap<ProjectionAnnotation, Position> target = new IdentityHashMap<ProjectionAnnotation, Position>();
            this.collect(element, target, annos);
            if (this.mElement == null) {
                this.mProjectionModel.modifyAnnotations(null, target, null);
            } else {
                if (!this.mState.isEmpty()) {
                    Collection<ProjectionAnnotation> values = this.mAnnos.values();
                    for (ProjectionAnnotation projectionAnnotation : values) {
                        if (this.mState.get(projectionAnnotation).booleanValue()) {
                            projectionAnnotation.markCollapsed();
                            continue;
                        }
                        projectionAnnotation.markExpanded();
                    }
                    this.mState.clear();
                }
                this.check(this.mElement, element, this.mAnnos, annos);
                this.mProjectionModel.modifyAnnotations((Annotation[])this.mAnnos.values().toArray(new ProjectionAnnotation[this.mAnnos.size()]), target, null);
            }
            this.mAnnos = annos;
            this.mElement = element;
        }
    }

    private boolean check(JsonElement elementWas, JsonElement elementNow, Map<JsonElement, ProjectionAnnotation> oldAnnos, Map<JsonElement, ProjectionAnnotation> newAnnos) {
        boolean result;
        block10: {
            block9: {
                if (elementWas.isPrimitive() || elementNow.isPrimitive()) {
                    return false;
                }
                if (elementWas.getClass() != elementNow.getClass()) {
                    return false;
                }
                result = false;
                if (oldAnnos.containsKey(elementWas)) {
                    result = true;
                    ProjectionAnnotation annotation = oldAnnos.get(elementWas);
                    if (annotation.isCollapsed()) {
                        newAnnos.get(elementNow).markCollapsed();
                    } else {
                        newAnnos.get(elementNow).markExpanded();
                    }
                }
                if (!elementWas.hasChilds()) {
                    return result;
                }
                if (!elementWas.isArray()) break block9;
                JsonArray wasChilds = elementWas.asArray();
                JsonArray nowChilds = elementNow.asArray();
                int len = Math.min(wasChilds.size(), nowChilds.size());
                int i = 0;
                while (i < len) {
                    JsonElement was = (JsonElement)wasChilds.get(i);
                    JsonElement now = (JsonElement)nowChilds.get(i);
                    this.check(was, now, oldAnnos, newAnnos);
                    ++i;
                }
                break block10;
            }
            if (!elementWas.isObject()) break block10;
            JsonObject wasObj = elementWas.asObject();
            JsonObject nowObj = elementNow.asObject();
            Collection<JsonObject.Key> wasSet = wasObj.keys();
            Collection<JsonObject.Key> nowSet = nowObj.keys();
            block1: for (JsonObject.Key wasKey : wasSet) {
                for (JsonObject.Key nowKey : nowSet) {
                    if (nowKey.getValue().equals(wasKey.getValue()) && this.check(wasObj.get(wasKey), nowObj.get(nowKey), oldAnnos, newAnnos)) continue block1;
                }
            }
        }
        return result;
    }

    private void collect(JsonElement element, Map<ProjectionAnnotation, Position> target, IdentityHashMap<JsonElement, ProjectionAnnotation> annos) {
        if (element.isPrimitive()) {
            return;
        }
        if (element.getParent() != null && element.getStartLine() != element.getEndLine()) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            target.put(annotation, this.pos(element));
            annos.put(element, annotation);
        }
        Collection<JsonElement> childs = element.getChilds();
        for (JsonElement jsonElement : childs) {
            this.collect(jsonElement, target, annos);
        }
    }

    private Position pos(JsonElement element) {
        return new Position(element.getStart(), element.getLength());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part == this.mEditor && selection instanceof ITextSelection) {
            this.update(((ITextSelection)selection).getOffset());
        }
    }

    public void dispose() {
        this.mEditor.getSite().getPage().removeSelectionListener((ISelectionListener)this);
    }
}

