/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.editor;

import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.sweetlemonade.eclipse.json.editor.JsonContentFormatter;
import org.sweetlemonade.eclipse.json.editor.JsonEditor;
import org.sweetlemonade.eclipse.json.editor.JsonReconcileStrategy;
import org.sweetlemonade.eclipse.json.editor.JsonScanner;

public class JsonConfiguration
extends TextSourceViewerConfiguration {
    private JsonScanner mJsonScanner;
    private final JsonEditor mEditor;

    public JsonConfiguration(JsonEditor editor) {
        this.mEditor = editor;
    }

    private ITokenScanner getJsonScanner() {
        if (this.mJsonScanner == null) {
            this.mJsonScanner = new JsonScanner();
        }
        return this.mJsonScanner;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        return new JsonContentFormatter(this.mEditor);
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        return new MonoReconciler((IReconcilingStrategy)new JsonReconcileStrategy(this.mEditor), false);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this.getJsonScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{new DefaultIndentLineAutoEditStrategy()};
    }

    public void updatePreferences() {
        if (this.mJsonScanner != null) {
            this.mJsonScanner.updateRules();
        }
    }
}

