/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.editor;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class JsonNumberRule
implements IRule {
    private int mCount = 0;
    private ICharacterScanner mScanner;
    private final IToken mToken;
    private boolean mValid;

    public JsonNumberRule(IToken token) {
        this.mToken = token;
    }

    private void begin(ICharacterScanner scanner) {
        this.mCount = 0;
        this.mScanner = scanner;
    }

    private void end() {
        this.mScanner = null;
    }

    private int read() {
        ++this.mCount;
        return this.mScanner.read();
    }

    private void unread() {
        --this.mCount;
        this.mScanner.unread();
    }

    private void unreadAll() {
        int i = 0;
        while (i < this.mCount) {
            this.mScanner.unread();
            ++i;
        }
        this.mCount = 0;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        boolean start = true;
        boolean startZero = false;
        boolean wasMinus = false;
        boolean wasESign = false;
        boolean wasDot = false;
        boolean wasE = false;
        boolean prevE = false;
        this.mValid = false;
        this.begin(scanner);
        while (true) {
            int c;
            if ((c = this.read()) == -1) {
                return this.stop();
            }
            if (start) {
                if (c == 45) {
                    if (wasMinus) {
                        return this.stop();
                    }
                    this.mValid = false;
                    wasMinus = true;
                    continue;
                }
                if (c == 48) {
                    this.mValid = true;
                    startZero = true;
                    start = false;
                    continue;
                }
                if (Character.isDigit(c)) {
                    this.mValid = true;
                    startZero = false;
                    start = false;
                    continue;
                }
                this.mValid = false;
                return this.stop();
            }
            if (Character.isDigit(c)) {
                if (startZero && !wasDot) {
                    this.mValid = false;
                    return this.stop();
                }
                if (wasDot || wasE) {
                    this.mValid = true;
                }
                prevE = false;
                continue;
            }
            if (c == 46) {
                if (wasDot || !this.mValid) {
                    return this.stop();
                }
                prevE = false;
                wasDot = true;
                this.mValid = false;
                continue;
            }
            if (c == 101 || c == 69) {
                if (wasE || !this.mValid) {
                    return this.stop();
                }
                prevE = true;
                wasE = true;
                this.mValid = false;
                continue;
            }
            if (c != 45 && c != 43) break;
            if (wasESign || !prevE) {
                return this.stop();
            }
            wasESign = true;
            this.mValid = false;
            prevE = false;
        }
        return this.stop();
    }

    private IToken stop() {
        if (this.mValid) {
            this.unread();
            this.end();
            return this.mToken;
        }
        this.unreadAll();
        this.end();
        return Token.UNDEFINED;
    }
}

