/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.swt.widgets.Display;
import org.sweetlemonade.eclipse.json.editor.JsonEditor;
import org.sweetlemonade.eclipse.json.model.antlr.IllegalParseStateException;
import org.sweetlemonade.eclipse.json.model.antlr.ParseUtils;

public class JsonReconcileStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private IDocument mDocument;
    private final JsonEditor mEditor;

    public JsonReconcileStrategy(JsonEditor editor) {
        this.mEditor = editor;
    }

    public void setDocument(IDocument document) {
        this.mDocument = document;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile();
    }

    public void reconcile(IRegion partition) {
        this.reconcile();
    }

    private void reconcile() {
        try {
            final ParseUtils.ParseResult parse = ParseUtils.parse(this.mDocument);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    JsonReconcileStrategy.this.mEditor.setJsonInput(ParseUtils.tree(parse.tree), parse.errors);
                }
            });
            return;
        }
        catch (IllegalParseStateException e) {
            e.getClass();
            return;
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        this.reconcile();
    }
}

