/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.model;

import java.util.Collection;
import org.sweetlemonade.eclipse.json.model.JsonArray;
import org.sweetlemonade.eclipse.json.model.JsonObject;
import org.sweetlemonade.eclipse.json.model.JsonPrimitive;

public abstract class JsonElement {
    private final JsonElement mParent;
    private int mStart;
    private int mEnd;
    private int mStartLine;
    private int mEndLine;

    public JsonElement(JsonElement parent) {
        this.mParent = parent;
    }

    public boolean isArray() {
        return this instanceof JsonArray;
    }

    public boolean isObject() {
        return this instanceof JsonObject;
    }

    public boolean isPrimitive() {
        return this instanceof JsonPrimitive;
    }

    public JsonArray asArray() {
        if (this.isArray()) {
            return (JsonArray)this;
        }
        throw new UnsupportedOperationException();
    }

    public JsonObject asObject() {
        if (this.isObject()) {
            return (JsonObject)this;
        }
        throw new UnsupportedOperationException();
    }

    public JsonPrimitive asPrimitive() {
        if (this.isPrimitive()) {
            return (JsonPrimitive)this;
        }
        throw new UnsupportedOperationException();
    }

    public abstract boolean hasChilds();

    public Collection<JsonElement> getChilds() {
        if (this.isArray()) {
            return this.asArray();
        }
        if (this.isObject()) {
            return this.asObject().values();
        }
        throw new UnsupportedOperationException();
    }

    public boolean hasParent() {
        return this.mParent != null;
    }

    public JsonElement getParent() {
        return this.mParent;
    }

    public void setStart(int start) {
        this.mStart = start;
    }

    public void setEnd(int end) {
        this.mEnd = end;
    }

    public int getStart() {
        return this.mStart;
    }

    public int getEnd() {
        return this.mEnd;
    }

    public int getLength() {
        return this.mEnd - this.mStart;
    }

    public void setStartLine(int startLine) {
        this.mStartLine = startLine;
    }

    public void setEndLine(int endLine) {
        this.mEndLine = endLine;
    }

    public int getEndLine() {
        return this.mEndLine;
    }

    public int getStartLine() {
        return this.mStartLine;
    }

    public int getIndex() {
        JsonElement parent = this.getParent();
        if (parent == null || !parent.isArray()) {
            return -1;
        }
        return parent.asArray().indexOf(this);
    }

    public String getKey() {
        JsonElement parent = this.getParent();
        if (parent == null || !parent.isObject()) {
            return null;
        }
        JsonObject object = parent.asObject();
        Collection<JsonObject.Key> keySet = object.keys();
        for (JsonObject.Key string : keySet) {
            if (object.get(string) != this) continue;
            return string.getValue();
        }
        return null;
    }
}

