/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.model;

import java.io.IOException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.sweetlemonade.eclipse.json.model.JsonArray;
import org.sweetlemonade.eclipse.json.model.JsonElement;
import org.sweetlemonade.eclipse.json.model.JsonGrammar;
import org.sweetlemonade.eclipse.json.model.JsonObject;
import org.sweetlemonade.eclipse.json.model.JsonPrimitive;

public class JsonParserMy {
    private final IDocument mDoc;
    private int mPosition;

    public JsonParserMy(IDocument document) {
        this.mDoc = document;
    }

    public JsonElement parse() {
        try {
            this.mPosition = 0;
            char read = this.read(true);
            if (read == '{') {
                return this.readObject(null);
            }
            if (read == '[') {
                return this.readArray(null);
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private int getPos() {
        return this.mPosition;
    }

    private int getPrevPos() {
        return this.mPosition - 1;
    }

    private int getLine() throws IOException {
        try {
            return this.mDoc.getLineOfOffset(this.mPosition);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException();
        }
    }

    private int getPrevLine() throws IOException {
        try {
            return this.mDoc.getLineOfOffset(this.mPosition - 1);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException();
        }
    }

    private JsonArray readArray(JsonElement parent) throws IOException {
        JsonArray array = new JsonArray(parent);
        array.setStart(this.getPrevPos());
        array.setStartLine(this.getPrevLine());
        while (true) {
            char read;
            if ((read = this.read(true)) == ']') {
                array.setEnd(this.getPos());
                array.setEndLine(this.getLine());
                return array;
            }
            this.unread();
            JsonElement value = this.readValue(array);
            read = this.read(true);
            if (read != ',' && read != ']') {
                throw new IOException();
            }
            if (read == ']') {
                this.unread();
            }
            array.add(value);
        }
    }

    private JsonObject readObject(JsonElement parent) throws IOException {
        JsonObject object = new JsonObject(parent);
        object.setStart(this.getPrevPos());
        object.setStartLine(this.getPrevLine());
        while (true) {
            char read;
            if ((read = this.read(true)) == '}') {
                object.setEnd(this.getPos());
                object.setEndLine(this.getLine());
                return object;
            }
            String key = this.readStringValue();
            read = this.read(true);
            if (read != ':') {
                throw new IOException();
            }
            JsonElement value = this.readValue(object);
            read = this.read(true);
            if (read != ',' && read != '}') {
                throw new IOException();
            }
            if (read == '}') {
                this.unread();
            }
            object.put(key, value);
        }
    }

    private JsonPrimitive readPrimitive(JsonElement parent) throws IOException {
        char read = this.read(true);
        int start = this.getPrevPos();
        int startLine = this.getPrevLine();
        if (read == '\"') {
            String until = this.readStringValue();
            this.readPrimitiveValue();
            return this.makePrimitive(parent, start, startLine, until, JsonPrimitive.PrimitiveType.STRING);
        }
        this.unread();
        String until = this.readPrimitiveValue();
        if (JsonGrammar.Keyword.NULL.isEquals(until)) {
            return this.makePrimitive(parent, start, startLine, null, JsonPrimitive.PrimitiveType.NULL);
        }
        if (JsonGrammar.Keyword.TRUE.isEquals(until) || JsonGrammar.Keyword.FALSE.isEquals(until)) {
            return this.makePrimitive(parent, start, startLine, until, JsonPrimitive.PrimitiveType.BOOLEAN);
        }
        return this.makePrimitive(parent, start, startLine, until, JsonPrimitive.PrimitiveType.NUMBER);
    }

    private JsonPrimitive makePrimitive(JsonElement parent, int start, int startLine, String until, JsonPrimitive.PrimitiveType type) throws IOException {
        JsonPrimitive primitive = new JsonPrimitive(parent, until, type);
        primitive.setStart(start);
        primitive.setStartLine(startLine);
        primitive.setEnd(this.getPos());
        primitive.setEndLine(this.getLine());
        return primitive;
    }

    private JsonElement readValue(JsonElement parent) throws IOException {
        char read = this.read(true);
        if (read == '[') {
            return this.readArray(parent);
        }
        if (read == '{') {
            return this.readObject(parent);
        }
        this.unread();
        return this.readPrimitive(parent);
    }

    private boolean contains(int ch, int ... endChar) {
        int i = 0;
        while (i < endChar.length) {
            if (ch == endChar[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String readPrimitiveValue() throws IOException {
        StringBuilder builder = new StringBuilder();
        int pos = this.getPos();
        char read = this.read(true);
        while (!this.contains(read, 44, 125, 93)) {
            builder.append(read);
            pos = this.getPos();
            read = this.read(true);
        }
        this.unreadTo(pos);
        return builder.toString();
    }

    private String readStringValue() throws IOException {
        StringBuilder builder = new StringBuilder();
        char read = this.read();
        boolean escapeStart = false;
        while (read != '\"' || escapeStart) {
            escapeStart = read == '\\';
            builder.append(read);
            read = this.read();
        }
        return builder.toString();
    }

    private void unreadTo(int pos) throws IOException {
        this.mPosition = pos;
    }

    private void unread() throws IOException {
        --this.mPosition;
        if (this.mPosition < 0) {
            throw new IOException();
        }
    }

    private char read() throws IOException {
        return this.read(false);
    }

    private char read(boolean ignoreWhitespace) throws IOException {
        char read;
        do {
            try {
                read = this.mDoc.getChar(this.mPosition++);
            }
            catch (BadLocationException badLocationException) {
                throw new IOException();
            }
        } while (JsonGrammar.isWhitespace(read) && ignoreWhitespace);
        return read;
    }
}

