/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.outline;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.sweetlemonade.eclipse.json.Container;
import org.sweetlemonade.eclipse.json.SelectionsFinder;
import org.sweetlemonade.eclipse.json.editor.JsonEditor;
import org.sweetlemonade.eclipse.json.model.JsonElement;
import org.sweetlemonade.eclipse.json.outline.Checker;
import org.sweetlemonade.eclipse.json.outline.JsonLabelProvider;
import org.sweetlemonade.eclipse.json.outline.JsonOutlineContentProvider;
import org.sweetlemonade.eclipse.json.outline.QuickOutlineFilter;

public class JsonQuickOutline
extends AbstractInformationControl
implements ISelectionChangedListener,
IInformationControlExtension2,
IDoubleClickListener,
FocusListener,
KeyListener {
    private final ListenerList mSelectionChangedListeners = new ListenerList();
    private TreeViewer mTreeViewer;
    private final JsonEditor mEditor;
    private JsonElement mJsonElement;
    private Text mFilter;
    private final SelectionsFinder mFinder = new SelectionsFinder();

    public JsonQuickOutline(Shell parentShell, JsonEditor editor) {
        super(parentShell, null);
        this.mEditor = editor;
        this.create();
        Rectangle bounds = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getBounds();
        int width = bounds.width / 3;
        int height = bounds.height / 2;
        int x = bounds.x + (bounds.width - width) / 2;
        int y = bounds.y + (bounds.height - height) / 2;
        this.setLocation(new Point(x, y));
        this.setSize(width, height);
    }

    public void setInput(Object input) {
        ITextSelection textSelection;
        int start;
        JsonElement found;
        this.mTreeViewer.setInput((Object)new Container(input));
        ISelection selection = this.mEditor.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection && (found = this.mFinder.findSelectedScope(start = (textSelection = (ITextSelection)selection).getOffset(), (JsonElement)input)) != null) {
            TreeViewer treeViewer = this.getTreeViewer();
            TreeSelection treeSelection = new TreeSelection(new TreePath(new Object[]{found}));
            treeViewer.reveal((Object)found);
            treeViewer.setSelection((ISelection)treeSelection);
        }
        this.mTreeViewer.expandAll();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.mSelectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.mSelectionChangedListeners.remove((Object)listener);
    }

    public boolean hasContents() {
        return true;
    }

    private void findSelection() {
        String filter = this.mFilter.getText().trim().toLowerCase();
        JsonElement input = (JsonElement)((Container)this.mTreeViewer.getInput()).object;
        JsonElement element = Checker.find(filter, input);
        this.mTreeViewer.setSelection((ISelection)new TreeSelection(new TreePath(new Object[]{element})));
    }

    protected void createContent(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        this.mFilter = new Text(parent, 2048);
        FormData fd_text = new FormData();
        fd_text.right = new FormAttachment(100, 0);
        fd_text.top = new FormAttachment(0);
        fd_text.left = new FormAttachment(0);
        this.mFilter.setLayoutData((Object)fd_text);
        this.mFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JsonQuickOutline.this.mTreeViewer.refresh();
                JsonQuickOutline.this.mTreeViewer.expandAll();
                JsonQuickOutline.this.findSelection();
            }
        });
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new TreeColumnLayout());
        FormData fd_composite = new FormData();
        fd_composite.top = new FormAttachment((Control)this.mFilter, 0);
        fd_composite.left = new FormAttachment(0, 0);
        fd_composite.right = new FormAttachment(100, 0);
        fd_composite.bottom = new FormAttachment(100, 0);
        composite.setLayoutData((Object)fd_composite);
        this.mTreeViewer = new TreeViewer(composite, this.getTreeStyle());
        this.mTreeViewer.setContentProvider((IContentProvider)new JsonOutlineContentProvider());
        DelegatingStyledCellLabelProvider delegatingStyledCellLabelProvider = new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new JsonLabelProvider());
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)delegatingStyledCellLabelProvider);
        this.mTreeViewer.setFilters(new ViewerFilter[]{new QuickOutlineFilter(this.mFilter)});
        this.mTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.mTreeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.mTreeViewer.setComparer(new IElementComparer(){

            public int hashCode(Object element) {
                return System.identityHashCode(element);
            }

            public boolean equals(Object a, Object b) {
                return a == b;
            }
        });
        Control control = this.mTreeViewer.getControl();
        this.mFilter.addKeyListener((KeyListener)this);
        control.addKeyListener((KeyListener)this);
        this.addFocusListener(this);
    }

    private int getTreeStyle() {
        return 770;
    }

    public TreeViewer getTreeViewer() {
        return this.mTreeViewer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this.mJsonElement = selection.isEmpty() ? null : (JsonElement)((IStructuredSelection)selection).getFirstElement();
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.mJsonElement != null) {
            this.showJsonElement();
        }
    }

    public void dispose() {
        this.mTreeViewer.removeDoubleClickListener((IDoubleClickListener)this);
        Control control = this.mTreeViewer.getControl();
        control.removeKeyListener((KeyListener)this);
        control.removeFocusListener((FocusListener)this);
        super.dispose();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.setVisible(false);
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 0x1000002 && e.widget == this.mFilter) {
            this.mTreeViewer.getControl().setFocus();
        }
    }

    public void keyReleased(KeyEvent e) {
        if ((e.keyCode == 13 || e.keyCode == 0x1000050) && this.mJsonElement != null) {
            this.showJsonElement();
        }
    }

    private void showJsonElement() {
        try {
            this.mEditor.selectAndReveal(this.mJsonElement.getStart(), this.mJsonElement.getLength());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.mEditor.resetHighlightRange();
        }
        this.setVisible(false);
        this.dispose();
    }
}

