/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.outline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.TreeViewer;
import org.sweetlemonade.eclipse.json.Container;
import org.sweetlemonade.eclipse.json.model.JsonArray;
import org.sweetlemonade.eclipse.json.model.JsonElement;
import org.sweetlemonade.eclipse.json.model.JsonObject;

public class JsonTreeExpander {
    private TreeViewer mViewer;
    private JsonElement mElement;

    public JsonTreeExpander(TreeViewer viewer) {
        this.mViewer = viewer;
        this.mViewer.setComparer(new IElementComparer(){

            public int hashCode(Object element) {
                return System.identityHashCode(element);
            }

            public boolean equals(Object a, Object b) {
                return a == b;
            }
        });
    }

    public void update(JsonElement element) {
        if (this.mElement == null) {
            this.mViewer.setInput((Object)new Container(element));
            this.mViewer.expandToLevel(2);
            this.mElement = element;
            return;
        }
        Object[] objects = this.mViewer.getExpandedElements();
        JsonElement[] elements = new JsonElement[objects.length];
        System.arraycopy(objects, 0, elements, 0, objects.length);
        this.mViewer.setInput((Object)new Container(element));
        if (element == null) {
            return;
        }
        List<JsonElement> expanded = Arrays.asList(elements);
        ArrayList<JsonElement> expand = new ArrayList<JsonElement>();
        this.check(this.mElement, element, expanded, expand);
        this.mViewer.setExpandedElements(expand.toArray());
        this.mElement = element;
    }

    private boolean check(JsonElement elementWas, JsonElement elementNow, List<JsonElement> expanded, List<JsonElement> expand) {
        boolean result;
        block8: {
            block7: {
                if (elementWas.isPrimitive() || elementNow.isPrimitive()) {
                    return false;
                }
                if (elementWas.getClass() != elementNow.getClass()) {
                    return false;
                }
                result = false;
                if (expanded.contains(elementWas)) {
                    result = true;
                    expand.add(elementNow);
                }
                if (!elementWas.hasChilds()) {
                    return result;
                }
                if (!elementWas.isArray()) break block7;
                JsonArray wasChilds = elementWas.asArray();
                JsonArray nowChilds = elementNow.asArray();
                int len = Math.min(wasChilds.size(), nowChilds.size());
                int i = 0;
                while (i < len) {
                    JsonElement was = (JsonElement)wasChilds.get(i);
                    JsonElement now = (JsonElement)nowChilds.get(i);
                    this.check(was, now, expanded, expand);
                    ++i;
                }
                break block8;
            }
            if (!elementWas.isObject()) break block8;
            JsonObject wasObj = elementWas.asObject();
            JsonObject nowObj = elementNow.asObject();
            Collection<JsonObject.Key> wasSet = wasObj.keys();
            Collection<JsonObject.Key> nowSet = nowObj.keys();
            block1: for (JsonObject.Key wasKey : wasSet) {
                for (JsonObject.Key nowKey : nowSet) {
                    if (nowKey.getValue().equals(wasKey.getValue()) && this.check(wasObj.get(wasKey), nowObj.get(nowKey), expanded, expand)) continue block1;
                }
            }
        }
        return result;
    }
}

