/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.preference;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.sweetlemonade.eclipse.json.ColorManager;
import org.sweetlemonade.eclipse.json.JsonPlugin;
import org.sweetlemonade.eclipse.json.preference.JsonPreferencesInitializer;

public class JsonPreferences {
    private final IPreferenceStore mStore = JsonPlugin.getDefault().getPreferenceStore();
    private final ColorManager mManager = JsonPlugin.getColorManager();

    public int getStyle(JsonPreferencesInitializer.TokenType type) {
        return type.getStyle(this.mStore);
    }

    public RGB getRgb(JsonPreferencesInitializer.TokenType type) {
        return type.getColor(this.mStore);
    }

    public Color getColor(JsonPreferencesInitializer.TokenType type) {
        return this.mManager.getColor(this.getRgb(type));
    }

    public static int extractBoldItalic(int style) {
        return style & 0xDFFFFFFF & 0xBFFFFFFF;
    }

    public static boolean isUnderline(int style) {
        return (style & 0x40000000) != 0;
    }

    public static boolean isStrike(int style) {
        return (style & 0x20000000) != 0;
    }

    public static boolean isBold(int style) {
        return (style & 1) != 0;
    }

    public static boolean isItalic(int style) {
        return (style & 2) != 0;
    }

    public static int mergeStyles(boolean bold, boolean italic, boolean under, boolean strike) {
        int style = 0;
        style |= bold ? 1 : 0;
        style |= italic ? 2 : 0;
        style |= under ? 0x40000000 : 0;
        return style |= strike ? 0x20000000 : 0;
    }
}

