/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.CannotDeleteCurrentBranchException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NotMergedException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;

public class DeleteBranchOperation
implements IEGitOperation {
    public static final int OK = 0;
    public static final int REJECTED_CURRENT = 1;
    public static final int REJECTED_UNMERGED = 2;
    public static final int NOT_TRIED = -1;
    private int status = -1;
    private final Repository repository;
    private final Set<Ref> branches;
    private final boolean force;

    public DeleteBranchOperation(Repository repository, Ref branch, boolean force) {
        this(repository, new HashSet<Ref>(Arrays.asList(branch)), force);
    }

    public DeleteBranchOperation(Repository repository, Set<Ref> branches, boolean force) {
        this.repository = repository;
        this.branches = branches;
        this.force = force;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                String taskName;
                if (DeleteBranchOperation.this.branches.size() == 1) {
                    taskName = NLS.bind((String)CoreText.DeleteBranchOperation_TaskName, (Object)((Ref)DeleteBranchOperation.this.branches.iterator().next()).getName());
                } else {
                    StringBuilder names = new StringBuilder();
                    Iterator it = DeleteBranchOperation.this.branches.iterator();
                    while (it.hasNext()) {
                        Ref ref = (Ref)it.next();
                        names.append(ref.getName());
                        if (!it.hasNext()) continue;
                        names.append(", ");
                    }
                    taskName = NLS.bind((String)CoreText.DeleteBranchOperation_TaskName, (Object)names);
                }
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)actMonitor, (String)taskName, (int)DeleteBranchOperation.this.branches.size());
                for (Ref branch : DeleteBranchOperation.this.branches) {
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException(CoreText.DeleteBranchOperation_Canceled);
                    }
                    try {
                        Throwable throwable = null;
                        Object var7_11 = null;
                        try (Git git = new Git(DeleteBranchOperation.this.repository);){
                            git.branchDelete().setBranchNames(new String[]{branch.getName()}).setForce(DeleteBranchOperation.this.force).call();
                            DeleteBranchOperation.this.status = 0;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (NotMergedException e) {
                        DeleteBranchOperation.this.status = 2;
                        break;
                    }
                    catch (CannotDeleteCurrentBranchException e) {
                        DeleteBranchOperation.this.status = 1;
                        break;
                    }
                    catch (GitAPIException | JGitInternalException e) {
                        throw new CoreException(Activator.error(e.getMessage(), e));
                    }
                    progress.worked(1);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, monitor);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRule(this.repository);
    }
}

