/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.popupnotifications;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import name.schedenig.eclipse.popupnotifications.DefaultNotificationStyle;
import name.schedenig.eclipse.popupnotifications.INotificationStyle;
import name.schedenig.eclipse.popupnotifications.IPopupNotificationManagerListener;
import name.schedenig.eclipse.popupnotifications.Notification;
import name.schedenig.eclipse.popupnotifications.PopupNotification;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;

public class PopupNotificationManager {
    private LinkedList<PopupNotification> notifications = new LinkedList();
    private Display display;
    private int defaultDuration = 2000;
    private INotificationStyle defaultNotificationStyle;
    private int spacing = 1;
    private int alpha = 255;
    private int appearDuration = 500;
    private int disappearDuration = 3000;
    private int timerDuration = 25;
    private int moveDelta = 5;
    private volatile boolean moveTimerActive = false;
    private boolean disposed;
    private Set<IPopupNotificationManagerListener> listeners = new LinkedHashSet<IPopupNotificationManagerListener>();
    private Runnable moveRunnable = new Runnable(){

        @Override
        public void run() {
            if (PopupNotificationManager.this.disposed) {
                return;
            }
            int moving = 0;
            int prevTop = PopupNotificationManager.this.getDesktopBottom();
            for (PopupNotification notification : PopupNotificationManager.this.notifications) {
                Rectangle bounds = notification.getBounds();
                if (bounds == null) continue;
                int expectedTop = prevTop - PopupNotificationManager.this.spacing - bounds.height;
                if (bounds.y < expectedTop) {
                    ++moving;
                    int newTop = Math.min(bounds.y + PopupNotificationManager.this.moveDelta, expectedTop);
                    notification.setBounds(new Rectangle(bounds.x, newTop, bounds.width, bounds.height));
                    prevTop = newTop;
                    continue;
                }
                prevTop = bounds.y;
            }
            if (moving > 0) {
                PopupNotificationManager.this.display.timerExec(PopupNotificationManager.this.timerDuration, PopupNotificationManager.this.moveRunnable);
            } else {
                PopupNotificationManager.this.moveTimerActive = false;
            }
        }
    };

    public PopupNotificationManager(Display display) {
        this.display = display;
        this.defaultNotificationStyle = new DefaultNotificationStyle(display);
        display.disposeExec(new Runnable(){

            @Override
            public void run() {
                PopupNotificationManager.this.dispose();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IPopupNotificationManagerListener listener) {
        Set<IPopupNotificationManagerListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IPopupNotificationManagerListener listener) {
        Set<IPopupNotificationManagerListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public INotificationStyle getDefaultNotificationStyle() {
        return this.defaultNotificationStyle;
    }

    public void setDefaultNotificationStyle(INotificationStyle defaultNotificationStyle) {
        this.defaultNotificationStyle = defaultNotificationStyle;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public long getDefaultDuration() {
        return this.defaultDuration;
    }

    public void setDefaultDuration(int defaultDuration) {
        this.defaultDuration = defaultDuration;
    }

    public PopupNotification addNotification(Notification notification) {
        return this.addNotification(notification, this.defaultDuration);
    }

    public PopupNotification addNotification(Notification notification, int duration) {
        final PopupNotification popupNotification = new PopupNotification(this, notification, duration);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                popupNotification.setBounds(PopupNotificationManager.this.calculateBounds(popupNotification));
                PopupNotificationManager.this.notifications.add(popupNotification);
                popupNotification.setVisible(true);
            }
        };
        if (this.display.isDisposed()) {
            runnable.run();
        } else {
            this.display.syncExec(runnable);
        }
        return popupNotification;
    }

    private Rectangle calculateBounds(PopupNotification notification) {
        int currentTop = this.getCurrentTop();
        Rectangle desktopArea = this.getDesktopArea();
        Rectangle bounds = notification.getBounds();
        int x = desktopArea.x + desktopArea.width - bounds.width;
        int y = currentTop - this.spacing - bounds.height;
        return new Rectangle(x, y, bounds.width, bounds.height);
    }

    private Rectangle getDesktopArea() {
        Monitor monitor = Display.getDefault().getPrimaryMonitor();
        return monitor.getClientArea();
    }

    private int getCurrentTop() {
        if (this.notifications.isEmpty()) {
            return this.getDesktopBottom();
        }
        return this.notifications.getLast().getBounds().y;
    }

    private int getDesktopBottom() {
        Rectangle area = this.getDesktopArea();
        return area.y + area.height;
    }

    public void removeNotification(final PopupNotification notification) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!notification.isDisposed()) {
                    PopupNotificationManager.this.notifications.remove(notification);
                    notification.dispose();
                    PopupNotificationManager.this.startMoveTimer();
                }
            }
        };
        if (this.display.isDisposed()) {
            runnable.run();
        } else {
            this.display.syncExec(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList<IPopupNotificationManagerListener> currentListeners;
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.clear();
        Set<IPopupNotificationManagerListener> set = this.listeners;
        synchronized (set) {
            currentListeners = new ArrayList<IPopupNotificationManagerListener>(this.listeners);
        }
        for (IPopupNotificationManagerListener listener : currentListeners) {
            listener.disposed(this);
        }
    }

    public void clear() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (PopupNotification notification : PopupNotificationManager.this.notifications) {
                    notification.dispose();
                }
                PopupNotificationManager.this.notifications.clear();
            }
        };
        if (this.display.isDisposed()) {
            runnable.run();
        } else {
            this.display.syncExec(runnable);
        }
    }

    public Display getDisplay() {
        return this.display;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getAppearDuration() {
        return this.appearDuration;
    }

    public void setAppearDuration(int appearDuration) {
        this.appearDuration = appearDuration;
    }

    public int getDisappearDuration() {
        return this.disappearDuration;
    }

    public void setDisappearDuration(int disappearDuration) {
        this.disappearDuration = disappearDuration;
    }

    public int getTimerInterval() {
        return this.timerDuration;
    }

    public void setTimerDuration(int timerDuration) {
        this.timerDuration = timerDuration;
    }

    public int getMoveDelta() {
        return this.moveDelta;
    }

    public void setMoveDelta(int moveDelta) {
        this.moveDelta = moveDelta;
    }

    private void startMoveTimer() {
        if (this.moveTimerActive) {
            return;
        }
        this.moveTimerActive = true;
        this.display.timerExec(this.timerDuration, this.moveRunnable);
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

