/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.popupnotifications.gui;

import java.util.LinkedHashSet;
import name.schedenig.eclipse.popupnotifications.utils.PopupNotificationsUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class ColorPickerLine {
    private LinkedHashSet<IColorChangeListener> listeners = new LinkedHashSet();
    private boolean colorMandatory = true;
    private boolean checked;
    private RGB color;
    private ColorImageHandler colorImageHandler;
    private String dialogTitle;
    private Button checkBox;
    private Text text;
    private Button button;

    public ColorPickerLine(Composite parent) {
        this.init(parent);
    }

    private void init(Composite parent) {
        this.checkBox = new Button(parent, 32);
        this.checkBox.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorPickerLine.this.checked = ColorPickerLine.this.checkBox.getSelection();
                if (ColorPickerLine.this.checked && ColorPickerLine.this.colorMandatory && ColorPickerLine.this.color == null) {
                    ColorPickerLine.this.setColor(PopupNotificationsUtil.getRandomRgb(), true, true);
                } else {
                    ColorPickerLine.this.refresh(false);
                    ColorPickerLine.this.fireColorChanged(ColorPickerLine.this.color);
                }
            }
        });
        this.text = new Text(parent, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.text.setTextLimit(6);
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                try {
                    PopupNotificationsUtil.stringToRgb(e.text);
                }
                catch (NumberFormatException numberFormatException) {
                    e.doit = false;
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColorPickerLine.this.setColor(PopupNotificationsUtil.stringToRgb(ColorPickerLine.this.text.getText()), false, true);
            }
        });
        this.colorImageHandler = new ColorImageHandler(24, 16);
        this.button = new Button(parent, 8);
        this.button.setImage(this.colorImageHandler.getImage());
        this.button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorPickerLine.this.pickColor();
            }
        });
        this.button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ColorPickerLine.this.colorImageHandler.dispose();
                ColorPickerLine.this.colorImageHandler = null;
            }
        });
    }

    public void addListener(IColorChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IColorChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void pickColor() {
        ColorDialog colorDialog = new ColorDialog(this.button.getShell());
        colorDialog.setText(this.dialogTitle);
        colorDialog.setRGB(this.color);
        RGB newColor = colorDialog.open();
        if (newColor != null) {
            this.setColor(newColor, true, true);
        }
    }

    private void refresh(boolean updateText) {
        this.checkBox.setSelection(this.checked);
        if (updateText) {
            this.text.setText(PopupNotificationsUtil.rgbToString(this.color));
        }
        Display display = this.button.getDisplay();
        this.text.setForeground(display.getSystemColor(this.checked ? 24 : 15));
        this.colorImageHandler.setColor(this.color);
        Image img = this.colorImageHandler.getImage();
        this.button.setImage(img);
    }

    public void setText(String text) {
        this.checkBox.setText(text);
    }

    public String getText() {
        return this.checkBox.getText();
    }

    public void setColor(RGB color) {
        this.setColor(color, true, false);
    }

    private void setColor(RGB color, boolean updateText, boolean fireEvent) {
        if (PopupNotificationsUtil.equals(color, this.color)) {
            return;
        }
        this.color = color;
        this.checked = this.checked ? color != null || !this.colorMandatory : color != null;
        this.refresh(updateText);
        if (fireEvent) {
            this.fireColorChanged(color);
        }
    }

    public RGB getColor() {
        return this.color;
    }

    public RGB getEffectiveColor() {
        return this.checked ? this.color : null;
    }

    private void fireColorChanged(RGB color) {
        for (IColorChangeListener listener : this.listeners) {
            listener.colorChanged(this, color);
        }
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        if (checked != this.checked) {
            this.checked = checked;
            this.refresh(false);
        }
    }

    public boolean isColorMandatory() {
        return this.colorMandatory;
    }

    public void setColorMandatory(boolean colorMandatory) {
        this.colorMandatory = colorMandatory;
    }

    public Text getTextControl() {
        return this.text;
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    class ColorImageHandler {
        private int width;
        private int height;
        private RGB color;
        private Image image;

        public ColorImageHandler(int width, int height) {
            this.width = width;
            this.height = height;
        }

        private void createImage() {
            RGB fillColor;
            boolean transparent;
            if (this.color == null) {
                transparent = true;
                fillColor = new RGB(127, 127, 127);
            } else {
                transparent = false;
                fillColor = this.color;
            }
            RGB black = new RGB(0, 0, 0);
            PaletteData dataPalette = new PaletteData(new RGB[]{black, fillColor});
            ImageData data = new ImageData(this.width, this.height, 2, dataPalette);
            data.transparentPixel = transparent ? 1 : -1;
            int y = 0;
            while (y < this.height) {
                int x = 0;
                while (x < this.width) {
                    if (x == 0 || y == 0 || x == this.width - 1 || y == this.height - 1) {
                        data.setPixel(x, y, 0);
                    } else {
                        data.setPixel(x, y, 1);
                    }
                    ++x;
                }
                ++y;
            }
            if (this.image != null) {
                this.image.dispose();
            }
            this.image = new Image(null, data);
        }

        public void dispose() {
            if (this.image != null) {
                this.image.dispose();
                this.image = null;
            }
        }

        public Image getImage() {
            if (this.image == null) {
                this.createImage();
            }
            return this.image;
        }

        public RGB getColor() {
            return this.color;
        }

        public void setColor(RGB color) {
            if (!PopupNotificationsUtil.equals(this.color, color)) {
                this.dispose();
                this.color = color;
            }
        }
    }

    public static interface IColorChangeListener {
        public void colorChanged(ColorPickerLine var1, RGB var2);
    }
}

