/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import name.schedenig.eclipse.grepconsole.adapters.GrepPageParticipant;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionRootFolder;
import name.schedenig.eclipse.grepconsole.model.xml.LegacyXmlReader;
import name.schedenig.eclipse.grepconsole.model.xml.XmlHandler;
import name.schedenig.eclipse.grepconsole.model.xml.XmlHandlerException;
import name.schedenig.eclipse.grepconsole.util.SoundManager;
import name.schedenig.eclipse.grepconsole.view.colors.OwnerColorRegistry;
import name.schedenig.eclipse.grepconsole.view.notifications.GrepConsoleNotificationStyle;
import name.schedenig.eclipse.popupnotifications.INotificationStyle;
import name.schedenig.eclipse.popupnotifications.PopupNotificationManager;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "name.schedenig.eclipse.grepconsole";
    public static final String LEGACY_PLUGIN_ID = "com.musgit.eclipse.grepconsole";
    public static final int CURRENT_VERSION_NUMBER = 370;
    public static final String PREFS_EXPRESSIONS = "expressions";
    public static final String PREFS_SHOW_WHATS_NEW = "showWhatsNew";
    public static final String PREFS_PREVIEW = "preview";
    public static final String PREFS_STYLE_MATCH_LENGTH = "styleMatchLength";
    public static final String PREFS_FILTER_MATCH_LENGTH = "filterMatchLength";
    public static final String PREFS_GREP_VIEW_FOREGROUND_COLOR = "grepViewForegroundColor";
    public static final String PREFS_GREP_VIEW_BACKGROUND_COLOR = "grepViewBackgroundColor";
    public static final String PREFS_LINK_MODIFIER_KEY = "linkModifierKey";
    public static final String PREFS_LEGACY_SETTINGS = "settings";
    public static final String PREFS_NOTIFICATION_FOREGROUND_COLOR = "notificationForegroundColor";
    public static final String PREFS_NOTIFICATION_BACKGROUND_COLOR = "notificationBackgroundColor";
    public static final String PREFS_NOTIFICATION_TITLE_FONT = "notificationTitleFont";
    public static final String PREFS_NOTIFICATION_MESSAGE_FONT = "notificationMessageFont";
    public static final String IMG_LOGO_SMALL = "logo_small";
    public static final String IMG_LOGO_LARGE = "logo_large";
    public static final String IMG_CHECKBOX_ON = "checkbox_on";
    public static final String IMG_CHECKBOX_OFF = "checkbox_off";
    public static final String IMG_CHECKBOX_ON_GREYED = "checkbox_on_greyed";
    public static final String IMG_CHECKBOX_OFF_GREYED = "checkbox_off_greyed";
    public static final String IMG_CHECKBOX_ON_INHERITED = "checkbox_on_inherited";
    public static final String IMG_CHECKBOX_OFF_INHERITED = "checkbox_off_inherited";
    public static final String IMG_CHECKBOX_ON_INHERITED_GREYED = "checkbox_on_inherited_greyed";
    public static final String IMG_CHECKBOX_OFF_INHERITED_GREYED = "checkbox_off_inherited_greyed";
    public static final String IMG_FILTER_ON = "filter_on";
    public static final String IMG_FILTER_OFF = "filter_off";
    public static final String IMG_FILTER_ON_GREYED = "filter_on_greyed";
    public static final String IMG_FILTER_OFF_GREYED = "filter_off_greyed";
    public static final String IMG_FILTER_ON_INHERITED = "filter_on_inherited";
    public static final String IMG_FILTER_OFF_INHERITED = "filter_off_inherited";
    public static final String IMG_FILTER_ON_INHERITED_GREYED = "filter_on_inherited_greyed";
    public static final String IMG_FILTER_OFF_INHERITED_GREYED = "filter_off_inherited_greyed";
    public static final String IMG_STATISTICS_ON = "statistics_on";
    public static final String IMG_STATISTICS_OFF = "statistics_off";
    public static final String IMG_STATISTICS_ON_GREYED = "statistics_on_greyed";
    public static final String IMG_STATISTICS_OFF_GREYED = "statistics_off_greyed";
    public static final String IMG_STATISTICS_ON_INHERITED = "statistics_on_inherited";
    public static final String IMG_STATISTICS_OFF_INHERITED = "statistics_off_inherited";
    public static final String IMG_STATISTICS_ON_INHERITED_GREYED = "statistics_on_inherited_greyed";
    public static final String IMG_STATISTICS_OFF_INHERITED_GREYED = "statistics_off_inherited_greyed";
    public static final String IMG_NOTIFICATION_ON = "notification_on";
    public static final String IMG_NOTIFICATION_OFF = "notification_off";
    public static final String IMG_NOTIFICATION_ON_GREYED = "notification_on_greyed";
    public static final String IMG_NOTIFICATION_OFF_GREYED = "notification_off_greyed";
    public static final String IMG_NOTIFICATION_ON_INHERITED = "notification_on_inherited";
    public static final String IMG_NOTIFICATION_OFF_INHERITED = "notification_off_inherited";
    public static final String IMG_NOTIFICATION_ON_INHERITED_GREYED = "notification_on_inherited_greyed";
    public static final String IMG_NOTIFICATION_OFF_INHERITED_GREYED = "notification_off_inherited_greyed";
    public static final String IMG_ACTION_SELECT_CONSOLE = "action.select_console";
    public static final String IMG_ACTION_SCROLL_LOCK = "action.scroll_lock";
    public static final String IMG_ACTION_LINKED_TO_CONSOLE = "action.linked_to_console";
    public static final String IMG_PLAY = "play";
    private static final String DEFAULT_PREVIEW_TEXT = Messages.Activator_default_preview_text;
    public static final int DEFAULT_STYLE_MATCH_LENGTH = 150;
    public static final int DEFAULT_FILTER_MATCH_LENGTH = 100;
    private static final int SOUND_CACHE_SIZE = 3;
    private static Activator plugin;
    private OwnerColorRegistry colorRegistry = new OwnerColorRegistry(null);
    private GrepExpressionRootFolder expressions;
    private Map<IConsole, GrepPageParticipant> participants = new LinkedHashMap<IConsole, GrepPageParticipant>();
    private Set<IGrepConsoleListener> listeners = new LinkedHashSet<IGrepConsoleListener>();
    private GrepPageParticipant activeParticipant;
    private boolean showWhatsNewCalled = false;
    private boolean displayLegacyWarning = false;
    private Cursor linkCursor;
    private SoundManager soundManager;
    private GrepConsoleNotificationStyle notificationStyle;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.displayLegacyWarning = Platform.getBundle((String)LEGACY_PLUGIN_ID) != null;
        try {
            this.loadSettings();
        }
        catch (XmlHandlerException ex) {
            this.log(4, "Could not read settings. Using defaults.", ex);
        }
        if (this.expressions == null) {
            this.expressions = this.loadLegacySettings();
            if (this.expressions != null) {
                this.setShowWhatsNew(true);
            }
        }
        if (this.expressions == null) {
            this.expressions = this.loadDefaults();
        }
        plugin = this;
    }

    public void displayLegacyWarningIfEnabled(Shell shell) {
        if (!this.displayLegacyWarning) {
            return;
        }
        this.displayLegacyWarning = false;
        Bundle bundle = Platform.getBundle((String)LEGACY_PLUGIN_ID);
        if (bundle == null) {
            return;
        }
        String msg = MessageFormat.format(Messages.Activator_legacy_version_message, bundle.getVersion(), this.getBundle().getVersion(), LEGACY_PLUGIN_ID);
        MessageDialog.openWarning((Shell)shell, (String)Messages.Activator_legacy_version_title, (String)msg);
    }

    public boolean isShowWhatsNew() {
        if (this.showWhatsNewCalled) {
            return false;
        }
        this.showWhatsNewCalled = true;
        IEclipsePreferences scope = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        return scope.getInt(PREFS_SHOW_WHATS_NEW, 0) < 370;
    }

    public void setShowWhatsNew(boolean showWhatsNew) {
        IEclipsePreferences scope = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        if (showWhatsNew) {
            scope.remove(PREFS_SHOW_WHATS_NEW);
        } else {
            scope.putInt(PREFS_SHOW_WHATS_NEW, 370);
        }
    }

    private void loadSettings() throws XmlHandlerException {
        IEclipsePreferences scope = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        String xmlString = scope.get(PREFS_EXPRESSIONS, null);
        if (xmlString == null || xmlString.length() == 0) {
            return;
        }
        XmlHandler handler = new XmlHandler();
        this.expressions = handler.readExpressions(xmlString);
    }

    private GrepExpressionRootFolder loadLegacySettings() throws XmlHandlerException {
        IEclipsePreferences scope = InstanceScope.INSTANCE.getNode(LEGACY_PLUGIN_ID);
        String xmlString = scope.get(PREFS_LEGACY_SETTINGS, null);
        if (xmlString == null || xmlString.length() == 0) {
            return null;
        }
        LegacyXmlReader reader = new LegacyXmlReader();
        return reader.xmlStringToExpressions(xmlString);
    }

    public void saveSettings() throws ParserConfigurationException, TransformerException, BackingStoreException {
        XmlHandler handler = new XmlHandler();
        String xml = handler.createXmlString(this.expressions);
        IEclipsePreferences scope = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        scope.put(PREFS_EXPRESSIONS, xml);
        scope.flush();
    }

    public GrepExpressionRootFolder loadDefaults() {
        XmlHandler handler = new XmlHandler();
        try {
            return handler.readExpressions(Activator.class.getResourceAsStream("resources/defaultExpressions.xml"));
        }
        catch (XmlHandlerException ex) {
            this.log(4, "Could not load defaults.", ex);
            return new GrepExpressionRootFolder();
        }
    }

    public synchronized void stop(BundleContext context) throws Exception {
        if (this.soundManager != null) {
            this.soundManager.dispose();
            this.soundManager = null;
        }
        if (this.linkCursor != null) {
            this.linkCursor.dispose();
            this.linkCursor = null;
        }
        this.colorRegistry.disposeColors();
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        super.initializeImageRegistry(registry);
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        registry.put(IMG_LOGO_SMALL, this.createImageDescriptor(bundle, "logo_16.png"));
        registry.put(IMG_LOGO_LARGE, this.createImageDescriptor(bundle, "logo_64.png"));
        registry.put(IMG_CHECKBOX_ON, this.createImageDescriptor(bundle, "checkbox_on.png"));
        registry.put(IMG_CHECKBOX_OFF, this.createImageDescriptor(bundle, "checkbox_off.png"));
        registry.put(IMG_CHECKBOX_ON_GREYED, this.createImageDescriptor(bundle, "checkbox_on_greyed.png"));
        registry.put(IMG_CHECKBOX_OFF_GREYED, this.createImageDescriptor(bundle, "checkbox_off_greyed.png"));
        registry.put(IMG_CHECKBOX_ON_INHERITED, this.createImageDescriptor(bundle, "checkbox_on_inherited.png"));
        registry.put(IMG_CHECKBOX_OFF_INHERITED, this.createImageDescriptor(bundle, "checkbox_off_inherited.png"));
        registry.put(IMG_CHECKBOX_ON_INHERITED_GREYED, this.createImageDescriptor(bundle, "checkbox_on_inherited_greyed.png"));
        registry.put(IMG_CHECKBOX_OFF_INHERITED_GREYED, this.createImageDescriptor(bundle, "checkbox_off_inherited_greyed.png"));
        registry.put(IMG_FILTER_ON, this.createImageDescriptor(bundle, "filter_on.png"));
        registry.put(IMG_FILTER_OFF, this.createImageDescriptor(bundle, "filter_off.png"));
        registry.put(IMG_FILTER_ON_GREYED, this.createImageDescriptor(bundle, "filter_on_greyed.png"));
        registry.put(IMG_FILTER_OFF_GREYED, this.createImageDescriptor(bundle, "filter_off_greyed.png"));
        registry.put(IMG_FILTER_ON_INHERITED, this.createImageDescriptor(bundle, "filter_on_inherited.png"));
        registry.put(IMG_FILTER_OFF_INHERITED, this.createImageDescriptor(bundle, "filter_off_inherited.png"));
        registry.put(IMG_FILTER_ON_INHERITED_GREYED, this.createImageDescriptor(bundle, "filter_on_inherited_greyed.png"));
        registry.put(IMG_FILTER_OFF_INHERITED_GREYED, this.createImageDescriptor(bundle, "filter_off_inherited_greyed.png"));
        registry.put(IMG_STATISTICS_ON, this.createImageDescriptor(bundle, "statistics_on.png"));
        registry.put(IMG_STATISTICS_OFF, this.createImageDescriptor(bundle, "statistics_off.png"));
        registry.put(IMG_STATISTICS_ON_GREYED, this.createImageDescriptor(bundle, "statistics_on_greyed.png"));
        registry.put(IMG_STATISTICS_OFF_GREYED, this.createImageDescriptor(bundle, "statistics_off_greyed.png"));
        registry.put(IMG_STATISTICS_ON_INHERITED, this.createImageDescriptor(bundle, "statistics_on_inherited.png"));
        registry.put(IMG_STATISTICS_OFF_INHERITED, this.createImageDescriptor(bundle, "statistics_off_inherited.png"));
        registry.put(IMG_STATISTICS_ON_INHERITED_GREYED, this.createImageDescriptor(bundle, "statistics_on_inherited_greyed.png"));
        registry.put(IMG_STATISTICS_OFF_INHERITED_GREYED, this.createImageDescriptor(bundle, "statistics_off_inherited_greyed.png"));
        registry.put(IMG_ACTION_SELECT_CONSOLE, this.createImageDescriptor(bundle, "eclipse/console_view.gif"));
        registry.put(IMG_ACTION_SCROLL_LOCK, this.createImageDescriptor(bundle, "eclipse/lock_co.gif"));
        registry.put(IMG_ACTION_LINKED_TO_CONSOLE, this.createImageDescriptor(bundle, "eclipse/writeout_co.gif"));
        registry.put(IMG_NOTIFICATION_ON, this.createImageDescriptor(bundle, "notification_on.png"));
        registry.put(IMG_NOTIFICATION_OFF, this.createImageDescriptor(bundle, "notification_off.png"));
        registry.put(IMG_NOTIFICATION_ON_GREYED, this.createImageDescriptor(bundle, "notification_on_greyed.png"));
        registry.put(IMG_NOTIFICATION_OFF_GREYED, this.createImageDescriptor(bundle, "notification_off_greyed.png"));
        registry.put(IMG_NOTIFICATION_ON_INHERITED, this.createImageDescriptor(bundle, "notification_on_inherited.png"));
        registry.put(IMG_NOTIFICATION_OFF_INHERITED, this.createImageDescriptor(bundle, "notification_off_inherited.png"));
        registry.put(IMG_NOTIFICATION_ON_INHERITED_GREYED, this.createImageDescriptor(bundle, "notification_on_inherited_greyed.png"));
        registry.put(IMG_NOTIFICATION_OFF_INHERITED_GREYED, this.createImageDescriptor(bundle, "notification_off_inherited_greyed.png"));
        registry.put(IMG_ACTION_SELECT_CONSOLE, this.createImageDescriptor(bundle, "eclipse/console_view.gif"));
        registry.put(IMG_ACTION_SCROLL_LOCK, this.createImageDescriptor(bundle, "eclipse/lock_co.gif"));
        registry.put(IMG_ACTION_LINKED_TO_CONSOLE, this.createImageDescriptor(bundle, "eclipse/writeout_co.gif"));
        registry.put(IMG_PLAY, this.createImageDescriptor(bundle, "eclipse/start_task.gif"));
    }

    private ImageDescriptor createImageDescriptor(Bundle bundle, String path) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/" + path), null);
        return ImageDescriptor.createFromURL((URL)url);
    }

    public GrepExpressionRootFolder getExpressions() {
        return this.expressions;
    }

    public OwnerColorRegistry getColorRegistry() {
        return this.colorRegistry;
    }

    public synchronized void setParticipant(IConsole console, GrepPageParticipant participant) {
        GrepPageParticipant oldParticipant = this.participants.get(console);
        if (participant == null) {
            this.participants.remove(console);
            if (oldParticipant != null) {
                this.doParticipantRemoved(oldParticipant);
            }
        } else {
            this.participants.put(console, participant);
            if (oldParticipant != participant) {
                if (oldParticipant != null) {
                    this.doParticipantRemoved(oldParticipant);
                }
                this.doParticipantAdded(participant);
            }
            this.setActiveParticipant(participant);
        }
    }

    public void addListener(IGrepConsoleListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IGrepConsoleListener listener) {
        this.listeners.remove(listener);
    }

    private void doParticipantAdded(GrepPageParticipant participant) {
        for (IGrepConsoleListener listener : this.listeners) {
            listener.participantAdded(participant);
        }
    }

    private void doParticipantRemoved(GrepPageParticipant participant) {
        for (IGrepConsoleListener listener : this.listeners) {
            listener.participantRemoved(participant);
        }
    }

    public void setActiveParticipant(GrepPageParticipant activeParticipant) {
        if (this.activeParticipant == activeParticipant) {
            return;
        }
        this.activeParticipant = activeParticipant;
        for (IGrepConsoleListener listener : new ArrayList<IGrepConsoleListener>(this.listeners)) {
            listener.participantActivated(activeParticipant);
        }
    }

    public GrepPageParticipant getActiveParticipant() {
        return this.activeParticipant;
    }

    public synchronized GrepPageParticipant getParticipant(IConsole console) {
        return this.participants.get(console);
    }

    public Map<IConsole, GrepPageParticipant> getParticipants() {
        return Collections.unmodifiableMap(this.participants);
    }

    public void log(int severity, Exception exception) {
        this.log(severity, exception.getMessage(), exception);
    }

    public void log(int severity, String message, Throwable exception) {
        Status status = new Status(severity, PLUGIN_ID, message, exception);
        this.getLog().log((IStatus)status);
    }

    public void doSettingsChanged() {
        for (IGrepConsoleListener listener : new ArrayList<IGrepConsoleListener>(this.listeners)) {
            listener.settingsChanged();
        }
    }

    public String getPreviewText() {
        IEclipsePreferences scope = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        return scope.get(PREFS_PREVIEW, DEFAULT_PREVIEW_TEXT);
    }

    public void setPreviewText(String text) {
        IEclipsePreferences scope = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        scope.put(PREFS_PREVIEW, text);
    }

    public int getStyleMatchLength() {
        IEclipsePreferences scope = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        return scope.getInt(PREFS_STYLE_MATCH_LENGTH, 150);
    }

    public int getFilterMatchLength() {
        IEclipsePreferences scope = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        return scope.getInt(PREFS_FILTER_MATCH_LENGTH, 100);
    }

    public synchronized Cursor getLinkCursor() {
        if (this.linkCursor == null) {
            this.linkCursor = new Cursor((Device)this.getWorkbench().getDisplay(), 21);
        }
        return this.linkCursor;
    }

    public int getLinkModifierKey() {
        IEclipsePreferences scope = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        String s = scope.get(PREFS_LINK_MODIFIER_KEY, null);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return SWT.MOD1;
    }

    public synchronized SoundManager getSoundManager() {
        if (this.soundManager == null) {
            this.soundManager = new SoundManager(3);
        }
        return this.soundManager;
    }

    public synchronized INotificationStyle getNotificationStyle() {
        if (this.notificationStyle == null) {
            PopupNotificationManager man = name.schedenig.eclipse.popupnotifications.Activator.getDefault().getManager();
            this.notificationStyle = new GrepConsoleNotificationStyle(man.getDefaultNotificationStyle(), this, man);
            this.notificationStyle.setImage(this.getImageRegistry().get(IMG_LOGO_SMALL));
        }
        return this.notificationStyle;
    }

    public static interface IGrepConsoleListener {
        public void participantAdded(GrepPageParticipant var1);

        public void participantRemoved(GrepPageParticipant var1);

        public void participantActivated(GrepPageParticipant var1);

        public void settingsChanged();
    }
}

