/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.actions;

import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.adapters.GrepPageParticipant;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionsWithSelection;
import name.schedenig.eclipse.grepconsole.view.grepview.GrepView;
import name.schedenig.eclipse.grepconsole.view.items.ItemsAndStylesDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.osgi.service.prefs.BackingStoreException;

public class ManageExpressionsAction
extends Action
implements IViewActionDelegate {
    private IViewPart view;

    public void init(IViewPart view) {
        this.view = view;
    }

    public void run(IAction action) {
        Activator activator = Activator.getDefault();
        GrepExpressionsWithSelection expressions = new GrepExpressionsWithSelection(activator.getExpressions().copy(true), null, null, null, null);
        GrepPageParticipant activeParticipant = this.getActiveParticipant();
        if (activeParticipant != null) {
            expressions.setEnablementMap(new HashMap<String, Boolean>(activeParticipant.getEnablementMap()));
            expressions.setFilterMap(new HashMap<String, Boolean>(activeParticipant.getFilterMap()));
            expressions.setStatisticsMap(new HashMap<String, Boolean>(activeParticipant.getStatisticsMap()));
            expressions.setNotificationsMap(new HashMap<String, Boolean>(activeParticipant.getNotificationsMap()));
        }
        ItemsAndStylesDialog dlg = new ItemsAndStylesDialog(this.view.getSite().getShell());
        dlg.setExpressions(expressions);
        dlg.setLaunchConfiguration(activeParticipant == null ? null : activeParticipant.getLaunchConfig());
        GrepPageParticipant participant = this.getActiveParticipant();
        if (participant != null) {
            String previewText = participant.getStyledText().getText();
            dlg.setPreviewText(previewText.trim().length() == 0 ? null : previewText);
        }
        if (dlg.open() == 0) {
            activator.getExpressions().copyFrom(expressions.getRootFolder(), true);
            try {
                activator.saveSettings();
            }
            catch (ParserConfigurationException ex) {
                Activator.getDefault().log(4, Messages.Error_could_not_save_settings, ex);
            }
            catch (TransformerException ex) {
                Activator.getDefault().log(4, Messages.Error_could_not_save_settings, ex);
            }
            catch (BackingStoreException ex) {
                Activator.getDefault().log(4, Messages.Error_could_not_save_settings, ex);
            }
            if (activeParticipant != null) {
                activeParticipant.setEnablementMap(expressions.getEnablementMap());
                activeParticipant.setFilterMap(expressions.getFilterMap());
                activeParticipant.setStatisticsMap(expressions.getStatisticsMap());
                activeParticipant.setNotificationsMap(expressions.getNotificationsMap());
                activeParticipant.saveLaunchConfig();
            }
            Activator.getDefault().doSettingsChanged();
        }
    }

    private GrepPageParticipant getActiveParticipant() {
        IConsole console = this.getConsole();
        return console == null ? null : Activator.getDefault().getParticipant(console);
    }

    private IConsole getConsole() {
        if (this.view instanceof IConsoleView) {
            return ((IConsoleView)this.view).getConsole();
        }
        if (this.view instanceof GrepView) {
            return ((GrepView)this.view).getConsole();
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

