/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.adapters;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.adapters.GrepPageParticipant;
import name.schedenig.eclipse.grepconsole.adapters.GrepStyleRange;
import name.schedenig.eclipse.grepconsole.adapters.TextFilter;
import name.schedenig.eclipse.grepconsole.adapters.links.CommandLinkAdapter;
import name.schedenig.eclipse.grepconsole.adapters.links.FileLinkAdapter;
import name.schedenig.eclipse.grepconsole.adapters.links.GrepLinkAdapter;
import name.schedenig.eclipse.grepconsole.adapters.links.JavaLinkAdapter;
import name.schedenig.eclipse.grepconsole.adapters.links.LinkMatch;
import name.schedenig.eclipse.grepconsole.adapters.links.ScriptLinkAdapter;
import name.schedenig.eclipse.grepconsole.adapters.links.UrlLinkAdapter;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionItem;
import name.schedenig.eclipse.grepconsole.model.GrepGroup;
import name.schedenig.eclipse.grepconsole.model.GrepStyle;
import name.schedenig.eclipse.grepconsole.model.links.CommandLink;
import name.schedenig.eclipse.grepconsole.model.links.FileLink;
import name.schedenig.eclipse.grepconsole.model.links.IGrepLink;
import name.schedenig.eclipse.grepconsole.model.links.JavaLink;
import name.schedenig.eclipse.grepconsole.model.links.ScriptLink;
import name.schedenig.eclipse.grepconsole.model.links.UrlLink;
import name.schedenig.eclipse.grepconsole.view.colors.ColorRegistry;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Shell;

public class GrepLineStyleListener
implements LineStyleListener,
Activator.IGrepConsoleListener {
    private static final Comparator<GrepStyleRange> STYLE_RANGE_COMPARATOR = new Comparator<GrepStyleRange>(){

        @Override
        public int compare(GrepStyleRange a, GrepStyleRange b) {
            if (a.getFirstIndex() != b.getFirstIndex()) {
                return a.getFirstIndex() < b.getFirstIndex() ? -1 : 1;
            }
            if (a.getStyleRange() != b.getStyleRange()) {
                if (a.getStyleRange() == null) {
                    return -1;
                }
                if (b.getStyleRange() == null) {
                    return 1;
                }
            }
            if (a.isWholeLine() != b.isWholeLine()) {
                return a.isWholeLine() ? 1 : -1;
            }
            if (a.getExpressionIndex() != b.getExpressionIndex()) {
                return a.getExpressionIndex() < b.getExpressionIndex() ? -1 : 1;
            }
            return 0;
        }
    };
    private static final Comparator<GrepStyleRange> STYLE_RANGE_COMPARATOR_SUB_BEFORE_WHOLE = new Comparator<GrepStyleRange>(){

        @Override
        public int compare(GrepStyleRange a, GrepStyleRange b) {
            if (a.isWholeLine() != b.isWholeLine()) {
                return a.isWholeLine() ? 1 : -1;
            }
            return 0;
        }
    };
    private Collection<GrepExpressionItem> items;
    private ColorRegistry colorRegistry;
    private int matchLength;
    private Shell shell;
    private IProject project;

    public GrepLineStyleListener(Shell shell, IProject project) {
        Activator activator = Activator.getDefault();
        activator.addListener(this);
        this.matchLength = activator.getStyleMatchLength();
        this.shell = shell;
        this.project = project;
    }

    public ColorRegistry getColorRegistry() {
        return this.colorRegistry;
    }

    public void setColorRegistry(ColorRegistry colorRegistry) {
        this.colorRegistry = colorRegistry;
    }

    public Collection<GrepExpressionItem> getItems() {
        return this.items;
    }

    public void setItems(Collection<GrepExpressionItem> items) {
        this.items = items;
    }

    public static GrepLinkAdapter createLinkAdapter(LinkMatch match, Shell shell, IProject project) {
        IGrepLink link = match.getLink();
        if (link instanceof UrlLink) {
            return new UrlLinkAdapter(match, shell);
        }
        if (link instanceof ScriptLink) {
            return new ScriptLinkAdapter(match, shell);
        }
        if (link instanceof FileLink) {
            return new FileLinkAdapter(match, shell);
        }
        if (link instanceof CommandLink) {
            return new CommandLinkAdapter(match, shell);
        }
        if (link instanceof JavaLink) {
            return new JavaLinkAdapter(match, shell, project);
        }
        return null;
    }

    public void lineGetStyle(LineStyleEvent event) {
        StyleRange[] styles;
        TextFilter textFilter;
        GrepStyleRange[] styleArray;
        if (event.lineText.length() == 0 || this.items == null || this.items.isEmpty()) {
            return;
        }
        LinkedList<GrepStyleRange> grepStyles = null;
        if (event.getSource() instanceof StyledText && ((StyledText)event.getSource()).getContent() instanceof TextFilter && (styleArray = (textFilter = (TextFilter)((StyledText)event.getSource()).getContent()).getLineStyles(textFilter.getLineAtOffset(event.lineOffset))) != null) {
            grepStyles = new LinkedList();
            GrepStyleRange[] grepStyleRangeArray = styleArray;
            int n = styleArray.length;
            int n2 = 0;
            while (n2 < n) {
                GrepStyleRange style = grepStyleRangeArray[n2];
                grepStyles.add(style);
                ++n2;
            }
        }
        if (grepStyles == null) {
            grepStyles = this.lineGetStyle(event.lineOffset, event.lineText, true, false, event.styles == null || event.styles.length == 0 ? null : event.styles);
        }
        if ((styles = this.convertStyles(event.lineOffset, event.lineText, event.styles == null || event.styles.length == 0 ? null : event.styles, grepStyles)) != null) {
            event.styles = styles;
        }
    }

    public StyleRange lineGetStyleAt(int lineOffset, String lineText, int charOffset, boolean styles, boolean links) {
        LinkedList<GrepStyleRange> grepStyleRanges = this.lineGetStyle(lineOffset, lineText, styles, links, null);
        StyleRange[] ranges = this.convertStyles(lineOffset, lineText, null, grepStyleRanges);
        if (ranges == null) {
            return null;
        }
        StyleRange[] styleRangeArray = ranges;
        int n = ranges.length;
        int n2 = 0;
        while (n2 < n) {
            StyleRange range = styleRangeArray[n2];
            if (range.start > charOffset) {
                return null;
            }
            if (range.start + range.length >= charOffset) {
                return range;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void participantAdded(GrepPageParticipant participant) {
    }

    @Override
    public void participantRemoved(GrepPageParticipant participant) {
    }

    @Override
    public void participantActivated(GrepPageParticipant participant) {
    }

    @Override
    public void settingsChanged() {
        this.matchLength = Activator.getDefault().getStyleMatchLength();
    }

    public LinkedList<GrepStyleRange> lineGetStyle(int lineOffset, String lineText, boolean styles, boolean links, StyleRange[] originalStyleRanges) {
        String matchText = this.matchLength <= 0 || lineText.length() <= this.matchLength ? lineText : lineText.substring(0, this.matchLength);
        LinkedList<GrepStyleRange> grepStyleRanges = new LinkedList<GrepStyleRange>();
        int index = 0;
        for (GrepExpressionItem item : this.items) {
            this.calculateStyleRanges(index, lineText, matchText, lineOffset, item, grepStyleRanges, styles, links);
            ++index;
        }
        if (grepStyleRanges.isEmpty()) {
            return null;
        }
        return grepStyleRanges;
    }

    public StyleRange[] convertStyles(int lineOffset, String lineText, StyleRange[] originalStyleRanges, LinkedList<GrepStyleRange> grepStyleRanges) {
        if (grepStyleRanges == null || grepStyleRanges.isEmpty()) {
            return null;
        }
        if (originalStyleRanges != null) {
            boolean useExistingStyleRanges = true;
            for (GrepStyleRange range : grepStyleRanges) {
                if (range.getExpressionItem() == null || !range.getExpressionItem().isRemoveOriginalStyle()) continue;
                useExistingStyleRanges = false;
                break;
            }
            if (useExistingStyleRanges) {
                int lineLength = lineText.length();
                StyleRange[] styleRangeArray = originalStyleRanges;
                int n = originalStyleRanges.length;
                int n2 = 0;
                while (n2 < n) {
                    StyleRange range = styleRangeArray[n2];
                    if (range.start + range.length > lineOffset && range.start < lineOffset + lineLength) {
                        int rangeStart = Math.max(range.start - lineOffset, 0);
                        int rangeEnd = Math.min(range.start + range.length - lineOffset - 1, lineLength - 1);
                        grepStyleRanges.add(new GrepStyleRange(rangeStart, rangeEnd, range));
                    }
                    ++n2;
                }
            }
        }
        Collections.sort(grepStyleRanges, STYLE_RANGE_COMPARATOR);
        TreeSet<Integer> indexes = new TreeSet<Integer>();
        for (GrepStyleRange range : grepStyleRanges) {
            indexes.add(range.getFirstIndex());
            indexes.add(range.getLastIndex() + 1);
        }
        LinkedList<StyleRange> styleRanges = new LinkedList<StyleRange>();
        LinkedList<GrepStyleRange> activeGrepStyleRanges = new LinkedList<GrepStyleRange>();
        int currentIndex = (Integer)indexes.pollFirst();
        while (!indexes.isEmpty()) {
            boolean activeStylesChanged = false;
            Integer nextIndex = (Integer)indexes.pollFirst();
            LinkedList<GrepStyleRange> removeActive = new LinkedList<GrepStyleRange>();
            for (GrepStyleRange range : activeGrepStyleRanges) {
                if (range.getLastIndex() >= currentIndex) continue;
                removeActive.add(range);
                activeStylesChanged = true;
            }
            activeGrepStyleRanges.removeAll(removeActive);
            while (!grepStyleRanges.isEmpty() && grepStyleRanges.getFirst().getFirstIndex() == currentIndex) {
                activeGrepStyleRanges.add(grepStyleRanges.removeFirst());
                activeStylesChanged = true;
            }
            if (activeStylesChanged) {
                Collections.sort(activeGrepStyleRanges, STYLE_RANGE_COMPARATOR_SUB_BEFORE_WHOLE);
            }
            StyleRange styleRange = new StyleRange();
            styleRange.start = lineOffset + currentIndex;
            styleRange.length = nextIndex - currentIndex;
            if (!activeGrepStyleRanges.isEmpty()) {
                this.collapseStyles(activeGrepStyleRanges, styleRange);
                styleRanges.add(styleRange);
            }
            currentIndex = nextIndex;
        }
        return styleRanges.isEmpty() ? null : styleRanges.toArray(new StyleRange[0]);
    }

    public void collapseStyles(List<GrepStyleRange> grepStyleRanges, StyleRange styleRange) {
        StyleRange originalRange = null;
        for (GrepStyleRange grepStyleRange : grepStyleRanges) {
            GrepStyle style;
            if (originalRange == null) {
                originalRange = grepStyleRange.getStyleRange();
            }
            if ((style = grepStyleRange.getStyle()) != null) {
                if (styleRange.foreground == null && style.getForeground() != null) {
                    styleRange.foreground = this.colorRegistry.get(style.getForeground());
                }
                if (styleRange.background == null && style.getBackground() != null) {
                    styleRange.background = this.colorRegistry.get(style.getBackground());
                }
                styleRange.fontStyle = styleRange.fontStyle | ((style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0));
                styleRange.underline |= style.isUnderline();
                if (styleRange.underlineColor == null && style.getUnderlineColor() != null) {
                    styleRange.underlineColor = this.colorRegistry.get(style.getUnderlineColor());
                }
                styleRange.strikeout |= style.isStrikeout();
                if (styleRange.strikeoutColor == null && style.getStrikeoutColor() != null) {
                    styleRange.strikeoutColor = this.colorRegistry.get(style.getStrikeoutColor());
                }
                styleRange.borderStyle = styleRange.borderStyle | (style.isBorder() ? 1 : 0);
                if (styleRange.borderColor == null && style.getBorderColor() != null) {
                    styleRange.borderColor = this.colorRegistry.get(style.getBorderColor());
                }
            }
            if (styleRange.data != null || grepStyleRange.getLinkMatch() == null) continue;
            styleRange.data = GrepLineStyleListener.createLinkAdapter(grepStyleRange.getLinkMatch(), this.shell, this.project);
        }
        if (originalRange != null) {
            this.copyStyleRangeFields(originalRange, styleRange);
        }
    }

    private void copyStyleRangeFields(StyleRange src, StyleRange dest) {
        if (dest.background == null) {
            dest.background = src.background;
        }
        if (dest.borderColor == null) {
            dest.borderColor = src.borderColor;
        }
        dest.borderStyle |= src.borderStyle;
        if (dest.data == null) {
            dest.data = src.data;
        }
        if (dest.font == null) {
            dest.font = src.font;
        }
        dest.fontStyle |= src.fontStyle;
        if (dest.foreground == null) {
            dest.foreground = src.foreground;
        }
        if (dest.metrics == null) {
            dest.metrics = src.metrics;
        }
        if (dest.rise == 0) {
            dest.rise = src.rise;
        }
        dest.strikeout |= src.strikeout;
        if (dest.strikeoutColor == null) {
            dest.strikeoutColor = src.strikeoutColor;
        }
        dest.underline |= src.underline;
        if (dest.underlineColor == null) {
            dest.underlineColor = src.underlineColor;
        }
        dest.underlineStyle |= src.underlineStyle;
    }

    protected void calculateStyleRanges(int expressionIndex, String text, String matchText, int lineOffset, GrepExpressionItem item, List<GrepStyleRange> styleRanges, boolean styles, boolean links) {
        Pattern pattern = item.getPattern();
        if (pattern == null) {
            return;
        }
        Pattern quickPattern = item.getQuickPattern();
        if (quickPattern != null && !quickPattern.matcher(matchText).find()) {
            return;
        }
        Matcher matcher = pattern.matcher(quickPattern == null ? matchText : text);
        boolean first = true;
        while (matcher.find()) {
            if (first) {
                IGrepLink link;
                Matcher unlessMatcher;
                first = false;
                Pattern unlessPattern = item.getUnlessPattern();
                if (unlessPattern != null && (unlessMatcher = unlessPattern.matcher(quickPattern == null ? matchText : text)).find()) {
                    return;
                }
                GrepStyle style = styles ? item.getGroups()[0].getStyle() : null;
                IGrepLink iGrepLink = link = links ? item.getGroups()[0].getLink() : null;
                if (style != null || link != null) {
                    styleRanges.add(new GrepStyleRange(item, expressionIndex, true, 0, text.length() - 1, style, link, matcher, text, 0, this.project));
                }
            }
            GrepGroup[] groups = item.getGroups();
            int i = 1;
            while (i <= matcher.groupCount()) {
                int start;
                GrepGroup group;
                GrepGroup grepGroup = group = i < groups.length ? groups[i] : null;
                if (group != null && (start = matcher.start(i)) >= 0) {
                    int length = matcher.group(i).length();
                    GrepStyle groupStyle = styles ? group.getStyle() : null;
                    IGrepLink groupLink = links ? group.getLink() : null;
                    styleRanges.add(new GrepStyleRange(item, expressionIndex, false, start, start + length - 1, groupStyle, groupLink, matcher, text, i, this.project));
                }
                ++i;
            }
        }
    }
}

