/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.launch;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.AbstractGrepModelElement;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionRootFolder;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionsWithSelection;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import name.schedenig.eclipse.grepconsole.view.items.ItemsAndStylesDialog;
import name.schedenig.eclipse.grepconsole.view.items.ItemsTreePanel;
import name.schedenig.eclipse.grepconsole.view.whatsnew.WhatsNewDialog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class GrepConsoleLaunchConfigurationTab
extends AbstractLaunchConfigurationTab
implements ItemsTreePanel.IItemTreeListener {
    private Map<String, Boolean> enablementMap;
    private Map<String, Boolean> filterMap;
    private Map<String, Boolean> statisticsMap;
    private Map<String, Boolean> notificationsMap;
    private ILaunchConfiguration configuration;
    private ItemsTreePanel treePanel;
    private Button btnConfigure;

    public String getName() {
        return Messages.GrepConsoleLaunchConfigurationTab_title_grep_console;
    }

    public Image getImage() {
        return Activator.getDefault().getImageRegistry().get("logo_small");
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        this.setControl((Control)root);
        GridLayout layout = new GridLayout(1, false);
        root.setLayout((Layout)layout);
        this.treePanel = new ItemsTreePanel(root, 2048);
        this.treePanel.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.treePanel.addListener(this);
        this.btnConfigure = new Button(root, 8);
        this.btnConfigure.setText(Messages.GrepConsoleLaunchConfigurationTab_configure_expressions);
        this.btnConfigure.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 1, 1));
        this.btnConfigure.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrepConsoleLaunchConfigurationTab.this.doConfigureExpressions();
            }
        });
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        super.activated(workingCopy);
        WhatsNewDialog.showIfEnabled(this.getShell());
    }

    protected void doConfigureExpressions() {
        Activator activator = Activator.getDefault();
        GrepExpressionRootFolder activatorExpressions = activator.getExpressions();
        GrepExpressionsWithSelection expressions = new GrepExpressionsWithSelection(activatorExpressions.copy(true), null, null, null, null);
        ItemsAndStylesDialog dlg = new ItemsAndStylesDialog(this.getShell());
        dlg.setExpressions(expressions);
        dlg.setLaunchConfiguration(this.configuration);
        if (dlg.open() == 0) {
            activatorExpressions.copyFrom(expressions.getRootFolder(), true);
            this.treePanel.refresh();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.configuration = configuration;
        Activator activator = Activator.getDefault();
        try {
            try {
                this.enablementMap = GrepConsoleUtil.loadIdBooleanMap("name.schedenig.eclipse.grepconsole.EnabledIds", "name.schedenig.eclipse.grepconsole.DisabledIds", configuration);
            }
            catch (CoreException ex) {
                this.enablementMap = new HashMap<String, Boolean>();
                throw ex;
            }
            try {
                this.filterMap = GrepConsoleUtil.loadIdBooleanMap("name.schedenig.eclipse.grepconsole.FilterEnabledIds", "name.schedenig.eclipse.grepconsole.FilterDisabledIds", configuration);
            }
            catch (CoreException ex) {
                this.filterMap = new HashMap<String, Boolean>();
                throw ex;
            }
            try {
                this.statisticsMap = GrepConsoleUtil.loadIdBooleanMap("name.schedenig.eclipse.grepconsole.StatisticsEnabledIds", "name.schedenig.eclipse.grepconsole.StatisticsDisabledIds", configuration);
            }
            catch (CoreException ex) {
                this.statisticsMap = new HashMap<String, Boolean>();
                throw ex;
            }
            try {
                this.notificationsMap = GrepConsoleUtil.loadIdBooleanMap("name.schedenig.eclipse.grepconsole.NotificationsEnabledIds", "name.schedenig.eclipse.grepconsole.NotificationsDisabledIds", configuration);
            }
            catch (CoreException ex) {
                this.notificationsMap = new HashMap<String, Boolean>();
                throw ex;
            }
        }
        catch (CoreException ex) {
            Activator.getDefault().log(4, Messages.Error_could_not_read_launch_configuration, ex);
        }
        this.treePanel.setExpressions(new GrepExpressionsWithSelection(activator.getExpressions(), this.enablementMap, this.filterMap, this.statisticsMap, this.notificationsMap));
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        GrepConsoleUtil.storeIdBooleanMap("name.schedenig.eclipse.grepconsole.EnabledIds", "name.schedenig.eclipse.grepconsole.DisabledIds", this.enablementMap, configuration);
        GrepConsoleUtil.storeIdBooleanMap("name.schedenig.eclipse.grepconsole.FilterEnabledIds", "name.schedenig.eclipse.grepconsole.FilterDisabledIds", this.filterMap, configuration);
        GrepConsoleUtil.storeIdBooleanMap("name.schedenig.eclipse.grepconsole.StatisticsEnabledIds", "name.schedenig.eclipse.grepconsole.StatisticsDisabledIds", this.statisticsMap, configuration);
    }

    @Override
    public void enabledExpressionsChanged() {
        this.updateLaunchConfigurationDialog();
    }

    @Override
    public void filterExpressionsChanged() {
        this.updateLaunchConfigurationDialog();
    }

    @Override
    public void statisticsExpressionsChanged() {
        this.updateLaunchConfigurationDialog();
    }

    @Override
    public void notificationsExpressionsChanged() {
        this.updateLaunchConfigurationDialog();
    }

    @Override
    public void elementDoubleClicked(AbstractGrepModelElement element) {
    }

    @Override
    public void elementSelectionChanged(Set<AbstractGrepModelElement> elements) {
    }
}

