/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.model;

import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import name.schedenig.eclipse.grepconsole.model.AbstractGrepModelElement;
import name.schedenig.eclipse.grepconsole.model.GrepGroup;
import name.schedenig.eclipse.grepconsole.model.GrepStyle;
import name.schedenig.eclipse.grepconsole.model.links.IGrepLink;

public class GrepExpressionItem
extends AbstractGrepModelElement {
    private String grepExpression;
    private String quickGrepExpression;
    private String unlessGrepExpression;
    private GrepGroup[] groups;
    private Pattern pattern;
    private Pattern unlessPattern;
    private Pattern quickPattern;
    private boolean caseInsensitive;
    private boolean removeOriginalStyle;
    private String rewriteExpression;
    private GrepGroup[] rewriteGroups;
    private IGrepLink autostartLink;
    private boolean popupNotification;
    private String notificationTitle;
    private String notificationMessage;
    private IGrepLink notificationLink;
    private String soundNotificationPath;
    private String statisticsCountLabel;
    private String statisticsValueLabel;
    private String statisticsValuePattern;
    private int errorLogLevel;
    private String errorLogMessage;

    public GrepExpressionItem() {
        this(null);
    }

    public GrepExpressionItem(String id) {
        super(id);
        this.groups = new GrepGroup[0];
        this.rewriteGroups = new GrepGroup[0];
    }

    public GrepExpressionItem(GrepExpressionItem src, boolean identityCopy) {
        super(src, identityCopy);
    }

    @Override
    public GrepExpressionItem copy(boolean identityCopy) {
        return new GrepExpressionItem(this, identityCopy);
    }

    @Override
    public void copyFrom(AbstractGrepModelElement src, boolean identityCopy) {
        super.copyFrom(src, identityCopy);
        GrepExpressionItem item = (GrepExpressionItem)src;
        this.grepExpression = item.grepExpression;
        this.quickGrepExpression = item.quickGrepExpression;
        this.unlessGrepExpression = item.unlessGrepExpression;
        this.rewriteExpression = item.getRewriteExpression();
        this.groups = new GrepGroup[item.groups.length];
        int i = 0;
        while (i < this.groups.length) {
            this.groups[i] = new GrepGroup(item.groups[i], true);
            ++i;
        }
        GrepGroup[] grepGroupArray = this.rewriteGroups = item.rewriteGroups == null ? null : new GrepGroup[item.rewriteGroups.length];
        if (this.rewriteGroups != null) {
            i = 0;
            while (i < this.rewriteGroups.length) {
                this.rewriteGroups[i] = new GrepGroup(item.rewriteGroups[i], true);
                ++i;
            }
        }
        this.caseInsensitive = item.caseInsensitive;
        this.removeOriginalStyle = item.removeOriginalStyle;
        this.autostartLink = item.autostartLink == null ? null : item.autostartLink.copy();
        this.popupNotification = item.popupNotification;
        this.notificationTitle = item.notificationTitle;
        this.notificationMessage = item.notificationMessage;
        this.notificationLink = item.notificationLink == null ? null : item.notificationLink.copy();
        this.statisticsCountLabel = item.statisticsCountLabel;
        this.statisticsValueLabel = item.statisticsValueLabel;
        this.statisticsValuePattern = item.statisticsValuePattern;
        this.soundNotificationPath = item.soundNotificationPath;
        this.errorLogLevel = item.errorLogLevel;
        this.errorLogMessage = item.errorLogMessage;
    }

    public String getGrepExpression() {
        return this.grepExpression;
    }

    public void setGrepExpression(String grepExpression) {
        if (this.grepExpression == null || grepExpression == null || !this.grepExpression.equals(grepExpression)) {
            this.grepExpression = grepExpression;
            this.pattern = null;
        }
    }

    public String getUnlessGrepExpression() {
        return this.unlessGrepExpression;
    }

    public void setUnlessGrepExpression(String unlessGrepExpression) {
        if (this.unlessGrepExpression == null || unlessGrepExpression == null || !this.unlessGrepExpression.equals(unlessGrepExpression)) {
            this.unlessGrepExpression = unlessGrepExpression;
            this.unlessPattern = null;
        }
    }

    public GrepGroup[] getGroups() {
        return this.groups;
    }

    public void setGroups(GrepGroup[] groups) {
        this.groups = groups;
    }

    @Override
    public void findStyleUses(GrepStyle style, Set<GrepExpressionItem> items) {
        GrepGroup[] grepGroupArray = this.groups;
        int n = this.groups.length;
        int n2 = 0;
        while (n2 < n) {
            GrepGroup group = grepGroupArray[n2];
            if (group.getStyle() == style) {
                items.add(this);
                break;
            }
            ++n2;
        }
    }

    public Pattern getPattern() {
        if (this.pattern == null && this.grepExpression != null) {
            this.pattern = this.compilePattern(this.grepExpression);
        }
        return this.pattern;
    }

    public Pattern getUnlessPattern() {
        if (this.unlessPattern == null && this.unlessGrepExpression != null) {
            this.unlessPattern = this.compilePattern(this.unlessGrepExpression);
        }
        return this.unlessPattern;
    }

    private Pattern compilePattern(String expression) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(expression, this.computeFlags());
        }
        catch (PatternSyntaxException patternSyntaxException) {
            pattern = null;
        }
        return pattern;
    }

    private int computeFlags() {
        return this.caseInsensitive ? 66 : 0;
    }

    @Override
    protected void refreshStyles() {
        int i = 0;
        while (i < this.groups.length) {
            if (this.groups[i].getStyle() != null) {
                this.groups[i].setStyle(this.getRoot().getStyle(this.groups[i].getStyle().getId()));
            }
            ++i;
        }
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        if (caseInsensitive != this.caseInsensitive) {
            this.caseInsensitive = caseInsensitive;
            this.pattern = null;
            this.unlessPattern = null;
        }
    }

    public boolean isRemoveOriginalStyle() {
        return this.removeOriginalStyle;
    }

    public void setRemoveOriginalStyle(boolean removeOriginalStyle) {
        this.removeOriginalStyle = removeOriginalStyle;
    }

    public String getRewriteExpression() {
        return this.rewriteExpression;
    }

    public void setRewriteExpression(String rewriteExpression) {
        this.rewriteExpression = rewriteExpression;
    }

    public GrepGroup[] getRewriteGroups() {
        return this.rewriteGroups;
    }

    public void setRewriteGroups(GrepGroup[] rewriteGroups) {
        this.rewriteGroups = rewriteGroups;
    }

    public IGrepLink getAutostartLink() {
        return this.autostartLink;
    }

    public void setAutostartLink(IGrepLink autostartLink) {
        this.autostartLink = autostartLink;
    }

    public String getQuickGrepExpression() {
        return this.quickGrepExpression;
    }

    public void setQuickGrepExpression(String quickGrepExpression) {
        if (this.quickGrepExpression == null || quickGrepExpression == null || !this.quickGrepExpression.equals(quickGrepExpression)) {
            this.quickGrepExpression = quickGrepExpression;
            this.quickPattern = null;
        }
    }

    public Pattern getQuickPattern() {
        if (this.quickPattern == null && this.quickGrepExpression != null) {
            this.quickPattern = this.compilePattern(this.quickGrepExpression);
        }
        return this.quickPattern;
    }

    public boolean isPopupNotification() {
        return this.popupNotification;
    }

    public void setPopupNotification(boolean popupNotification) {
        this.popupNotification = popupNotification;
    }

    public String getNotificationTitle() {
        return this.notificationTitle;
    }

    public void setNotificationTitle(String notificationTitle) {
        this.notificationTitle = notificationTitle;
    }

    public String getNotificationMessage() {
        return this.notificationMessage;
    }

    public void setNotificationMessage(String notificationMessage) {
        this.notificationMessage = notificationMessage;
    }

    public IGrepLink getNotificationLink() {
        return this.notificationLink;
    }

    public void setNotificationLink(IGrepLink notificationLink) {
        this.notificationLink = notificationLink;
    }

    public String getSoundNotificationPath() {
        return this.soundNotificationPath;
    }

    public void setSoundNotificationPath(String soundNotificationPath) {
        this.soundNotificationPath = soundNotificationPath;
    }

    public String getStatisticsCountLabel() {
        return this.statisticsCountLabel;
    }

    public void setStatisticsCountLabel(String statisticsCountLabel) {
        this.statisticsCountLabel = statisticsCountLabel;
    }

    public String getStatisticsValueLabel() {
        return this.statisticsValueLabel;
    }

    public void setStatisticsValueLabel(String statisticsValueLabel) {
        this.statisticsValueLabel = statisticsValueLabel;
    }

    public String getStatisticsValuePattern() {
        return this.statisticsValuePattern;
    }

    public void setStatisticsValuePattern(String statisticsValuePattern) {
        this.statisticsValuePattern = statisticsValuePattern;
    }

    public int getErrorLogLevel() {
        return this.errorLogLevel;
    }

    public void setErrorLogLevel(int errorLogLevel) {
        this.errorLogLevel = errorLogLevel;
    }

    public String getErrorLogMessage() {
        return this.errorLogMessage;
    }

    public void setErrorLogMessage(String errorLogMessage) {
        this.errorLogMessage = errorLogMessage;
    }
}

